/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPConnSetupMgr;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedResponse;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPMessageQueue;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.LDAPTLSSocketFactory;
import netscape.ldap.LDAPTraceWriter;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPUnbindRequest;

class LDAPConnThread
implements Runnable {
    private static final int MAXMSGID = Integer.MAX_VALUE;
    private static final int BACKLOG_CHKCNT = 50;
    private static transient int m_highMsgId;
    private transient InputStream m_serverInput;
    private transient InputStream m_origServerInput;
    private transient OutputStream m_serverOutput;
    private transient OutputStream m_origServerOutput;
    private transient Hashtable m_requests;
    private transient Hashtable m_messages = null;
    private transient Vector m_registered;
    private transient LDAPCache m_cache = null;
    private transient Thread m_thread = null;
    private transient Object m_sendRequestLock = new Object();
    private static transient Object m_msgIdLock;
    private transient LDAPConnSetupMgr m_connMgr = null;
    private transient Object m_traceOutput = null;
    private transient int m_backlogCheckCounter = 50;
    private transient boolean m_bound;
    private static transient int m_nextId;
    private transient int m_id;
    static SimpleDateFormat m_timeFormat;

    public LDAPConnThread(LDAPConnSetupMgr lDAPConnSetupMgr, LDAPCache lDAPCache, Object object) {
        this.m_requests = new Hashtable();
        this.m_registered = new Vector();
        this.m_connMgr = lDAPConnSetupMgr;
        this.setCache(lDAPCache);
        this.setTraceOutput(object);
    }

    synchronized void connect(LDAPConnection lDAPConnection) throws LDAPException {
        CharSequence charSequence;
        if (this.m_thread != null) {
            return;
        }
        try {
            this.m_connMgr.openConnection();
            this.m_serverInput = new BufferedInputStream(this.m_connMgr.getSocket().getInputStream());
            this.m_serverOutput = new BufferedOutputStream(this.m_connMgr.getSocket().getOutputStream());
            this.register(lDAPConnection);
        }
        catch (IOException iOException) {
            throw new LDAPException("failed to connect to server " + this.m_connMgr.getHost(), 91);
        }
        this.m_id = m_nextId++;
        String string = this.m_connMgr.getLDAPUrl().getServerUrl();
        if (this.m_traceOutput != null) {
            charSequence = new StringBuffer(" Connected to ");
            charSequence.append(string);
            this.logTraceMessage((StringBuffer)charSequence);
        }
        charSequence = "LDAPConnThread-" + this.m_id + " " + string;
        this.m_thread = new Thread((Runnable)this, (String)charSequence);
        this.m_thread.setDaemon(true);
        this.m_thread.start();
    }

    public synchronized String toString() {
        if (this.m_thread != null) {
            return this.m_thread.getName();
        }
        return "LDAPConnThread-" + this.m_id + " <disconnected>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void layerSocket(LDAPTLSSocketFactory lDAPTLSSocketFactory) throws Exception {
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            try {
                this.m_connMgr.layerSocket(lDAPTLSSocketFactory);
                this.setInputStream(this.m_connMgr.getSocket().getInputStream());
                this.setOutputStream(this.m_connMgr.getSocket().getOutputStream());
            }
            catch (Exception exception) {
                this.m_serverInput = this.m_origServerInput;
                this.m_serverOutput = this.m_origServerOutput;
                throw exception;
            }
        }
    }

    void setBound(boolean bl) {
        this.m_bound = bl;
    }

    boolean isBound() {
        return this.m_thread != null && this.m_bound;
    }

    InputStream getInputStream() {
        return this.m_serverInput;
    }

    void setInputStream(InputStream inputStream) {
        this.m_serverInput = inputStream;
    }

    OutputStream getOutputStream() {
        return this.m_serverOutput;
    }

    void setOutputStream(OutputStream outputStream) {
        this.m_serverOutput = outputStream;
    }

    int getRequestCount() {
        return this.m_requests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTraceOutput(Object object) {
        Object object2 = this.m_sendRequestLock;
        synchronized (object2) {
            if (object == null) {
                this.m_traceOutput = null;
            } else if (object instanceof OutputStream) {
                this.m_traceOutput = new PrintWriter((OutputStream)object);
            } else if (object instanceof LDAPTraceWriter) {
                this.m_traceOutput = object;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logTraceMessage(StringBuffer stringBuffer) {
        String string = m_timeFormat.format(new Date());
        StringBuffer stringBuffer2 = new StringBuffer(string);
        stringBuffer2.append(" ldc=");
        stringBuffer2.append(this.m_id);
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            if (this.m_traceOutput instanceof PrintWriter) {
                PrintWriter printWriter = (PrintWriter)this.m_traceOutput;
                printWriter.print(stringBuffer2);
                printWriter.println(stringBuffer);
                printWriter.flush();
            } else if (this.m_traceOutput instanceof LDAPTraceWriter) {
                stringBuffer2.append(stringBuffer);
                ((LDAPTraceWriter)this.m_traceOutput).write(stringBuffer2.toString());
            }
        }
    }

    synchronized void setCache(LDAPCache lDAPCache) {
        this.m_cache = lDAPCache;
        this.m_messages = this.m_cache != null ? new Hashtable() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocateId() {
        Object object = m_msgIdLock;
        synchronized (object) {
            m_highMsgId = (m_highMsgId + 1) % Integer.MAX_VALUE;
            return m_highMsgId;
        }
    }

    void sendRequest(LDAPConnection lDAPConnection, JDAPProtocolOp jDAPProtocolOp, LDAPMessageQueue lDAPMessageQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (this.m_thread == null) {
            throw new LDAPException("Not connected to a server", 81);
        }
        LDAPMessage lDAPMessage = new LDAPMessage(this.allocateId(), jDAPProtocolOp, lDAPConstraints.getServerControls());
        if (lDAPMessageQueue != null) {
            this.m_requests.put(new Integer(lDAPMessage.getMessageID()), lDAPMessageQueue);
            this.resultRetrieved();
            lDAPMessageQueue.addRequest(lDAPMessage.getMessageID(), lDAPConnection, this, lDAPConstraints.getTimeLimit());
        }
        if (!this.sendRequest(lDAPMessage, false)) {
            throw new LDAPException("Server or network error", 81);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendRequest(LDAPMessage lDAPMessage, boolean bl) {
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            block8: {
                try {
                    if (this.m_traceOutput != null) {
                        this.logTraceMessage(lDAPMessage.toTraceString());
                    }
                    lDAPMessage.write(this.m_serverOutput);
                    this.m_serverOutput.flush();
                    return true;
                }
                catch (IOException iOException) {
                    if (!bl) {
                        this.networkError(iOException);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if (bl || this.m_thread == null) break block8;
                    throw nullPointerException;
                }
            }
            return false;
        }
    }

    private void sendUnbindRequest(LDAPControl[] lDAPControlArray) {
        LDAPMessage lDAPMessage = new LDAPMessage(this.allocateId(), new JDAPUnbindRequest(), lDAPControlArray);
        this.sendRequest(lDAPMessage, true);
    }

    private void sendAbandonRequest(int n, LDAPControl[] lDAPControlArray) {
        LDAPMessage lDAPMessage = new LDAPMessage(this.allocateId(), new JDAPAbandonRequest(n), lDAPControlArray);
        this.sendRequest(lDAPMessage, true);
    }

    public synchronized void register(LDAPConnection lDAPConnection) {
        if (!this.m_registered.contains(lDAPConnection)) {
            this.m_registered.addElement(lDAPConnection);
        }
    }

    int getClientCount() {
        return this.m_registered.size();
    }

    boolean isConnected() {
        return this.m_thread != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deregister(LDAPConnection lDAPConnection) {
        if (this.m_thread == null) {
            return;
        }
        this.m_registered.removeElement(lDAPConnection);
        if (this.m_registered.size() == 0) {
            Thread thread = this.m_thread;
            this.m_thread = null;
            try {
                this.sendUnbindRequest(lDAPConnection.getConstraints().getServerControls());
                try {
                    thread.interrupt();
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (Exception exception) {
                LDAPConnection.printDebug(exception.toString());
            }
            finally {
                this.cleanUp(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp(LDAPException lDAPException) {
        this.resultRetrieved();
        try {
            this.m_serverOutput.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.m_serverOutput = null;
        }
        try {
            this.m_serverInput.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.m_serverInput = null;
        }
        if (this.m_origServerInput != null) {
            try {
                this.m_origServerInput.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.m_origServerInput = null;
            }
        }
        if (this.m_origServerOutput != null) {
            try {
                this.m_origServerOutput.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.m_origServerOutput = null;
            }
        }
        if (lDAPException != null) {
            this.m_connMgr.invalidateConnection();
        } else {
            this.m_connMgr.closeConnection();
        }
        Enumeration enumeration = this.m_requests.elements();
        while (enumeration.hasMoreElements()) {
            try {
                LDAPMessageQueue lDAPMessageQueue = (LDAPMessageQueue)enumeration.nextElement();
                if (lDAPException != null) {
                    lDAPMessageQueue.setException(this, lDAPException);
                    continue;
                }
                lDAPMessageQueue.removeAllRequests(this);
            }
            catch (Exception exception) {}
        }
        this.m_requests.clear();
        if (this.m_messages != null) {
            this.m_messages.clear();
        }
        this.m_bound = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBacklog() throws InterruptedException {
        while (this.m_requests.size() != 0) {
            Object object;
            Enumeration enumeration = this.m_requests.elements();
            while (enumeration.hasMoreElements()) {
                object = (LDAPMessageQueue)enumeration.nextElement();
                if (!(object instanceof LDAPSearchListener)) {
                    return;
                }
                LDAPSearchListener lDAPSearchListener = (LDAPSearchListener)object;
                if (lDAPSearchListener.getSearchConstraints() == null) {
                    return;
                }
                int n = lDAPSearchListener.getSearchConstraints().getMaxBacklog();
                int n2 = lDAPSearchListener.getSearchConstraints().getBatchSize();
                if (n == 0) {
                    return;
                }
                if (!lDAPSearchListener.isAsynchOp() && n2 == 0) {
                    return;
                }
                if (lDAPSearchListener.getMessageCount() >= n) continue;
                return;
            }
            object = this;
            synchronized (object) {
                this.wait(3000L);
            }
        }
        return;
    }

    synchronized void resultRetrieved() {
        this.notifyAll();
    }

    public void run() {
        LDAPMessage lDAPMessage = null;
        JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
        int[] nArray = new int[1];
        while (Thread.currentThread() == this.m_thread) {
            try {
                if (--this.m_backlogCheckCounter <= 0) {
                    this.m_backlogCheckCounter = 50;
                    this.checkBacklog();
                }
                nArray[0] = 0;
                BERElement bERElement = BERElement.getElement(jDAPBERTagDecoder, this.m_serverInput, nArray);
                lDAPMessage = LDAPMessage.parseMessage(bERElement);
                if (this.m_traceOutput != null) {
                    this.logTraceMessage(lDAPMessage.toTraceString());
                }
                this.processResponse(lDAPMessage, nArray[0]);
                Thread.yield();
            }
            catch (Exception exception) {
                if (Thread.currentThread() == this.m_thread) {
                    this.networkError(exception);
                    continue;
                }
                this.resultRetrieved();
            }
        }
    }

    private void processResponse(LDAPMessage lDAPMessage, int n) {
        Integer n2 = new Integer(lDAPMessage.getMessageID());
        LDAPMessageQueue lDAPMessageQueue = (LDAPMessageQueue)this.m_requests.get(n2);
        if (lDAPMessageQueue == null) {
            return;
        }
        if (this.m_cache != null && lDAPMessageQueue instanceof LDAPSearchListener) {
            this.cacheSearchResult((LDAPSearchListener)lDAPMessageQueue, lDAPMessage, n);
        }
        if (lDAPMessageQueue.getMessageID() != n2.intValue()) {
            return;
        }
        lDAPMessageQueue.addMessage(lDAPMessage);
        if (lDAPMessage instanceof LDAPResponse) {
            this.m_requests.remove(n2);
            if (this.m_requests.size() == 0) {
                this.m_backlogCheckCounter = 50;
            }
            if (lDAPMessage instanceof LDAPExtendedResponse) {
                LDAPExtendedResponse lDAPExtendedResponse = (LDAPExtendedResponse)lDAPMessage;
                String string = lDAPExtendedResponse.getID();
                if (lDAPExtendedResponse.getResultCode() == 0 && string != null && string.equals("1.3.6.1.4.1.1466.20037")) {
                    this.changeIOStreams();
                }
            }
        }
    }

    private void changeIOStreams() {
        this.m_origServerInput = this.m_serverInput;
        this.m_origServerOutput = this.m_serverOutput;
        this.m_serverInput = null;
        this.m_serverOutput = null;
        while (this.m_serverInput == null || this.m_serverOutput == null) {
            try {
                if (Thread.currentThread() != this.m_thread) {
                    return;
                }
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void cacheSearchResult(LDAPSearchListener lDAPSearchListener, LDAPMessage lDAPMessage, int n) {
        Integer n2 = new Integer(lDAPMessage.getMessageID());
        Long l = lDAPSearchListener.getKey();
        Vector vector = null;
        if (this.m_cache == null || l == null) {
            return;
        }
        if (lDAPMessage instanceof LDAPSearchResult) {
            vector = (Vector)this.m_messages.get(n2);
            if (vector == null) {
                vector = new Vector();
                this.m_messages.put(n2, vector);
                vector.addElement(new Long(0L));
            }
            if ((Long)vector.firstElement() == -1L) {
                return;
            }
            long l2 = (Long)vector.firstElement() + (long)n;
            if (l2 > this.m_cache.getSize()) {
                vector.removeAllElements();
                vector.addElement(new Long(-1L));
                return;
            }
            vector.setElementAt(new Long(l2), 0);
            vector.addElement(((LDAPSearchResult)lDAPMessage).getEntry());
        } else if (lDAPMessage instanceof LDAPSearchResultReference) {
            vector = (Vector)this.m_messages.get(n2);
            if (vector == null) {
                vector = new Vector();
                this.m_messages.put(n2, vector);
            } else {
                vector.removeAllElements();
            }
            vector.addElement(new Long(-1L));
        } else if (lDAPMessage instanceof LDAPResponse) {
            boolean bl = ((LDAPResponse)lDAPMessage).getResultCode() > 0;
            vector = (Vector)this.m_messages.remove(n2);
            if (!bl) {
                if (vector == null) {
                    vector = new Vector();
                    vector.addElement(new Long(0L));
                }
                if ((Long)vector.firstElement() != -1L) {
                    this.m_cache.addEntry(l, vector);
                }
            }
        }
    }

    void abandon(int n, LDAPControl[] lDAPControlArray) {
        if (this.m_thread == null) {
            return;
        }
        LDAPMessageQueue lDAPMessageQueue = (LDAPMessageQueue)this.m_requests.remove(new Integer(n));
        if (this.m_messages != null) {
            this.m_messages.remove(new Integer(n));
        }
        if (lDAPMessageQueue != null) {
            lDAPMessageQueue.removeRequest(n);
        }
        this.resultRetrieved();
        this.sendAbandonRequest(n, lDAPControlArray);
    }

    LDAPMessageQueue changeListener(int n, LDAPMessageQueue lDAPMessageQueue) {
        if (this.m_thread == null) {
            lDAPMessageQueue.setException(this, new LDAPException("Server or network error", 81));
            return null;
        }
        return this.m_requests.put(new Integer(n), lDAPMessageQueue);
    }

    private synchronized void networkError(Exception exception) {
        if (this.m_thread == null) {
            return;
        }
        this.m_thread = null;
        this.cleanUp(new LDAPException("Server or network error", 81));
    }

    public synchronized void clearRequests() {
        if (this.m_requests != null) {
            this.m_requests.clear();
        }
    }

    static {
        m_msgIdLock = new Object();
        m_timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    }
}

