/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.el.impl;

import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.ExpressionEvaluator;
import org.jbpm.jpdl.el.FunctionMapper;
import org.jbpm.jpdl.el.VariableResolver;

public class JbpmExpressionEvaluator {
    private static ExpressionEvaluator expressionEvaluator;
    static VariableResolver variableResolver;
    static FunctionMapper functionMapper;

    static ExpressionEvaluator getExpressionEvaluator() {
        return expressionEvaluator != null ? expressionEvaluator : (ExpressionEvaluator)JbpmConfiguration.Configs.getObject("jbpm.expression.evaluator");
    }

    public static void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator) {
        JbpmExpressionEvaluator.expressionEvaluator = expressionEvaluator;
    }

    public static void setVariableResolver(VariableResolver variableResolver) {
        JbpmExpressionEvaluator.variableResolver = variableResolver;
    }

    public static void setFunctionMapper(FunctionMapper functionMapper) {
        JbpmExpressionEvaluator.functionMapper = functionMapper;
    }

    public static Object evaluate(String expression, ExecutionContext executionContext) {
        return JbpmExpressionEvaluator.evaluate(expression, executionContext, JbpmExpressionEvaluator.getVariableResolver(), JbpmExpressionEvaluator.getFunctionMapper());
    }

    public static Object evaluate(String expression, ExecutionContext executionContext, VariableResolver variableResolver, FunctionMapper functionMapper) {
        ExecutionContext.pushCurrentContext(executionContext);
        try {
            String dollarExpression = JbpmExpressionEvaluator.translateExpressionToDollars(expression);
            Object object = JbpmExpressionEvaluator.getExpressionEvaluator().evaluate(dollarExpression, Object.class, variableResolver, functionMapper);
            return object;
        }
        catch (ELException e) {
            throw new JbpmException("couldn't evaluate expression '" + expression + "'", e.getRootCause() != null ? e.getRootCause() : e);
        }
        finally {
            ExecutionContext.popCurrentContext(executionContext);
        }
    }

    static String translateExpressionToDollars(String expression) {
        int hashIndex = expression.indexOf("#{");
        if (hashIndex == -1) {
            return expression;
        }
        char[] expressionChars = expression.toCharArray();
        do {
            expressionChars[hashIndex] = 36;
        } while ((hashIndex = expression.indexOf("#{", hashIndex + 2)) != -1);
        return new String(expressionChars);
    }

    public static VariableResolver getUsedVariableResolver() {
        return JbpmExpressionEvaluator.getVariableResolver();
    }

    public static VariableResolver getVariableResolver() {
        return variableResolver != null ? variableResolver : (VariableResolver)JbpmConfiguration.Configs.getObject("jbpm.variable.resolver");
    }

    public static FunctionMapper getUsedFunctionMapper() {
        return JbpmExpressionEvaluator.getFunctionMapper();
    }

    public static FunctionMapper getFunctionMapper() {
        return functionMapper != null ? functionMapper : (JbpmConfiguration.Configs.hasObject("jbpm.function.mapper") ? (FunctionMapper)JbpmConfiguration.Configs.getObject("jbpm.function.mapper") : null);
    }
}

