/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;

public class LockMonitorThread
extends Thread {
    public static final String DEFAULT_NAME = "LockMonitorThread";
    final JbpmConfiguration jbpmConfiguration;
    final int lockMonitorInterval;
    final int maxLockTime;
    final int lockBufferTime;
    volatile boolean isActive = true;
    private static Log log = LogFactory.getLog((Class)LockMonitorThread.class);

    public LockMonitorThread(JobExecutor jobExecutor) {
        this(DEFAULT_NAME, jobExecutor);
    }

    public LockMonitorThread(String name, JobExecutor jobExecutor) {
        super(name);
        this.jbpmConfiguration = jobExecutor.getJbpmConfiguration();
        this.lockMonitorInterval = jobExecutor.getLockMonitorInterval();
        this.maxLockTime = jobExecutor.getMaxLockTime();
        this.lockBufferTime = jobExecutor.getLockBufferTime();
    }

    public LockMonitorThread(JbpmConfiguration jbpmConfiguration, int lockMonitorInterval, int maxLockTime, int lockBufferTime) {
        this.jbpmConfiguration = jbpmConfiguration;
        this.lockMonitorInterval = lockMonitorInterval;
        this.maxLockTime = maxLockTime;
        this.lockBufferTime = lockBufferTime;
    }

    public void run() {
        while (this.isActive) {
            try {
                this.unlockOverdueJobs();
                this.jbpmConfiguration.getJobExecutor().ensureThreadsAreActive();
            }
            catch (RuntimeException e) {
                log.error((Object)("exception in " + this.getName()), (Throwable)e);
            }
            if (!this.isActive) continue;
            try {
                LockMonitorThread.sleep(this.lockMonitorInterval);
            }
            catch (InterruptedException e) {
                log.info((Object)(this.getName() + " got interrupted"));
            }
        }
        log.info((Object)(this.getName() + " leaves cyberspace"));
    }

    protected void unlockOverdueJobs() {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            Date threshold = new Date(System.currentTimeMillis() - (long)this.maxLockTime - (long)this.lockBufferTime);
            List overdueJobs = jbpmContext.getJobSession().findJobsWithOverdueLockTime(threshold);
            Iterator i = overdueJobs.iterator();
            while (i.hasNext()) {
                Job job = (Job)i.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("unlocking " + job + " owned by " + job.getLockOwner()));
                }
                job.setLockOwner(null);
                job.setLockTime(null);
            }
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (RuntimeException e) {
                if (!DbPersistenceService.isLockingException(e)) {
                    throw e;
                }
                StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)"could not unlock overdue jobs");
            }
        }
    }

    public void setActive(boolean isActive) {
        if (!isActive) {
            this.deactivate();
        }
    }

    public void deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.interrupt();
        }
    }
}

