/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.JobSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Job;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;

public class JobExecutorThread
extends Thread {
    final JobExecutor jobExecutor;
    final JbpmConfiguration jbpmConfiguration;
    final int idleInterval;
    final int maxIdleInterval;
    final long maxLockTime;
    volatile boolean isActive = true;
    private static Log log = LogFactory.getLog((Class)JobExecutorThread.class);

    public JobExecutorThread(String name, JobExecutor jobExecutor) {
        super(name);
        this.jobExecutor = jobExecutor;
        this.jbpmConfiguration = jobExecutor.getJbpmConfiguration();
        this.idleInterval = jobExecutor.getIdleInterval();
        this.maxIdleInterval = jobExecutor.getMaxIdleInterval();
        this.maxLockTime = jobExecutor.getMaxLockTime();
    }

    public JobExecutorThread(String name, JobExecutor jobExecutor, JbpmConfiguration jbpmConfiguration, int idleInterval, int maxIdleInterval, long maxLockTime, int maxHistory) {
        super(name);
        this.jobExecutor = jobExecutor;
        this.jbpmConfiguration = jbpmConfiguration;
        this.idleInterval = idleInterval;
        this.maxIdleInterval = maxIdleInterval;
        this.maxLockTime = maxLockTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int currentIdleInterval = this.idleInterval;
        while (this.isActive) {
            try {
                long waitPeriod;
                Collection acquiredJobs = this.acquireJobs();
                Iterator i = acquiredJobs.iterator();
                while (i.hasNext() && this.isActive) {
                    Job job = (Job)i.next();
                    this.executeJob(job);
                }
                if (this.isActive && (waitPeriod = this.getWaitPeriod(currentIdleInterval)) > 0L) {
                    JobExecutor jobExecutor = this.jobExecutor;
                    synchronized (jobExecutor) {
                        this.jobExecutor.wait(waitPeriod);
                    }
                }
                currentIdleInterval = this.idleInterval;
            }
            catch (RuntimeException e) {
                if (!this.isActive) continue;
                log.error((Object)("exception in " + this.getName() + ", waiting " + currentIdleInterval + " ms"), (Throwable)e);
                try {
                    JobExecutor waitPeriod = this.jobExecutor;
                    synchronized (waitPeriod) {
                        this.jobExecutor.wait(currentIdleInterval);
                    }
                }
                catch (InterruptedException ie) {
                    log.debug((Object)(this.getName() + " got interrupted: " + e.getMessage()));
                }
                if ((currentIdleInterval *= 2) <= this.maxIdleInterval && currentIdleInterval >= 0) continue;
                currentIdleInterval = this.maxIdleInterval;
            }
            catch (InterruptedException e) {
                log.debug((Object)(this.getName() + " got interrupted: " + e.getMessage()));
            }
        }
        log.info((Object)(this.getName() + " leaves cyberspace"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection acquireJobs() {
        List acquiredJobs2;
        JobExecutor jobExecutor = this.jobExecutor;
        synchronized (jobExecutor) {
            List jobsToLock = Collections.EMPTY_LIST;
            JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
            try {
                JobSession jobSession = jbpmContext.getJobSession();
                String lockOwner = this.getName();
                Job job = jobSession.getFirstAcquirableJob(lockOwner);
                if (job != null) {
                    if (job.isExclusive()) {
                        ProcessInstance processInstance = job.getProcessInstance();
                        log.debug((Object)("finding exclusive jobs for " + processInstance));
                        jobsToLock = jobSession.findExclusiveJobs(lockOwner, processInstance);
                        log.debug((Object)("acquiring " + jobsToLock + " for " + processInstance));
                    } else {
                        log.debug((Object)("acquiring " + job));
                        jobsToLock = Collections.singletonList(job);
                    }
                    Date lockTime = new Date();
                    Iterator i = jobsToLock.iterator();
                    while (i.hasNext()) {
                        job = (Job)i.next();
                        job.setLockOwner(lockOwner);
                        job.setLockTime(lockTime);
                    }
                }
            }
            catch (RuntimeException e) {
                jbpmContext.setRollbackOnly();
                throw e;
            }
            catch (Error e) {
                jbpmContext.setRollbackOnly();
                throw e;
            }
            finally {
                try {
                    jbpmContext.close();
                    List acquiredJobs2 = jobsToLock;
                    log.debug((Object)("acquired lock on jobs: " + acquiredJobs2));
                }
                catch (RuntimeException e) {
                    if (!DbPersistenceService.isLockingException(e)) {
                        throw e;
                    }
                    StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("failed to acquire lock on jobs " + jobsToLock));
                    List acquiredJobs2 = Collections.EMPTY_LIST;
                }
            }
        }
        return acquiredJobs2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeJob(Job job) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            jobSession.reattachJob(job);
            jbpmContext.addAutoSaveProcessInstance(job.getProcessInstance());
            log.debug((Object)("executing " + job));
            try {
                if (job.execute(jbpmContext)) {
                    jobSession.deleteJob(job);
                }
            }
            catch (Exception e) {
                log.debug((Object)("exception while executing " + job), (Throwable)e);
                if (!DbPersistenceService.isPersistenceException(e)) {
                    StringWriter memoryWriter = new StringWriter();
                    e.printStackTrace(new PrintWriter(memoryWriter));
                    job.setException(memoryWriter.toString());
                    job.setRetries(job.getRetries() - 1);
                } else {
                    jbpmContext.setRollbackOnly();
                }
            }
            catch (Error e) {
                jbpmContext.setRollbackOnly();
                throw e;
            }
            long totalLockTimeInMillis = System.currentTimeMillis() - job.getLockTime().getTime();
            if (totalLockTimeInMillis > this.maxLockTime) {
                jbpmContext.setRollbackOnly();
            }
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (RuntimeException e) {
                if (!DbPersistenceService.isLockingException(e)) {
                    throw e;
                }
                StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("failed to complete job " + job));
            }
        }
    }

    protected long getWaitPeriod(int currentIdleInterval) {
        long currentTime;
        long nextDueTime;
        long waitPeriod = currentIdleInterval;
        Date nextDueDate = this.getNextDueDate();
        if (nextDueDate != null && (nextDueTime = nextDueDate.getTime()) < (currentTime = System.currentTimeMillis()) + (long)currentIdleInterval && (waitPeriod = nextDueTime - currentTime) < 0L) {
            waitPeriod = 0L;
        }
        return waitPeriod;
    }

    protected Date getNextDueDate() {
        Date nextDueDate = null;
        String lockOwner = this.getName();
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            JobSession jobSession = jbpmContext.getJobSession();
            Set jobIdsToIgnore = this.jobExecutor.getMonitoredJobIds();
            Job job = jobSession.getFirstDueJob(lockOwner, jobIdsToIgnore);
            if (job != null) {
                nextDueDate = job.getDueDate();
                this.jobExecutor.addMonitoredJobId(lockOwner, job.getId());
            }
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        catch (Error e) {
            jbpmContext.setRollbackOnly();
            throw e;
        }
        finally {
            try {
                jbpmContext.close();
            }
            catch (RuntimeException e) {
                if (!DbPersistenceService.isLockingException(e)) {
                    throw e;
                }
                StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("failed to determine next due date for job executor thread " + lockOwner));
                nextDueDate = null;
            }
        }
        return nextDueDate;
    }

    public void setActive(boolean isActive) {
        if (!isActive) {
            this.deactivate();
        }
    }

    public void deactivate() {
        if (this.isActive) {
            this.isActive = false;
            this.interrupt();
        }
    }
}

