/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bytes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bytes.ByteBlockChopper;
import org.jbpm.util.StringUtil;

public class ByteArray
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id;
    protected String name;
    protected List byteBlocks;
    private static final Log log = LogFactory.getLog((Class)ByteArray.class);

    public ByteArray() {
    }

    public ByteArray(byte[] bytes) {
        this.byteBlocks = ByteBlockChopper.chopItUp(bytes);
    }

    public ByteArray(String name, byte[] bytes) {
        this(bytes);
        this.name = name;
    }

    void logBlocks(String msg) {
        for (int blockIndex = 0; blockIndex < this.byteBlocks.size(); ++blockIndex) {
            byte[] block = (byte[])this.byteBlocks.get(blockIndex);
            log.debug((Object)(msg + "[" + block.length + "] " + StringUtil.toHexString(block)));
        }
    }

    public ByteArray(ByteArray other) {
        List otherByteBlocks = other.getByteBlocks();
        if (otherByteBlocks != null) {
            this.byteBlocks = new ArrayList(otherByteBlocks);
        }
        this.name = other.name;
    }

    public byte[] getBytes() {
        return ByteBlockChopper.glueChopsBackTogether(this.byteBlocks);
    }

    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ByteArray)) {
            return false;
        }
        ByteArray other = (ByteArray)o;
        return Arrays.equals(ByteBlockChopper.glueChopsBackTogether(this.byteBlocks), ByteBlockChopper.glueChopsBackTogether(other.byteBlocks));
    }

    public int hashCode() {
        if (this.byteBlocks == null) {
            return 0;
        }
        return ((Object)this.byteBlocks).hashCode();
    }

    public List getByteBlocks() {
        return this.byteBlocks;
    }
}

