/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.message.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.mapping.ObjectMappingException;
import org.mvel.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMapper {
    public static String BODY_CONTENT = "BODY_CONTENT";
    private Logger logger = Logger.getLogger(this.getClass());
    private static final char QUOTE = '\'';
    private static final char ESCAPE = '\\';
    private static final char EXPRESSION_SEPARATOR = '.';
    private MessagePayloadProxy payloadProxy;
    private static String[] legacyGetPayloadLocations = new String[]{"org.jboss.soa.esb.message.content.bytes"};
    private static String[] legacySetPayloadLocations = new String[]{"org.jboss.soa.esb.message.content.bytes"};

    public ObjectMapper() {
        this.payloadProxy = new MessagePayloadProxy(new ConfigTree("null-config"), legacyGetPayloadLocations, legacySetPayloadLocations);
        this.payloadProxy.setNullGetPayloadHandling(MessagePayloadProxy.NullPayloadHandling.NONE);
    }

    public ObjectMapper(ConfigTree config) {
        this.payloadProxy = new MessagePayloadProxy(config, legacyGetPayloadLocations, legacySetPayloadLocations);
    }

    public List<Object> createObjectList(Message message, List<String> messageObjectPathList) throws ObjectMappingException {
        ArrayList<Object> objectList = new ArrayList<Object>();
        if (messageObjectPathList != null) {
            for (String messageObjectPath : messageObjectPathList) {
                Object value = this.getObjectFromMessage(message, messageObjectPath);
                if (value == null) {
                    this.logger.warn((Object)("The value of " + messageObjectPath + " is null"));
                    continue;
                }
                if (value instanceof Collection) {
                    Collection valuesList = (Collection)value;
                    for (Object e : valuesList) {
                        objectList.add(e);
                    }
                    continue;
                }
                if (value instanceof Map) {
                    Map valuesMap = (Map)value;
                    for (Object object : valuesMap.entrySet()) {
                        objectList.add(object);
                    }
                    continue;
                }
                objectList.add(value);
            }
        }
        return objectList;
    }

    public Message setObjectsOnMessage(Message message, Map<Object, String> expressionAndObject) throws ObjectMappingException {
        if (expressionAndObject != null) {
            for (Object object : expressionAndObject.keySet()) {
                String expression = expressionAndObject.get(object);
                this.setObjectOnMessage(message, expression, object);
            }
        }
        return message;
    }

    public Object getObjectFromMessage(Message message, String expression) throws ObjectMappingException {
        Object object = null;
        String[] path = this.getExpressionPath(expression);
        if (path.length == 0) {
            throw new ObjectMappingException(expression + " should start with [<location>.]<name>");
        }
        String location = path[0];
        String name = path[1];
        if ("body".equalsIgnoreCase(location)) {
            Body body = message.getBody();
            try {
                object = BODY_CONTENT.equals(name) ? this.payloadProxy.getPayload(message) : body.get(name);
            }
            catch (MessageDeliverException e) {
                throw new ObjectMappingException("Unable to get payload '" + name + "' from message.", e);
            }
        } else if ("properties".equalsIgnoreCase(location)) {
            object = message.getProperties().getProperty(name);
        } else if ("attachment".equalsIgnoreCase(location)) {
            if (this.isNumeric(name)) {
                int index = Integer.valueOf(name);
                object = message.getAttachment().itemAt(index);
            } else {
                object = message.getAttachment().get(name);
            }
        } else if ("header".equalsIgnoreCase(location)) {
            object = message.getHeader().getCall();
        } else {
            throw new ObjectMappingException(expression + " should start with one of [header,body,properties,attachment]");
        }
        if (path.length == 3) {
            object = MVEL.getProperty((String)path[2], (Object)object);
        }
        return object;
    }

    public void setObjectOnMessage(Message message, String expression, Object object) throws ObjectMappingException {
        String[] path = this.getExpressionPath(expression);
        if (path.length == 0) {
            throw new ObjectMappingException(expression + " should start with [<location>.]<name>");
        }
        if (path.length > 2 && !"header".equals(path[0]) && !"body".equals(path[0])) {
            throw new ObjectMappingException("Only 'header' and 'body' can contain hierarchical names: " + expression);
        }
        String location = path[0];
        String name = path[1];
        if ("body".equalsIgnoreCase(location)) {
            Body body = message.getBody();
            if (path.length == 2) {
                if (BODY_CONTENT.equals(name)) {
                    try {
                        this.payloadProxy.setPayload(message, object);
                    }
                    catch (MessageDeliverException e) {
                        throw new ObjectMappingException("Unable to set payload on message.", e);
                    }
                } else {
                    body.add(name, object);
                }
            } else {
                Object bodyObject;
                if (BODY_CONTENT.equals(name)) {
                    try {
                        bodyObject = this.payloadProxy.getPayload(message);
                    }
                    catch (MessageDeliverException mde) {
                        throw new ObjectMappingException("Unable to get payload from message.", mde);
                    }
                } else {
                    bodyObject = body.get(name);
                }
                if (bodyObject == null) {
                    throw new ObjectMappingException("Unable to set property on named object: " + name + ", object does not exist in message");
                }
                MVEL.setProperty((Object)bodyObject, (String)path[2], (Object)object);
            }
        } else if ("properties".equalsIgnoreCase(location)) {
            message.getProperties().setProperty(name, object);
        } else if ("attachment".equalsIgnoreCase(location)) {
            if (this.isNumeric(name)) {
                int index = Integer.valueOf(name);
                message.getAttachment().addItemAt(index, object);
            } else {
                message.getAttachment().put(name, object);
            }
        } else if ("header".equalsIgnoreCase(location)) {
            expression = path.length == 2 ? location + '.' + name : location + '.' + name + '.' + path[2];
            MVEL.setProperty((Object)message, (String)expression, (Object)object);
        } else {
            throw new ObjectMappingException(expression + " should start with one of [header,body,properties,attachment]");
        }
    }

    private boolean isNumeric(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isDigit(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public byte[] getBytes(Serializable object) throws ObjectMappingException {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        return object.toString().getBytes();
    }

    private String[] getExpressionPath(String expression) throws ObjectMappingException {
        int length;
        if (expression != null && (length = expression.length()) > 0) {
            ObjectMapperState state = new ObjectMapperState(expression);
            this.skipWhitespace(state);
            if (state.getIndex() < length) {
                String first = this.getPathElement(state);
                if (state.getIndex() >= length) {
                    return new String[]{"body", first};
                }
                String second = this.getPathElement(state);
                int index = state.getIndex();
                if (index >= length) {
                    return new String[]{first, second};
                }
                return new String[]{first, second, expression.substring(index)};
            }
        }
        return new String[0];
    }

    private String getPathElement(ObjectMapperState state) throws ObjectMappingException {
        String expression = state.getExpression();
        int length = expression.length();
        int startIndex = state.getIndex();
        if (expression.charAt(startIndex) == '\'') {
            state.setIndex(startIndex + 1);
            String element = this.getElement(state, '\'', true);
            int index = state.getIndex();
            if (index < length && expression.charAt(index) != '.') {
                throw new ObjectMappingException("Quoted path element terminated at index: " + index + " before separator character reached: " + expression);
            }
            state.setIndex(index + 1);
            return element;
        }
        return this.getElement(state, '.', false);
    }

    private String getElement(ObjectMapperState state, char endChar, boolean endCharPresent) throws ObjectMappingException {
        String result;
        int startIndex;
        String expression = state.getExpression();
        int length = expression.length();
        int index = startIndex = state.getIndex();
        StringBuilder sb = null;
        while (index < length) {
            char current = expression.charAt(index);
            if (current == '\\') {
                String currentExpression = expression.substring(startIndex, index);
                if (sb == null) {
                    sb = new StringBuilder(currentExpression);
                } else {
                    sb.append(currentExpression);
                }
                if (++index >= length) {
                    throw new ObjectMappingException("Unexpected end of expression reached while escaping: " + expression);
                }
                sb.append(expression.charAt(index));
                index = startIndex = index + 1;
                continue;
            }
            if (current == endChar) break;
            ++index;
        }
        String remainder = expression.substring(startIndex, index);
        if (sb == null) {
            result = remainder;
        } else {
            sb.append(remainder);
            result = sb.toString();
        }
        if (endCharPresent && (index >= length || endChar != expression.charAt(index))) {
            throw new ObjectMappingException("Expected element termination with character \"" + endChar + "\" at index: " + index + " of expression: " + expression);
        }
        state.setIndex(index + 1);
        return result;
    }

    public static MessagePayloadProxy createPayloadProxy(ConfigTree config) {
        return new MessagePayloadProxy(config, new String[]{"org.jboss.soa.esb.message.content.bytes"}, new String[]{"org.jboss.soa.esb.message.defaultEntry", "org.jboss.soa.esb.message.content.bytes"});
    }

    private void skipWhitespace(ObjectMapperState state) {
        int index;
        String expression = state.getExpression();
        int length = expression.length();
        for (index = state.getIndex(); index < length && Character.isWhitespace(expression.charAt(index)); ++index) {
        }
        state.setIndex(index);
    }

    private static final class ObjectMapperState {
        private final String expression;
        private int index;

        public ObjectMapperState(String expression) {
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

