/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.apache.ftpserver.interfaces.Ssl;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSsl
implements Ssl {
    private final Logger LOG = LoggerFactory.getLogger((Class)DefaultSsl.class);
    private File keystoreFile = new File("./res/.keystore");
    private String keystorePass = "password";
    private String keystoreType = "JKS";
    private String keystoreAlgorithm = "SunX509";
    private String sslProtocol = "TLS";
    private boolean clientAuthReqd = false;
    private String keyPass = "password";
    private KeyStore keyStore;
    private KeyManagerFactory keyManagerFactory;
    private TrustManagerFactory trustManagerFactory;
    private HashMap sslContextMap;

    public void setKeystoreFile(File keyStoreFile) {
        this.keystoreFile = keyStoreFile;
    }

    public void setKeystorePassword(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public void setKeystoreAlgorithm(String keystoreAlgorithm) {
        this.keystoreAlgorithm = keystoreAlgorithm;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public void setClientAuthentication(boolean clientAuthReqd) {
        this.clientAuthReqd = clientAuthReqd;
    }

    public void setKeyPassword(String keyPass) {
        this.keyPass = keyPass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        try {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(this.keystoreFile);
                this.keyStore = KeyStore.getInstance(this.keystoreType);
                this.keyStore.load(fin, this.keystorePass.toCharArray());
            }
            catch (Throwable throwable) {
                IoUtils.close(fin);
                throw throwable;
            }
            IoUtils.close(fin);
            this.keyManagerFactory = KeyManagerFactory.getInstance(this.keystoreAlgorithm);
            this.keyManagerFactory.init(this.keyStore, this.keyPass.toCharArray());
            this.trustManagerFactory = TrustManagerFactory.getInstance(this.keystoreAlgorithm);
            this.trustManagerFactory.init(this.keyStore);
            this.sslContextMap = new HashMap();
        }
        catch (Exception ex) {
            this.LOG.error("DefaultSsl.configure()", (Throwable)ex);
            throw new FtpServerConfigurationException("DefaultSsl.configure()", ex);
        }
    }

    private void lazyInit() {
        if (this.keyManagerFactory == null) {
            this.init();
        }
    }

    public synchronized SSLContext getSSLContext(String protocol) throws GeneralSecurityException {
        SSLContext ctx;
        this.lazyInit();
        if (protocol == null) {
            protocol = this.sslProtocol;
        }
        if ((ctx = (SSLContext)this.sslContextMap.get(protocol)) != null) {
            return ctx;
        }
        ctx = SSLContext.getInstance(protocol);
        ctx.init(this.keyManagerFactory.getKeyManagers(), this.trustManagerFactory.getTrustManagers(), null);
        this.sslContextMap.put(protocol, ctx);
        return ctx;
    }

    public ServerSocket createServerSocket(String protocol, InetAddress addr, int port) throws Exception {
        this.lazyInit();
        SSLContext ctx = this.getSSLContext(protocol);
        SSLServerSocketFactory ssocketFactory = ctx.getServerSocketFactory();
        SSLServerSocket serverSocket = null;
        serverSocket = addr == null ? (SSLServerSocket)ssocketFactory.createServerSocket(port, 100) : (SSLServerSocket)ssocketFactory.createServerSocket(port, 100, addr);
        String[] cipherSuites = serverSocket.getSupportedCipherSuites();
        serverSocket.setEnabledCipherSuites(cipherSuites);
        serverSocket.setNeedClientAuth(this.clientAuthReqd);
        return serverSocket;
    }

    public Socket createSocket(String protocol, Socket soc, boolean clientMode) throws Exception {
        this.lazyInit();
        if (soc instanceof SSLSocket) {
            return soc;
        }
        SSLContext ctx = this.getSSLContext(protocol);
        SSLSocketFactory socFactory = ctx.getSocketFactory();
        String host = soc.getInetAddress().getHostAddress();
        int port = soc.getLocalPort();
        SSLSocket ssoc = (SSLSocket)socFactory.createSocket(soc, host, port, true);
        ssoc.setUseClientMode(clientMode);
        String[] cipherSuites = ssoc.getSupportedCipherSuites();
        ssoc.setEnabledCipherSuites(cipherSuites);
        ssoc.setNeedClientAuth(this.clientAuthReqd);
        return ssoc;
    }

    public Socket createSocket(String protocol, InetAddress addr, int port, boolean clientMode) throws Exception {
        this.lazyInit();
        SSLContext ctx = this.getSSLContext(protocol);
        SSLSocketFactory socFactory = ctx.getSocketFactory();
        SSLSocket ssoc = (SSLSocket)socFactory.createSocket(addr, port);
        ssoc.setUseClientMode(clientMode);
        String[] cipherSuites = ssoc.getSupportedCipherSuites();
        ssoc.setEnabledCipherSuites(cipherSuites);
        return ssoc;
    }

    public Socket createSocket(String protocol, InetAddress host, int port, InetAddress localhost, int localport, boolean clientMode) throws Exception {
        this.lazyInit();
        SSLContext ctx = this.getSSLContext(protocol);
        SSLSocketFactory socFactory = ctx.getSocketFactory();
        SSLSocket ssoc = (SSLSocket)socFactory.createSocket(host, port, localhost, localport);
        ssoc.setUseClientMode(clientMode);
        String[] cipherSuites = ssoc.getSupportedCipherSuites();
        ssoc.setEnabledCipherSuites(cipherSuites);
        return ssoc;
    }

    public void dispose() {
    }

    public boolean getClientAuthenticationRequired() {
        return this.clientAuthReqd;
    }

    public SSLContext getSSLContext() throws GeneralSecurityException {
        return this.getSSLContext(this.sslProtocol);
    }
}

