/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command;

import java.io.IOException;
import org.apache.ftpserver.FtpSessionImpl;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpReplyOutput;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.ServerFtpStatistics;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.listener.ConnectionManager;
import org.apache.ftpserver.usermanager.BaseUser;
import org.apache.ftpserver.usermanager.ConcurrentLoginRequest;
import org.apache.ftpserver.util.FtpReplyUtil;

public class USER
extends AbstractCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, FtpRequest request, FtpSessionImpl session, FtpReplyOutput out) throws IOException, FtpException {
        boolean success = false;
        FtpServerContext serverContext = connection.getServerContext();
        ConnectionManager conManager = serverContext.getConnectionManager();
        ServerFtpStatistics stat = (ServerFtpStatistics)serverContext.getFtpStatistics();
        try {
            ConcurrentLoginRequest loginRequest;
            session.resetState();
            String userName = request.getArgument();
            if (userName == null) {
                out.write(FtpReplyUtil.translate(session, 501, "USER", null));
                return;
            }
            BaseUser user = (BaseUser)session.getUser();
            if (session.isLoggedIn()) {
                if (userName.equals(user.getName())) {
                    out.write(FtpReplyUtil.translate(session, 230, "USER", null));
                    success = true;
                } else {
                    out.write(FtpReplyUtil.translate(session, 530, "USER.invalid", null));
                }
                return;
            }
            boolean anonymous = userName.equals("anonymous");
            if (anonymous && !conManager.isAnonymousLoginEnabled()) {
                out.write(FtpReplyUtil.translate(session, 530, "USER.anonymous", null));
                return;
            }
            int currAnonLogin = stat.getCurrentAnonymousLoginNumber();
            int maxAnonLogin = conManager.getMaxAnonymousLogins();
            if (anonymous && currAnonLogin >= maxAnonLogin) {
                out.write(FtpReplyUtil.translate(session, 421, "USER.anonymous", null));
                return;
            }
            int currLogin = stat.getCurrentLoginNumber();
            int maxLogin = conManager.getMaxLogins();
            if (maxLogin != 0 && currLogin >= maxLogin) {
                out.write(FtpReplyUtil.translate(session, 421, "USER.login", null));
                return;
            }
            User configUser = connection.getServerContext().getUserManager().getUserByName(userName);
            if (configUser != null && configUser.authorize((AuthorizationRequest)(loginRequest = new ConcurrentLoginRequest(stat.getCurrentUserLoginNumber(configUser) + 1, stat.getCurrentUserLoginNumber(configUser, session.getClientAddress()) + 1))) == null) {
                out.write(FtpReplyUtil.translate(session, 421, "USER.login", null));
                return;
            }
            success = true;
            session.setUserArgument(userName);
            if (anonymous) {
                out.write(FtpReplyUtil.translate(session, 331, "USER.anonymous", userName));
            } else {
                out.write(FtpReplyUtil.translate(session, 331, "USER", userName));
            }
        }
        finally {
            if (!success) {
                conManager.closeConnection(connection);
            }
        }
    }
}

