/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class FooterRecord
extends WritableRecordData {
    private byte[] data;
    private String footer;

    public FooterRecord(String l, String c, String r) {
        super(Type.FOOTER);
        StringBuffer sb = new StringBuffer();
        if (l != null) {
            sb.append("&L");
            sb.append(l);
        }
        if (c != null) {
            sb.append("&C");
            sb.append(c);
        }
        if (r != null) {
            sb.append("&R");
            sb.append(r);
        }
        this.footer = sb.toString();
    }

    public FooterRecord(jxl.read.biff.FooterRecord fr) {
        super(Type.FOOTER);
        if (fr != null) {
            this.footer = fr.getFooter();
        }
    }

    public FooterRecord(FooterRecord fr) {
        super(Type.FOOTER);
        this.footer = fr.footer;
    }

    public byte[] getData() {
        if (this.footer == null || this.footer.length() == 0) {
            this.data = new byte[0];
            return this.data;
        }
        this.data = new byte[this.footer.length() * 2 + 3];
        IntegerHelper.getTwoBytes(this.footer.length(), this.data, 0);
        this.data[2] = 1;
        StringHelper.getUnicodeBytes(this.footer, this.data, 3);
        return this.data;
    }
}

