/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.io.Serializable;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import org.apache.ws.scout.registry.IRegistryBase;
import org.apache.ws.scout.registry.RegistryImpl;
import org.apache.ws.scout.registry.RegistryServiceImpl;
import org.apache.ws.scout.registry.RegistryV3Impl;
import org.apache.ws.scout.registry.SecurityActions;

public class ConnectionImpl
implements Connection,
Serializable {
    private static final long serialVersionUID = 3542404895814764176L;
    private boolean closed = false;
    private boolean synchronous = true;
    private Set credentials;
    private final IRegistryBase registry;
    private final String postalScheme;
    private final int maxRows;
    private String uddiVersion;

    public ConnectionImpl(URI queryManagerURI, URI lifeCycleManagerURI, URI securityManagerURI, String transportClass, String postalScheme, int maxRows, String uddiNamespace, String uddiVersion) {
        Properties prop = new Properties();
        this.uddiVersion = uddiVersion;
        if (uddiVersion != null) {
            prop.setProperty("scout.proxy.uddiVersion", uddiVersion);
        } else {
            prop.setProperty("scout.proxy.uddiVersion", "2.0");
        }
        if (uddiNamespace != null) {
            prop.setProperty("scout.proxy.uddiNamespace", uddiNamespace);
        } else {
            prop.setProperty("scout.proxy.uddiNamespace", "urn:uddi-org:api_v2");
        }
        if (transportClass != null) {
            prop.setProperty("scout.proxy.transportClass", transportClass);
        } else {
            String transport = SecurityActions.getProperty("scout.proxy.transportClass");
            if (transport != null) {
                prop.setProperty("scout.proxy.transportClass", transport);
            }
        }
        this.registry = "3.0".equals(uddiVersion) ? new RegistryV3Impl(prop) : new RegistryImpl(prop);
        this.registry.setInquiryURI(queryManagerURI);
        this.registry.setPublishURI(lifeCycleManagerURI);
        this.registry.setSecurityURI(securityManagerURI);
        this.postalScheme = postalScheme;
        this.maxRows = maxRows;
    }

    public RegistryService getRegistryService() throws JAXRException {
        RegistryServiceImpl reg = new RegistryServiceImpl(this.registry, this.postalScheme, this.maxRows, this.uddiVersion);
        reg.setConnection(this);
        return reg;
    }

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Set getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Set credentials) {
        this.credentials = credentials;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }
}

