/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeIdIterator;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.AbstractQueryHandler;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.TextFilter;
import org.apache.jackrabbit.core.query.lucene.CachingMultiReader;
import org.apache.jackrabbit.core.query.lucene.ConsistencyCheck;
import org.apache.jackrabbit.core.query.lucene.ConsistencyCheckError;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.FileBasedNamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.NSRegistryBasedNamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NodeIndexer;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.QueryImpl;
import org.apache.jackrabbit.core.query.lucene.SharedFieldSortComparator;
import org.apache.jackrabbit.core.query.lucene.TextPlainTextFilter;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateIterator;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.QName;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortComparatorSource;
import org.apache.lucene.search.SortField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchIndex
extends AbstractQueryHandler {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchIndex.class);
    private static final String NS_MAPPING_FILE = "ns_mappings.properties";
    public static final int DEFAULT_MIN_MERGE_DOCS = 100;
    public static final int DEFAULT_MAX_MERGE_DOCS = 100000;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    public static final String DEFAULT_TEXT_FILTERS = TextPlainTextFilter.class.getName();
    private MultiIndex index;
    private Analyzer analyzer;
    private List textFilters;
    private String path;
    private int minMergeDocs = 100;
    private int volatileIdleTime = 3;
    private int maxMergeDocs = 100000;
    private int mergeFactor = 10;
    private int maxFieldLength = 10000;
    private int bufferSize = 10;
    private boolean useCompoundFile = true;
    private boolean documentOrder = true;
    private boolean forceConsistencyCheck = false;
    private boolean autoRepair = true;
    private int cacheSize = 1000;
    private int resultFetchSize = Integer.MAX_VALUE;
    private boolean closed = false;

    public SearchIndex() {
        this.analyzer = new StandardAnalyzer(new String[0]);
        this.setTextFilterClasses(DEFAULT_TEXT_FILTERS);
    }

    protected void doInit() throws IOException {
        NamespaceMappings nsMappings;
        QueryHandlerContext context = this.getContext();
        if (this.path == null) {
            throw new IOException("SearchIndex requires 'path' parameter in configuration!");
        }
        HashSet<NodeId> excludedIDs = new HashSet<NodeId>();
        if (context.getExcludedNodeId() != null) {
            excludedIDs.add(context.getExcludedNodeId());
        }
        File indexDir = new File(this.path);
        if (context.getParentHandler() instanceof SearchIndex) {
            SearchIndex sysIndex = (SearchIndex)context.getParentHandler();
            nsMappings = sysIndex.getNamespaceMappings();
        } else {
            File mapFile = new File(indexDir, NS_MAPPING_FILE);
            nsMappings = mapFile.exists() ? new FileBasedNamespaceMappings(mapFile) : new NSRegistryBasedNamespaceMappings(context.getNamespaceRegistry());
        }
        this.index = new MultiIndex(indexDir, this, context.getItemStateManager(), context.getRootId(), excludedIDs, nsMappings);
        if (this.index.getRedoLogApplied() || this.forceConsistencyCheck) {
            log.info("Running consistency check...");
            try {
                ConsistencyCheck check = ConsistencyCheck.run(this.index, context.getItemStateManager());
                if (this.autoRepair) {
                    check.repair(true);
                } else {
                    List errors = check.getErrors();
                    if (errors.size() == 0) {
                        log.info("No errors detected.");
                    }
                    Iterator it = errors.iterator();
                    while (it.hasNext()) {
                        ConsistencyCheckError err = (ConsistencyCheckError)it.next();
                        log.info(err.toString());
                    }
                }
            }
            catch (Exception e) {
                log.warn("Failed to run consistency check on index: " + e);
            }
        }
        log.info("Index initialized: " + this.path);
    }

    public void addNode(NodeState node) throws RepositoryException, IOException {
        throw new UnsupportedOperationException("addNode");
    }

    public void deleteNode(NodeId id) throws IOException {
        throw new UnsupportedOperationException("deleteNode");
    }

    public void updateNodes(NodeIdIterator remove, NodeStateIterator add) throws RepositoryException, IOException {
        this.checkOpen();
        this.index.update((Iterator)new AbstractIteratorDecorator(remove){

            public Object next() {
                return ((NodeId)super.next()).getUUID();
            }
        }, (Iterator)new AbstractIteratorDecorator(add){

            public Object next() {
                NodeState state = (NodeState)super.next();
                if (state == null) {
                    return null;
                }
                Document doc = null;
                try {
                    doc = SearchIndex.this.createDocument(state, SearchIndex.this.getNamespaceMappings());
                }
                catch (RepositoryException e) {
                    log.error("Exception while creating document for node: " + state.getNodeId() + ": " + e.toString());
                }
                return doc;
            }
        });
    }

    public ExecutableQuery createExecutableQuery(SessionImpl session, ItemManager itemMgr, String statement, String language) throws InvalidQueryException {
        QueryImpl query = new QueryImpl(session, itemMgr, this, this.getContext().getPropertyTypeRegistry(), statement, language);
        query.setRespectDocumentOrder(this.documentOrder);
        return query;
    }

    public void close() {
        this.index.close();
        this.getContext().destroy();
        this.closed = true;
        log.info("Index closed: " + this.path);
    }

    public QueryHits executeQuery(QueryImpl queryImpl, Query query, QName[] orderProps, boolean[] orderSpecs) throws IOException {
        this.checkOpen();
        QueryHandler parentHandler = this.getContext().getParentHandler();
        IndexReader parentReader = null;
        if (parentHandler instanceof SearchIndex) {
            parentReader = ((SearchIndex)parentHandler).index.getIndexReader();
        }
        SortField[] sortFields = this.createSortFields(orderProps, orderSpecs);
        Object reader = this.index.getIndexReader();
        if (parentReader != null) {
            CachingMultiReader[] readers = new CachingMultiReader[]{(CachingMultiReader)reader, (CachingMultiReader)parentReader};
            reader = new CombinedIndexReader(readers);
        }
        IndexSearcher searcher = new IndexSearcher(reader);
        Hits hits = sortFields.length > 0 ? searcher.search(query, new Sort(sortFields)) : searcher.search(query);
        return new QueryHits(hits, (IndexReader)reader);
    }

    public Analyzer getTextAnalyzer() {
        return this.analyzer;
    }

    protected List getTextFilters() {
        return this.textFilters;
    }

    public NamespaceMappings getNamespaceMappings() {
        return this.index.getNamespaceMappings();
    }

    protected SortField[] createSortFields(QName[] orderProps, boolean[] orderSpecs) {
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        for (int i = 0; i < orderProps.length; ++i) {
            String prop = null;
            if (QName.JCR_SCORE.equals((Object)orderProps[i])) {
                sortFields.add(new SortField(null, 0, orderSpecs[i]));
                continue;
            }
            try {
                prop = NameFormat.format((QName)orderProps[i], (NamespaceResolver)this.getNamespaceMappings());
            }
            catch (NoPrefixDeclaredException e) {
                // empty catch block
            }
            sortFields.add(new SortField(prop, (SortComparatorSource)SharedFieldSortComparator.PROPERTIES, !orderSpecs[i]));
        }
        return sortFields.toArray(new SortField[sortFields.size()]);
    }

    protected Document createDocument(NodeState node, NamespaceMappings nsMappings) throws RepositoryException {
        return NodeIndexer.createDocument(node, this.getContext().getItemStateManager(), nsMappings, this.textFilters);
    }

    protected MultiIndex getIndex() {
        return this.index;
    }

    public void setAnalyzer(String analyzerClassName) {
        try {
            Class<?> analyzerClass = Class.forName(analyzerClassName);
            this.analyzer = (Analyzer)analyzerClass.newInstance();
        }
        catch (Exception e) {
            log.warn("Invalid Analyzer class: " + analyzerClassName, (Throwable)e);
        }
    }

    public String getAnalyzer() {
        return this.analyzer.getClass().getName();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setUseCompoundFile(boolean b) {
        this.useCompoundFile = b;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
    }

    public int getMinMergeDocs() {
        return this.minMergeDocs;
    }

    public void setVolatileIdleTime(int volatileIdleTime) {
        this.volatileIdleTime = volatileIdleTime;
    }

    public int getVolatileIdleTime() {
        return this.volatileIdleTime;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setRespectDocumentOrder(boolean docOrder) {
        this.documentOrder = docOrder;
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setForceConsistencyCheck(boolean b) {
        this.forceConsistencyCheck = b;
    }

    public boolean getForceConsistencyCheck() {
        return this.forceConsistencyCheck;
    }

    public void setAutoRepair(boolean b) {
        this.autoRepair = b;
    }

    public boolean getAutoRepair() {
        return this.autoRepair;
    }

    public void setCacheSize(int size) {
        this.cacheSize = size;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setMaxFieldLength(int length) {
        this.maxFieldLength = length;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public void setTextFilterClasses(String filterClasses) {
        ArrayList<TextFilter> filters = new ArrayList<TextFilter>();
        StringTokenizer tokenizer = new StringTokenizer(filterClasses, ", \t\n\r\f");
        while (tokenizer.hasMoreTokens()) {
            String className = tokenizer.nextToken();
            try {
                Class<?> filterClass = Class.forName(className);
                TextFilter filter = (TextFilter)filterClass.newInstance();
                filters.add(filter);
            }
            catch (Exception e) {
                log.warn("Invalid TextFilter class: " + className, (Throwable)e);
            }
            catch (LinkageError e) {
                log.warn("Missing dependency for text filter: " + className);
                log.warn(e.toString());
            }
        }
        this.textFilters = Collections.unmodifiableList(filters);
    }

    public String getTextFilterClasses() {
        StringBuffer names = new StringBuffer();
        String delim = "";
        Iterator it = this.textFilters.iterator();
        while (it.hasNext()) {
            names.append(delim);
            names.append(it.next().getClass().getName());
            delim = ",";
        }
        return names.toString();
    }

    public void setResultFetchSize(int size) {
        this.resultFetchSize = size;
    }

    public int getResultFetchSize() {
        return this.resultFetchSize;
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("query handler closed and cannot be used anymore.");
        }
    }

    protected static final class CombinedIndexReader
    extends MultiReader
    implements HierarchyResolver {
        private CachingMultiReader[] subReaders;
        private int[] starts;

        public CombinedIndexReader(CachingMultiReader[] indexReaders) throws IOException {
            super((IndexReader[])indexReaders);
            this.subReaders = indexReaders;
            this.starts = new int[this.subReaders.length + 1];
            int maxDoc = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                this.starts[i] = maxDoc;
                maxDoc += this.subReaders[i].maxDoc();
            }
            this.starts[this.subReaders.length] = maxDoc;
        }

        public int getParent(int n) throws IOException {
            int i = this.readerIndex(n);
            DocId id = this.subReaders[i].getParentDocId(n - this.starts[i]);
            id = id.applyOffset(this.starts[i]);
            return id.getDocumentNumber((IndexReader)this);
        }

        private int readerIndex(int n) {
            int lo = 0;
            int hi = this.subReaders.length - 1;
            while (hi >= lo) {
                int mid = lo + hi >> 1;
                int midValue = this.starts[mid];
                if (n < midValue) {
                    hi = mid - 1;
                    continue;
                }
                if (n > midValue) {
                    lo = mid + 1;
                    continue;
                }
                while (mid + 1 < this.subReaders.length && this.starts[mid + 1] == midValue) {
                    ++mid;
                }
                return mid;
            }
            return hi;
        }
    }
}

