/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.util.Date;
import org.apache.jackrabbit.core.query.NAryQueryNode;
import org.apache.jackrabbit.core.query.QueryConstants;
import org.apache.jackrabbit.core.query.QueryNode;
import org.apache.jackrabbit.core.query.QueryNodeVisitor;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;

public class RelationQueryNode
extends NAryQueryNode
implements QueryConstants {
    public static final QName STAR_NAME_TEST = new QName("internal", "__star__");
    private Path relPath;
    private boolean unaryMinus;
    private long valueLong;
    private int valuePosition;
    private double valueDouble;
    private String valueString;
    private Date valueDate;
    private int operation;
    private int type;

    public RelationQueryNode(QueryNode parent, int operation) {
        super(parent);
        this.operation = operation;
    }

    public RelationQueryNode(QueryNode parent, Path relPath, long value, int operation) {
        super(parent);
        this.relPath = relPath;
        this.valueLong = value;
        this.operation = operation;
        this.type = 1;
    }

    public RelationQueryNode(QueryNode parent, Path relPath, double value, int operation) {
        super(parent);
        this.relPath = relPath;
        this.valueDouble = value;
        this.operation = operation;
        this.type = 2;
    }

    public RelationQueryNode(QueryNode parent, Path relPath, Date value, int operation) {
        super(parent);
        this.relPath = relPath;
        this.valueDate = value;
        this.operation = operation;
        this.type = 4;
    }

    public RelationQueryNode(QueryNode parent, Path relPath, String value, int operation) {
        super(parent);
        this.relPath = relPath;
        this.valueString = value;
        this.operation = operation;
        this.type = 3;
    }

    public Object accept(QueryNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public int getType() {
        return 2;
    }

    public void setUnaryMinus(boolean b) {
        this.unaryMinus = b;
    }

    public int getValueType() {
        return this.type;
    }

    public QName getProperty() {
        return this.relPath == null ? null : this.relPath.getNameElement().getName();
    }

    public void setProperty(QName name) {
        Path.PathBuilder builder = new Path.PathBuilder();
        builder.addLast(name);
        try {
            this.relPath = builder.getPath();
        }
        catch (MalformedPathException malformedPathException) {
            // empty catch block
        }
    }

    public Path getRelativePath() {
        return this.relPath;
    }

    public void setRelativePath(Path relPath) {
        if (relPath != null && relPath.isAbsolute()) {
            throw new IllegalArgumentException("relPath must be relative");
        }
        this.relPath = relPath;
    }

    public void addPathElement(Path.PathElement element) {
        Path.PathBuilder builder = new Path.PathBuilder();
        if (this.relPath != null) {
            builder.addAll(this.relPath.getElements());
        }
        builder.addLast(element);
        try {
            this.relPath = builder.getPath();
        }
        catch (MalformedPathException e) {
            // empty catch block
        }
        try {
            this.relPath = this.relPath.getNormalizedPath();
        }
        catch (MalformedPathException malformedPathException) {
            // empty catch block
        }
    }

    public long getLongValue() {
        return this.valueLong;
    }

    public void setLongValue(long value) {
        this.valueLong = this.unaryMinus ? -value : value;
        this.type = 1;
    }

    public int getPositionValue() {
        return this.valuePosition;
    }

    public void setPositionValue(int value) {
        this.valuePosition = value;
        this.type = 6;
    }

    public double getDoubleValue() {
        return this.valueDouble;
    }

    public void setDoubleValue(double value) {
        this.valueDouble = this.unaryMinus ? -value : value;
        this.type = 2;
    }

    public String getStringValue() {
        return this.valueString;
    }

    public void setStringValue(String value) {
        this.valueString = value;
        this.type = 3;
    }

    public Date getDateValue() {
        return this.valueDate;
    }

    public void setDateValue(Date value) {
        this.valueDate = value;
        this.type = 4;
    }

    public int getOperation() {
        return this.operation;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelationQueryNode) {
            RelationQueryNode other = (RelationQueryNode)obj;
            return this.type == other.type && (this.valueDate == null ? other.valueDate == null : this.valueDate.equals(other.valueDate)) && this.valueDouble == other.valueDouble && this.valueLong == other.valueLong && this.valuePosition == other.valuePosition && (this.valueString == null ? other.valueString == null : this.valueString.equals(other.valueString)) && (this.relPath == null ? other.relPath == null : this.relPath.equals((Object)other.relPath));
        }
        return false;
    }
}

