/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.compact.CompactNodeTypeDefReader;
import org.apache.jackrabbit.core.nodetype.compact.ParseException;
import org.apache.jackrabbit.core.nodetype.xml.NodeTypeReader;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.NameException;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.apache.jackrabbit.util.IteratorHelper;
import org.apache.jackrabbit.util.name.NamespaceMapping;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NodeTypeManagerImpl
implements JackrabbitNodeTypeManager,
Dumpable,
NodeTypeRegistryListener {
    private final NodeTypeRegistry ntReg;
    private final NamespaceRegistryImpl nsReg;
    private final NodeDefinitionImpl rootNodeDef;
    private final NamespaceResolver nsResolver;
    private final Map ntCache;
    private final Map pdCache;
    private final Map ndCache;
    private static final String APPLICATION_XML = "application/xml";

    public NodeTypeManagerImpl(NodeTypeRegistry ntReg, NamespaceRegistryImpl nsReg, NamespaceResolver nsResolver) {
        this.nsResolver = nsResolver;
        this.ntReg = ntReg;
        this.nsReg = nsReg;
        this.ntReg.addListener(this);
        this.ntCache = new ReferenceMap(0, 1);
        this.pdCache = new ReferenceMap(0, 1);
        this.ndCache = new ReferenceMap(0, 1);
        this.rootNodeDef = new NodeDefinitionImpl(ntReg.getRootNodeDef(), this, nsResolver);
        this.ndCache.put(this.rootNodeDef.unwrap().getId(), this.rootNodeDef);
    }

    public NodeDefinitionImpl getRootNodeDefinition() {
        return this.rootNodeDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeDefinitionImpl getNodeDefinition(NodeDefId id) {
        Map map = this.ndCache;
        synchronized (map) {
            NodeDef nd;
            NodeDefinitionImpl ndi = (NodeDefinitionImpl)this.ndCache.get(id);
            if (ndi == null && (nd = this.ntReg.getNodeDef(id)) != null) {
                ndi = new NodeDefinitionImpl(nd, this, this.nsResolver);
                this.ndCache.put(id, ndi);
            }
            return ndi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyDefinitionImpl getPropertyDefinition(PropDefId id) {
        Map map = this.pdCache;
        synchronized (map) {
            PropDef pd;
            PropertyDefinitionImpl pdi = (PropertyDefinitionImpl)this.pdCache.get(id);
            if (pdi == null && (pd = this.ntReg.getPropDef(id)) != null) {
                pdi = new PropertyDefinitionImpl(pd, this, this.nsResolver);
                this.pdCache.put(id, pdi);
            }
            return pdi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeTypeImpl getNodeType(QName name) throws NoSuchNodeTypeException {
        Map map = this.ntCache;
        synchronized (map) {
            NodeTypeImpl nt = (NodeTypeImpl)this.ntCache.get(name);
            if (nt == null) {
                EffectiveNodeType ent = this.ntReg.getEffectiveNodeType(name);
                NodeTypeDef def = this.ntReg.getNodeTypeDef(name);
                nt = new NodeTypeImpl(ent, def, this, this.nsResolver);
                this.ntCache.put(name, nt);
            }
            return nt;
        }
    }

    public NodeTypeRegistry getNodeTypeRegistry() {
        return this.ntReg;
    }

    public NodeType[] registerNodeTypes(InputStream in, String contentType, boolean reregisterExisting) throws IOException, RepositoryException {
        try {
            HashMap<String, String> namespaceMap = new HashMap<String, String>();
            ArrayList<NodeTypeDef> nodeTypeDefs = new ArrayList<NodeTypeDef>();
            if (contentType.equalsIgnoreCase("text/xml") || contentType.equalsIgnoreCase(APPLICATION_XML)) {
                try {
                    NodeTypeReader ntr = new NodeTypeReader(in);
                    Properties namespaces = ntr.getNamespaces();
                    if (namespaces != null) {
                        Enumeration<?> prefixes = namespaces.propertyNames();
                        while (prefixes.hasMoreElements()) {
                            String prefix = (String)prefixes.nextElement();
                            String uri = namespaces.getProperty(prefix);
                            namespaceMap.put(prefix, uri);
                        }
                    }
                    NodeTypeDef[] defs = ntr.getNodeTypeDefs();
                    nodeTypeDefs.addAll(Arrays.asList(defs));
                }
                catch (IllegalNameException e) {
                    throw new RepositoryException("Illegal JCR name syntax", (Throwable)e);
                }
                catch (UnknownPrefixException e) {
                    throw new RepositoryException("Unknown namespace prefix", (Throwable)e);
                }
            } else if (contentType.equalsIgnoreCase("text/x-jcr-cnd")) {
                try {
                    NamespaceMapping mapping = new NamespaceMapping(this.nsResolver);
                    CompactNodeTypeDefReader reader = new CompactNodeTypeDefReader(new InputStreamReader(in), "cnd input stream", mapping);
                    namespaceMap.putAll(mapping.getPrefixToURIMapping());
                    nodeTypeDefs.addAll(reader.getNodeTypeDefs());
                }
                catch (ParseException e) {
                    throw new IOException(e.getMessage());
                }
            } else {
                throw new UnsupportedRepositoryOperationException("Unsupported content type: " + contentType);
            }
            Iterator iterator = namespaceMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.nsReg.safeRegisterNamespace((String)entry.getKey(), (String)entry.getValue());
            }
            if (reregisterExisting) {
                ArrayList<NodeTypeDef> newNodeTypeDefs = new ArrayList<NodeTypeDef>();
                ArrayList<NodeTypeDef> registeredNodeTypeDefs = new ArrayList<NodeTypeDef>();
                Iterator iter = nodeTypeDefs.iterator();
                while (iter.hasNext()) {
                    NodeTypeDef nodeTypeDef = (NodeTypeDef)iter.next();
                    if (this.ntReg.isRegistered(nodeTypeDef.getName())) {
                        registeredNodeTypeDefs.add(nodeTypeDef);
                        continue;
                    }
                    newNodeTypeDefs.add(nodeTypeDef);
                }
                ArrayList<NodeType> nodeTypes = new ArrayList<NodeType>();
                nodeTypes.addAll(Arrays.asList(this.registerNodeTypes(newNodeTypeDefs)));
                Iterator iter2 = registeredNodeTypeDefs.iterator();
                while (iter2.hasNext()) {
                    NodeTypeDef nodeTypeDef = (NodeTypeDef)iter2.next();
                    this.ntReg.reregisterNodeType(nodeTypeDef);
                    nodeTypes.add(this.getNodeType(nodeTypeDef.getName()));
                }
                return (NodeType[])nodeTypes.toArray(new NodeTypeDef[nodeTypes.size()]);
            }
            return this.registerNodeTypes(nodeTypeDefs);
        }
        catch (InvalidNodeTypeDefException e) {
            throw new RepositoryException("Invalid node type definition", (Throwable)((Object)e));
        }
    }

    public void nodeTypeRegistered(QName ntName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeTypeReRegistered(QName ntName) {
        Iterator iter;
        this.ntCache.remove(ntName);
        Map map = this.pdCache;
        synchronized (map) {
            iter = this.pdCache.values().iterator();
            while (iter.hasNext()) {
                PropertyDefinitionImpl pd = (PropertyDefinitionImpl)iter.next();
                if (!ntName.equals((Object)pd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
        map = this.ndCache;
        synchronized (map) {
            iter = this.ndCache.values().iterator();
            while (iter.hasNext()) {
                NodeDefinitionImpl nd = (NodeDefinitionImpl)iter.next();
                if (!ntName.equals((Object)nd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeTypeUnregistered(QName ntName) {
        Iterator iter;
        this.ntCache.remove(ntName);
        Map map = this.pdCache;
        synchronized (map) {
            iter = this.pdCache.values().iterator();
            while (iter.hasNext()) {
                PropertyDefinitionImpl pd = (PropertyDefinitionImpl)iter.next();
                if (!ntName.equals((Object)pd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
        map = this.ndCache;
        synchronized (map) {
            iter = this.ndCache.values().iterator();
            while (iter.hasNext()) {
                NodeDefinitionImpl nd = (NodeDefinitionImpl)iter.next();
                if (!ntName.equals((Object)nd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
    }

    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        QName[] ntNames = this.ntReg.getRegisteredNodeTypes();
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (int i = 0; i < ntNames.length; ++i) {
            list.add(this.getNodeType(ntNames[i]));
        }
        return new IteratorHelper(Collections.unmodifiableCollection(list));
    }

    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        QName[] ntNames = this.ntReg.getRegisteredNodeTypes();
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (int i = 0; i < ntNames.length; ++i) {
            NodeTypeImpl nt = this.getNodeType(ntNames[i]);
            if (nt.isMixin()) continue;
            list.add(nt);
        }
        return new IteratorHelper(Collections.unmodifiableCollection(list));
    }

    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        QName[] ntNames = this.ntReg.getRegisteredNodeTypes();
        ArrayList<NodeTypeImpl> list = new ArrayList<NodeTypeImpl>(ntNames.length);
        for (int i = 0; i < ntNames.length; ++i) {
            NodeTypeImpl nt = this.getNodeType(ntNames[i]);
            if (!nt.isMixin()) continue;
            list.add(nt);
        }
        return new IteratorHelper(Collections.unmodifiableCollection(list));
    }

    public NodeType getNodeType(String nodeTypeName) throws NoSuchNodeTypeException {
        try {
            return this.getNodeType(NameFormat.parse((String)nodeTypeName, (NamespaceResolver)this.nsResolver));
        }
        catch (UnknownPrefixException upe) {
            throw new NoSuchNodeTypeException(nodeTypeName, (Throwable)upe);
        }
        catch (IllegalNameException ine) {
            throw new NoSuchNodeTypeException(nodeTypeName, (Throwable)ine);
        }
    }

    private NodeType[] registerNodeTypes(List defs) throws InvalidNodeTypeDefException, RepositoryException {
        this.ntReg.registerNodeTypes(defs);
        HashSet<NodeTypeImpl> types = new HashSet<NodeTypeImpl>();
        Iterator iterator = defs.iterator();
        while (iterator.hasNext()) {
            try {
                NodeTypeDef def = (NodeTypeDef)iterator.next();
                types.add(this.getNodeType(def.getName()));
            }
            catch (NoSuchNodeTypeException e) {}
        }
        return types.toArray(new NodeType[types.size()]);
    }

    public NodeType[] registerNodeTypes(InputSource in) throws SAXException, RepositoryException {
        try {
            return this.registerNodeTypes(in.getByteStream(), "text/xml");
        }
        catch (IOException e) {
            throw new SAXException("Error reading node type stream", e);
        }
    }

    public NodeType[] registerNodeTypes(InputStream in, String contentType) throws IOException, RepositoryException {
        return this.registerNodeTypes(in, contentType, false);
    }

    public boolean hasNodeType(String name) throws RepositoryException {
        try {
            QName qname = NameFormat.parse((String)name, (NamespaceResolver)this.nsResolver);
            return this.getNodeTypeRegistry().isRegistered(qname);
        }
        catch (NameException e) {
            throw new RepositoryException();
        }
    }

    public void dump(PrintStream ps) {
        ps.println("NodeTypeManager (" + this + ")");
        ps.println();
        this.ntReg.dump(ps);
    }
}

