/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.ConfigurationParser;
import org.apache.jackrabbit.core.config.FileSystemConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.RepositoryConfigurationParser;
import org.apache.jackrabbit.core.config.SearchConfig;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class RepositoryConfig {
    private static Logger log = LoggerFactory.getLogger((Class)RepositoryConfig.class);
    private static final String WORKSPACE_XML = "workspace.xml";
    private Map workspaces = new HashMap();
    private final String home;
    private final SecurityConfig sec;
    private final FileSystemConfig fsc;
    private final String defaultWorkspace;
    private final RepositoryConfigurationParser parser;
    private final String workspaceDirectory;
    private final String workspaceConfigDirectory;
    private final int workspaceMaxIdleTime;
    private final Element template;
    private final VersioningConfig vc;
    private final SearchConfig sc;
    private final ClusterConfig cc;

    public static RepositoryConfig create(String file, String home) throws ConfigurationException {
        URI uri = new File(file).toURI();
        return RepositoryConfig.create(new InputSource(uri.toString()), home);
    }

    public static RepositoryConfig create(URI uri, String home) throws ConfigurationException {
        return RepositoryConfig.create(new InputSource(uri.toString()), home);
    }

    public static RepositoryConfig create(InputStream input, String home) throws ConfigurationException {
        return RepositoryConfig.create(new InputSource(input), home);
    }

    public static RepositoryConfig create(InputSource xml, String home) throws ConfigurationException {
        Properties variables = new Properties();
        variables.setProperty("rep.home", home);
        RepositoryConfigurationParser parser = new RepositoryConfigurationParser(variables);
        RepositoryConfig config = parser.parseRepositoryConfig(xml);
        config.init();
        return config;
    }

    public RepositoryConfig(String home, SecurityConfig sec, FileSystemConfig fsc, String workspaceDirectory, String workspaceConfigDirectory, String defaultWorkspace, int workspaceMaxIdleTime, Element template, VersioningConfig vc, SearchConfig sc, ClusterConfig cc, RepositoryConfigurationParser parser) {
        this.home = home;
        this.sec = sec;
        this.fsc = fsc;
        this.workspaceDirectory = workspaceDirectory;
        this.workspaceConfigDirectory = workspaceConfigDirectory;
        this.workspaceMaxIdleTime = workspaceMaxIdleTime;
        this.defaultWorkspace = defaultWorkspace;
        this.template = template;
        this.vc = vc;
        this.sc = sc;
        this.cc = cc;
        this.parser = parser;
    }

    public void init() throws ConfigurationException, IllegalStateException {
        if (!this.workspaces.isEmpty()) {
            throw new IllegalStateException("Repository configuration has already been initialized.");
        }
        File directory = new File(this.workspaceDirectory);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (this.workspaceConfigDirectory != null) {
            FileSystem fs = this.fsc.createFileSystem();
            try {
                if (!fs.exists(this.workspaceConfigDirectory)) {
                    fs.createFolder(this.workspaceConfigDirectory);
                }
                String[] dirNames = fs.listFolders(this.workspaceConfigDirectory);
                for (int i = 0; i < dirNames.length; ++i) {
                    String configDir = this.workspaceConfigDirectory + "/" + dirNames[i];
                    WorkspaceConfig wc = this.loadWorkspaceConfig(fs, configDir);
                    if (wc == null) continue;
                    this.addWorkspaceConfig(wc);
                }
            }
            catch (FileSystemException e) {
                throw new ConfigurationException("error while loading workspace configurations from path " + this.workspaceConfigDirectory, (Exception)((Object)e));
            }
            finally {
                try {
                    fs.close();
                }
                catch (FileSystemException ignore) {}
            }
        } else {
            File[] files = directory.listFiles();
            if (files == null) {
                throw new ConfigurationException("Invalid workspace root directory: " + this.workspaceDirectory);
            }
            for (int i = 0; i < files.length; ++i) {
                WorkspaceConfig wc = this.loadWorkspaceConfig(files[i]);
                if (wc == null) continue;
                this.addWorkspaceConfig(wc);
            }
        }
        if (!this.workspaces.containsKey(this.defaultWorkspace)) {
            if (!this.workspaces.isEmpty()) {
                log.warn("Potential misconfiguration. No configuration found for default workspace: " + this.defaultWorkspace);
            }
            this.createWorkspaceConfig(this.defaultWorkspace);
        }
    }

    private WorkspaceConfig loadWorkspaceConfig(File directory) throws ConfigurationException {
        try {
            File file = new File(directory, WORKSPACE_XML);
            InputSource xml = new InputSource(new FileReader(file));
            xml.setSystemId(file.toURI().toString());
            Properties variables = new Properties();
            variables.setProperty("wsp.home", directory.getPath());
            RepositoryConfigurationParser localParser = this.parser.createSubParser(variables);
            return localParser.parseWorkspaceConfig(xml);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private WorkspaceConfig loadWorkspaceConfig(FileSystem fs, String configDir) throws ConfigurationException {
        WorkspaceConfig workspaceConfig;
        Reader configReader = null;
        try {
            String configPath = configDir + "/" + WORKSPACE_XML;
            if (!fs.exists(configPath)) {
                WorkspaceConfig workspaceConfig2 = null;
                return workspaceConfig2;
            }
            configReader = new InputStreamReader(fs.getInputStream(configPath));
            InputSource xml = new InputSource(configReader);
            xml.setSystemId(configPath);
            File homeDir = new File(this.workspaceDirectory, FileSystemPathUtil.getName(configDir));
            if (!homeDir.exists()) {
                homeDir.mkdir();
            }
            Properties variables = new Properties();
            variables.setProperty("wsp.home", homeDir.getPath());
            RepositoryConfigurationParser localParser = this.parser.createSubParser(variables);
            workspaceConfig = localParser.parseWorkspaceConfig(xml);
        }
        catch (FileSystemException e) {
            throw new ConfigurationException("Failed to load workspace configuration", (Exception)((Object)e));
        }
        finally {
            if (configReader != null) {
                try {
                    configReader.close();
                }
                catch (IOException ignore) {}
            }
        }
        return workspaceConfig;
    }

    private void addWorkspaceConfig(WorkspaceConfig wc) throws ConfigurationException {
        String name = wc.getName();
        if (this.workspaces.containsKey(name)) {
            throw new ConfigurationException("Duplicate workspace configuration: " + name);
        }
        this.workspaces.put(name, wc);
    }

    private synchronized WorkspaceConfig internalCreateWorkspaceConfig(String name, Element template) throws ConfigurationException {
        File directory = new File(this.workspaceDirectory, name);
        if (!directory.mkdir()) {
            if (directory.exists()) {
                throw new ConfigurationException("Workspace directory already exists: " + name);
            }
            throw new ConfigurationException("Failed to create workspace directory: " + name);
        }
        FileSystem virtualFS = this.workspaceConfigDirectory != null ? this.fsc.createFileSystem() : null;
        try {
            WorkspaceConfig wc;
            OutputStreamWriter configWriter;
            if (virtualFS != null) {
                String configDir = this.workspaceConfigDirectory + "/" + name;
                String configFile = configDir + "/" + WORKSPACE_XML;
                try {
                    virtualFS.createFolder(configDir);
                    configWriter = new OutputStreamWriter(virtualFS.getOutputStream(configFile));
                }
                catch (FileSystemException e) {
                    throw new ConfigurationException("failed to create workspace configuration at path " + configFile, (Exception)((Object)e));
                }
            }
            File file = new File(directory, WORKSPACE_XML);
            try {
                configWriter = new FileWriter(file);
            }
            catch (IOException e) {
                throw new ConfigurationException("failed to create workspace configuration at path " + file.getPath(), e);
            }
            try {
                template.setAttribute("name", name);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(new DOMSource(template), new StreamResult(configWriter));
            }
            catch (TransformerConfigurationException e) {
                throw new ConfigurationException("Cannot create a workspace configuration writer", e);
            }
            catch (TransformerException e) {
                throw new ConfigurationException("Cannot create a workspace configuration file", e);
            }
            finally {
                try {
                    ((Writer)configWriter).close();
                }
                catch (IOException ignore) {}
            }
            if (virtualFS != null) {
                String configDir = this.workspaceConfigDirectory + "/" + name;
                wc = this.loadWorkspaceConfig(virtualFS, configDir);
            } else {
                wc = this.loadWorkspaceConfig(directory);
            }
            if (wc != null) {
                this.addWorkspaceConfig(wc);
                WorkspaceConfig workspaceConfig = wc;
                return workspaceConfig;
            }
            throw new ConfigurationException("Failed to load the created configuration for workspace " + name + ".");
        }
        finally {
            try {
                if (virtualFS != null) {
                    virtualFS.close();
                }
            }
            catch (FileSystemException ignore) {}
        }
    }

    public WorkspaceConfig createWorkspaceConfig(String name) throws ConfigurationException {
        return this.internalCreateWorkspaceConfig(name, this.template);
    }

    public WorkspaceConfig createWorkspaceConfig(String name, InputSource template) throws ConfigurationException {
        ConfigurationParser parser = new ConfigurationParser(new Properties());
        Element workspaceTemplate = parser.parseXML(template);
        return this.internalCreateWorkspaceConfig(name, workspaceTemplate);
    }

    public String getHomeDir() {
        return this.home;
    }

    public FileSystemConfig getFileSystemConfig() {
        return this.fsc;
    }

    public String getAppName() {
        return this.sec.getAppName();
    }

    public AccessManagerConfig getAccessManagerConfig() {
        return this.sec.getAccessManagerConfig();
    }

    public LoginModuleConfig getLoginModuleConfig() {
        return this.sec.getLoginModuleConfig();
    }

    public SecurityConfig getSecurityConfig() {
        return this.sec;
    }

    public String getWorkspacesConfigRootDir() {
        return this.workspaceDirectory;
    }

    public String getDefaultWorkspaceName() {
        return this.defaultWorkspace;
    }

    public int getWorkspaceMaxIdleTime() {
        return this.workspaceMaxIdleTime;
    }

    public Collection getWorkspaceConfigs() {
        return this.workspaces.values();
    }

    public WorkspaceConfig getWorkspaceConfig(String name) {
        return (WorkspaceConfig)this.workspaces.get(name);
    }

    public VersioningConfig getVersioningConfig() {
        return this.vc;
    }

    public SearchConfig getSearchConfig() {
        return this.sc;
    }

    public ClusterConfig getClusterConfig() {
        return this.cc;
    }
}

