/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.jackrabbit.core.cluster.FileRecord;

class FileRecordLog {
    private File file;
    private boolean isNew;
    private DataInputStream in;
    private long minRevision;
    private long maxRevision;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileRecordLog(File file) throws IOException {
        this.file = file;
        if (file.exists()) {
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            try {
                this.minRevision = in.readLong();
                this.maxRevision = this.minRevision + file.length() - 8L;
            }
            finally {
                in.close();
            }
        } else {
            this.isNew = true;
        }
    }

    public long getFirstRevision() {
        return this.minRevision;
    }

    public boolean contains(long revision) {
        return revision >= this.minRevision && revision < this.maxRevision;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void seek(long revision) throws IOException {
        long skiplen;
        long skipped;
        if (this.in != null) {
            String msg = "Seek allowed exactly once.";
            throw new IllegalStateException(msg);
        }
        this.open();
        for (skiplen = revision - this.minRevision + 8L; skiplen > 0L && (skipped = this.in.skip(skiplen)) > 0L; skiplen -= skipped) {
        }
        if (skiplen != 0L) {
            String msg = "Unable to skip remaining bytes.";
            throw new IOException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(FileRecord record) throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(this.file, true));
        try {
            if (this.isNew) {
                out.writeLong(record.getRevision());
            }
            record.append(out);
        }
        finally {
            out.close();
        }
    }

    private void open() throws IOException {
        this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file)));
    }

    protected DataInputStream getInputStream() {
        if (this.in == null) {
            String msg = "Input stream not open.";
            throw new IllegalStateException(msg);
        }
        return this.in;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

