/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.compact.CompactNodeTypeDefReader;
import org.apache.jackrabbit.core.nodetype.compact.ParseException;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.PathFormat;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.apache.jackrabbit.uuid.UUID;

class FileRecordInput {
    private final DataInputStream in;
    private final NamespaceResolver resolver;
    private final ArrayList uuidIndex = new ArrayList();
    private boolean closed;

    public FileRecordInput(DataInputStream in, NamespaceResolver resolver) {
        this.in = in;
        this.resolver = resolver;
    }

    public byte readByte() throws IOException {
        this.checkOpen();
        return this.in.readByte();
    }

    public char readChar() throws IOException {
        this.checkOpen();
        return this.in.readChar();
    }

    public boolean readBoolean() throws IOException {
        this.checkOpen();
        return this.in.readBoolean();
    }

    public int readInt() throws IOException {
        this.checkOpen();
        return this.in.readInt();
    }

    public String readString() throws IOException {
        this.checkOpen();
        boolean isNull = this.in.readBoolean();
        if (isNull) {
            return null;
        }
        return this.in.readUTF();
    }

    public QName readQName() throws IOException, IllegalNameException, UnknownPrefixException {
        this.checkOpen();
        return NameFormat.parse((String)this.readString(), (NamespaceResolver)this.resolver);
    }

    public Path.PathElement readPathElement() throws IOException, IllegalNameException, UnknownPrefixException {
        this.checkOpen();
        QName name = NameFormat.parse((String)this.readString(), (NamespaceResolver)this.resolver);
        int index = this.readInt();
        if (index != 0) {
            return Path.PathElement.create((QName)name, (int)index);
        }
        return Path.PathElement.create((QName)name);
    }

    public Path readPath() throws IOException, MalformedPathException {
        this.checkOpen();
        return PathFormat.parse((String)this.readString(), (NamespaceResolver)this.resolver);
    }

    public NodeId readNodeId() throws IOException {
        this.checkOpen();
        byte uuidType = this.readByte();
        if (uuidType == 73) {
            int index = this.readInt();
            if (index == -1) {
                return null;
            }
            return (NodeId)this.uuidIndex.get(index);
        }
        if (uuidType == 76) {
            byte[] b = new byte[16];
            this.in.readFully(b);
            NodeId nodeId = new NodeId(new UUID(b));
            this.uuidIndex.add(nodeId);
            return nodeId;
        }
        String msg = "UUID type unknown: " + uuidType;
        throw new IOException(msg);
    }

    public PropertyId readPropertyId() throws IOException, IllegalNameException, UnknownPrefixException {
        this.checkOpen();
        return new PropertyId(this.readNodeId(), this.readQName());
    }

    public NodeTypeDef readNodeTypeDef() throws IOException, ParseException {
        this.checkOpen();
        StringReader sr = new StringReader(this.readString());
        CompactNodeTypeDefReader reader = new CompactNodeTypeDefReader(sr, "(internal)");
        List ntds = reader.getNodeTypeDefs();
        if (ntds.size() != 1) {
            throw new IOException("Expected one node type definition: got " + ntds.size());
        }
        return (NodeTypeDef)ntds.get(0);
    }

    public void close() {
        this.checkOpen();
        this.closed = true;
    }

    private void checkOpen() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Input closed.");
        }
    }
}

