/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Iterator;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.QName;

public class ZombieHierarchyManager
extends HierarchyManagerImpl {
    protected ItemStateManager attic;

    public ZombieHierarchyManager(NodeId rootNodeId, ItemStateManager provider, ItemStateManager attic, NamespaceResolver nsResolver) {
        super(rootNodeId, provider, nsResolver);
        this.attic = attic;
    }

    protected ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        if (this.attic.hasItemState(id)) {
            return this.attic.getItemState(id);
        }
        return super.getItemState(id);
    }

    protected boolean hasItemState(ItemId id) {
        if (this.attic.hasItemState(id)) {
            return true;
        }
        return super.hasItemState(id);
    }

    protected NodeId getParentId(ItemState state) {
        if (state.hasOverlayedState()) {
            return state.getOverlayedState().getParentId();
        }
        return super.getParentId(state);
    }

    protected NodeState.ChildNodeEntry getChildNodeEntry(NodeState parent, QName name, int index) {
        Iterator iter = parent.getRemovedChildNodeEntries().iterator();
        while (iter.hasNext()) {
            NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)iter.next();
            if (!entry.getName().equals((Object)name) || entry.getIndex() != index) continue;
            return entry;
        }
        return super.getChildNodeEntry(parent, name, index);
    }

    protected NodeState.ChildNodeEntry getChildNodeEntry(NodeState parent, NodeId id) {
        Iterator iter = parent.getRemovedChildNodeEntries().iterator();
        while (iter.hasNext()) {
            NodeState.ChildNodeEntry entry = (NodeState.ChildNodeEntry)iter.next();
            if (!entry.getId().equals(id)) continue;
            return entry;
        }
        return super.getChildNodeEntry(parent, id);
    }
}

