/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.core.BatchedItemOperations;
import org.apache.jackrabbit.core.CachingHierarchyManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.observation.ObservationManagerImpl;
import org.apache.jackrabbit.core.query.QueryManagerImpl;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.version.DateVersionSelector;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.core.version.VersionSelector;
import org.apache.jackrabbit.core.xml.ImportHandler;
import org.apache.jackrabbit.core.xml.WorkspaceImporter;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.PathFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WorkspaceImpl
implements JackrabbitWorkspace,
EventStateCollectionFactory {
    private static Logger log = LoggerFactory.getLogger((Class)WorkspaceImpl.class);
    protected final WorkspaceConfig wspConfig;
    protected final RepositoryImpl rep;
    protected final LocalItemStateManager stateMgr;
    protected final CachingHierarchyManager hierMgr;
    protected ObservationManagerImpl obsMgr;
    protected QueryManagerImpl queryManager;
    protected final SessionImpl session;
    protected LockManager lockMgr;

    protected WorkspaceImpl(WorkspaceConfig wspConfig, SharedItemStateManager stateMgr, RepositoryImpl rep, SessionImpl session) {
        this.wspConfig = wspConfig;
        this.rep = rep;
        this.stateMgr = this.createItemStateManager(stateMgr);
        this.hierMgr = new CachingHierarchyManager(rep.getRootNodeId(), this.stateMgr, session.getNamespaceResolver());
        this.stateMgr.addListener(this.hierMgr);
        this.session = session;
    }

    public HierarchyManager getHierarchyManager() {
        return this.hierMgr;
    }

    public LocalItemStateManager getItemStateManager() {
        return this.stateMgr;
    }

    void dispose() {
        if (this.obsMgr != null) {
            this.obsMgr.dispose();
            this.obsMgr = null;
        }
        this.stateMgr.dispose();
    }

    public void sanityCheck() throws RepositoryException {
        this.session.sanityCheck();
    }

    public void createWorkspace(String workspaceName) throws AccessDeniedException, RepositoryException {
        this.sanityCheck();
        this.session.createWorkspace(workspaceName);
    }

    public void createWorkspace(String workspaceName, InputSource configTemplate) throws AccessDeniedException, RepositoryException {
        this.sanityCheck();
        this.session.createWorkspace(workspaceName, configTemplate);
    }

    public WorkspaceConfig getConfig() {
        return this.wspConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalCopy(String srcAbsPath, WorkspaceImpl srcWsp, String destAbsPath, int flag) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        Path destPath;
        Path srcPath;
        try {
            srcPath = PathFormat.parse((String)srcAbsPath, (NamespaceResolver)this.session.getNamespaceResolver()).getNormalizedPath();
        }
        catch (MalformedPathException mpe) {
            String msg = "invalid path: " + srcAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
        if (!srcPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + srcAbsPath);
        }
        try {
            destPath = PathFormat.parse((String)destAbsPath, (NamespaceResolver)this.session.getNamespaceResolver()).getNormalizedPath();
        }
        catch (MalformedPathException mpe) {
            String msg = "invalid path: " + destAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
        if (!destPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + destAbsPath);
        }
        BatchedItemOperations ops = new BatchedItemOperations(this.stateMgr, this.rep.getNodeTypeRegistry(), this.session.getLockManager(), this.session, this.hierMgr, this.session.getNamespaceResolver());
        try {
            ops.edit();
        }
        catch (IllegalStateException e) {
            String msg = "unable to start edit operation";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        boolean succeeded = false;
        try {
            ops.copy(srcPath, srcWsp.getItemStateManager(), srcWsp.getHierarchyManager(), ((SessionImpl)srcWsp.getSession()).getAccessManager(), destPath, flag);
            ops.update();
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                ops.cancel();
            }
        }
    }

    public synchronized LockManager getLockManager() throws RepositoryException {
        this.sanityCheck();
        if (this.lockMgr == null) {
            this.lockMgr = this.rep.getLockManager(this.wspConfig.getName());
        }
        return this.lockMgr;
    }

    public String getName() {
        return this.wspConfig.getName();
    }

    public Session getSession() {
        return this.session;
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        this.sanityCheck();
        return this.rep.getNamespaceRegistry();
    }

    public NodeTypeManager getNodeTypeManager() throws RepositoryException {
        this.sanityCheck();
        return this.session.getNodeTypeManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.sanityCheck();
        if (this.getName().equals(srcWorkspace)) {
            String msg = srcWorkspace + ": illegal workspace (same as current)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (!this.session.getAccessManager().canAccess(srcWorkspace)) {
            throw new AccessDeniedException("not authorized to access " + srcWorkspace);
        }
        SessionImpl srcSession = null;
        try {
            srcSession = this.rep.createSession(this.session.getSubject(), srcWorkspace);
            WorkspaceImpl srcWsp = (WorkspaceImpl)srcSession.getWorkspace();
            int mode = 1;
            if (removeExisting) {
                mode = 2;
            }
            this.internalCopy(srcAbsPath, srcWsp, destAbsPath, mode);
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    public void copy(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.sanityCheck();
        this.internalCopy(srcAbsPath, this, destAbsPath, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.sanityCheck();
        if (this.getName().equals(srcWorkspace)) {
            this.copy(srcAbsPath, destAbsPath);
            return;
        }
        if (!this.session.getAccessManager().canAccess(srcWorkspace)) {
            throw new AccessDeniedException("not authorized to access " + srcWorkspace);
        }
        SessionImpl srcSession = null;
        try {
            srcSession = this.rep.createSession(this.session.getSubject(), srcWorkspace);
            WorkspaceImpl srcWsp = (WorkspaceImpl)srcSession.getWorkspace();
            this.internalCopy(srcAbsPath, srcWsp, destAbsPath, 0);
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        Path destPath;
        Path srcPath;
        this.sanityCheck();
        try {
            srcPath = PathFormat.parse((String)srcAbsPath, (NamespaceResolver)this.session.getNamespaceResolver()).getNormalizedPath();
        }
        catch (MalformedPathException mpe) {
            String msg = "invalid path: " + srcAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
        if (!srcPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + srcAbsPath);
        }
        try {
            destPath = PathFormat.parse((String)destAbsPath, (NamespaceResolver)this.session.getNamespaceResolver()).getNormalizedPath();
        }
        catch (MalformedPathException mpe) {
            String msg = "invalid path: " + destAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
        if (!destPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + destAbsPath);
        }
        BatchedItemOperations ops = new BatchedItemOperations(this.stateMgr, this.rep.getNodeTypeRegistry(), this.session.getLockManager(), this.session, this.hierMgr, this.session.getNamespaceResolver());
        try {
            ops.edit();
        }
        catch (IllegalStateException e) {
            String msg = "unable to start edit operation";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        boolean succeeded = false;
        try {
            ops.move(srcPath, destPath);
            ops.update();
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                ops.cancel();
            }
        }
    }

    public ObservationManager getObservationManager() throws RepositoryException {
        this.sanityCheck();
        if (this.obsMgr == null) {
            try {
                this.obsMgr = new ObservationManagerImpl(this.rep.getObservationDispatcher(this.wspConfig.getName()), this.session, this.session.getItemManager());
            }
            catch (NoSuchWorkspaceException nswe) {
                String msg = "internal error: failed to instantiate observation manager";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)nswe);
            }
        }
        return this.obsMgr;
    }

    public synchronized QueryManager getQueryManager() throws RepositoryException {
        this.sanityCheck();
        if (this.queryManager == null) {
            SearchManager searchManager;
            try {
                searchManager = this.rep.getSearchManager(this.wspConfig.getName());
                if (searchManager == null) {
                    String msg = "no search manager configured for this workspace";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
            }
            catch (NoSuchWorkspaceException nswe) {
                String msg = "internal error: failed to instantiate query manager";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)nswe);
            }
            this.queryManager = new QueryManagerImpl(this.session, this.session.getItemManager(), searchManager);
        }
        return this.queryManager;
    }

    public void restore(Version[] versions, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        this.sanityCheck();
        final HashMap<String, VersionImpl> toRestore = new HashMap<String, VersionImpl>();
        for (int i = 0; i < versions.length; ++i) {
            VersionImpl v = (VersionImpl)versions[i];
            VersionHistory vh = v.getContainingHistory();
            if (toRestore.containsKey(vh.getUUID())) {
                throw new VersionException("Unable to restore. Two or more versions have same version history.");
            }
            toRestore.put(vh.getUUID(), v);
        }
        VersionSelector vsel = new VersionSelector(){

            public Version select(VersionHistory versionHistory) throws RepositoryException {
                Version v = (Version)toRestore.get(versionHistory.getUUID());
                if (v == null) {
                    v = DateVersionSelector.selectByDate(versionHistory, null);
                }
                return v;
            }
        };
        if (this.session.hasPendingChanges()) {
            String msg = "Unable to restore version. Session has pending changes.";
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
        try {
            int numRestored = 0;
            while (toRestore.size() > 0) {
                Version[] restored = null;
                Iterator iter = toRestore.values().iterator();
                while (iter.hasNext()) {
                    VersionImpl v = (VersionImpl)iter.next();
                    try {
                        NodeImpl node = (NodeImpl)this.session.getNodeByUUID(v.getFrozenNode().getFrozenUUID());
                        restored = node.internalRestore(v, vsel, removeExisting);
                        for (int i = 0; i < restored.length; ++i) {
                            toRestore.remove(restored[i].getContainingHistory().getUUID());
                        }
                        numRestored += restored.length;
                        break;
                    }
                    catch (ItemNotFoundException e) {
                    }
                }
                if (restored != null) continue;
                if (numRestored == 0) {
                    throw new VersionException("Unable to restore. At least one version needs existing versionable node in workspace.");
                }
                throw new VersionException("Unable to restore. All versions with non existing versionable nodes need parent.");
            }
        }
        catch (RepositoryException e) {
            try {
                log.error("reverting changes applied during restore...");
                this.session.refresh(false);
            }
            catch (RepositoryException e1) {
                // empty catch block
            }
            throw e;
        }
        this.session.save();
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        this.sanityCheck();
        return this.session.getWorkspaceNames();
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        Path parentPath;
        this.sanityCheck();
        try {
            parentPath = PathFormat.parse((String)parentAbsPath, (NamespaceResolver)this.session.getNamespaceResolver()).getNormalizedPath();
        }
        catch (MalformedPathException mpe) {
            String msg = "invalid path: " + parentAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
        if (!parentPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + parentAbsPath);
        }
        WorkspaceImporter importer = new WorkspaceImporter(parentPath, this, this.rep.getNodeTypeRegistry(), uuidBehavior);
        return new ImportHandler(importer, this.session.getNamespaceResolver(), this.rep.getNamespaceRegistry());
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, RepositoryException {
        ImportHandler handler = (ImportHandler)this.getImportContentHandler(parentAbsPath, uuidBehavior);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(in), (DefaultHandler)handler);
        }
        catch (SAXException se) {
            Exception e = se.getException();
            if (e != null && e instanceof RepositoryException) {
                throw (RepositoryException)((Object)e);
            }
            String msg = "failed to parse XML stream";
            log.debug(msg);
            throw new InvalidSerializedDataException(msg, (Throwable)se);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException("SAX parser configuration error", (Throwable)e);
        }
    }

    protected LocalItemStateManager createItemStateManager(SharedItemStateManager shared) {
        return new LocalItemStateManager(shared, this, this.rep.getItemStateCacheFactory());
    }

    public EventStateCollection createEventStateCollection() throws RepositoryException {
        return ((ObservationManagerImpl)this.getObservationManager()).createEventStateCollection();
    }
}

