/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.tools.ant;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteJava;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.jboss.wsf.spi.tools.WSContractProvider;
import org.jboss.wsf.spi.tools.cmd.WSProvide;

public class WSProvideTask
extends Task {
    private Path classpath = new Path(this.getProject());
    private CommandlineJava command = new CommandlineJava();
    private String sei = null;
    private File destdir = null;
    private File resourcedestdir = null;
    private File sourcedestdir = null;
    private boolean keep = false;
    private boolean genwsdl = false;
    private boolean verbose = false;
    private boolean fork = false;
    private boolean debug = false;

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public Commandline.Argument createJvmarg() {
        return this.command.createVmArgument();
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public Path createClasspath() {
        return this.classpath;
    }

    public void setDestdir(File file) {
        this.destdir = file;
    }

    public void setKeep(boolean bl) {
        this.keep = bl;
    }

    public void setSei(String string) {
        this.sei = string;
    }

    public void setFork(boolean bl) {
        this.fork = bl;
    }

    public void setResourcedestdir(File file) {
        this.resourcedestdir = file;
    }

    public void setSourcedestdir(File file) {
        this.sourcedestdir = file;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setGenwsdl(boolean bl) {
        this.genwsdl = bl;
    }

    private ClassLoader getClasspathLoader(ClassLoader classLoader) {
        Object object;
        AntClassLoader antClassLoader = new AntClassLoader(classLoader, this.getProject(), this.classpath, false);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        StringTokenizer stringTokenizer = new StringTokenizer(antClassLoader.getClasspath(), File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                object = stringTokenizer.nextToken();
                if (!((String)object).startsWith("file://")) {
                    object = "file://" + (String)object;
                }
                arrayList.add(new URL((String)object));
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("Failed to wrap classloader", malformedURLException);
            }
        }
        object = new URLClassLoader(arrayList.toArray(new URL[0]), (ClassLoader)antClassLoader);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeNonForked() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = ((Object)((Object)this)).getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader2);
        try {
            WSContractProvider wSContractProvider = WSContractProvider.newInstance(this.getClasspathLoader(classLoader2));
            if (this.verbose) {
                wSContractProvider.setMessageStream(new PrintStream((OutputStream)new LogOutputStream((Task)this, 2)));
            }
            wSContractProvider.setGenerateSource(this.keep);
            wSContractProvider.setGenerateWsdl(this.genwsdl);
            if (this.destdir != null) {
                wSContractProvider.setOutputDirectory(this.destdir);
            }
            if (this.resourcedestdir != null) {
                wSContractProvider.setResourceDirectory(this.resourcedestdir);
            }
            if (this.sourcedestdir != null) {
                wSContractProvider.setSourceDirectory(this.sourcedestdir);
            }
            this.log("Generating from endpoint: " + this.sei, 2);
            wSContractProvider.provide(this.sei);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public void execute() throws BuildException {
        if (this.sei == null) {
            throw new BuildException("The sei attribute must be specified!", this.getLocation());
        }
        if (this.fork) {
            this.executeForked();
        } else {
            this.executeNonForked();
        }
    }

    private Path getTaskClassPath() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (classLoader instanceof AntClassLoader) {
            return new Path(this.getProject(), ((AntClassLoader)classLoader).getClasspath());
        }
        return new Path(this.getProject());
    }

    private void executeForked() throws BuildException {
        this.command.setClassname(WSProvide.class.getName());
        Path path = this.command.createClasspath(this.getProject());
        path.append(this.getTaskClassPath());
        path.append(this.classpath);
        if (this.keep) {
            this.command.createArgument().setValue("-k");
        }
        if (this.genwsdl) {
            this.command.createArgument().setValue("-w");
        }
        if (this.destdir != null) {
            this.command.createArgument().setValue("-o");
            this.command.createArgument().setFile(this.destdir);
        }
        if (this.resourcedestdir != null) {
            this.command.createArgument().setValue("-r");
            this.command.createArgument().setFile(this.resourcedestdir);
        }
        if (this.sourcedestdir != null) {
            this.command.createArgument().setValue("-s");
            this.command.createArgument().setFile(this.sourcedestdir);
        }
        if (!this.verbose) {
            this.command.createArgument().setValue("-q");
        }
        this.command.createArgument().setValue("-t");
        this.command.createArgument().setValue(this.sei);
        if (this.verbose) {
            this.log("Command invoked: " + this.command.getJavaCommand().toString());
        }
        ExecuteJava executeJava = new ExecuteJava();
        executeJava.setClasspath(path);
        executeJava.setJavaCommand(this.command.getJavaCommand());
        if (executeJava.fork((ProjectComponent)this) != 0) {
            throw new BuildException("Could not invoke WSProvideTask", this.getLocation());
        }
    }
}

