/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebserviceDescriptionMetaData {
    private static final Logger log = Logger.getLogger(WebserviceDescriptionMetaData.class);
    private WebservicesMetaData webservices;
    private String webserviceDescriptionName;
    private String wsdlFile;
    private String jaxrpcMappingFile;
    private ArrayList<PortComponentMetaData> portComponents = new ArrayList();

    public WebserviceDescriptionMetaData(WebservicesMetaData webservicesMetaData) {
        this.webservices = webservicesMetaData;
    }

    public WebservicesMetaData getWebservices() {
        return this.webservices;
    }

    public void addPortComponent(PortComponentMetaData portComponentMetaData) {
        this.portComponents.add(portComponentMetaData);
    }

    public PortComponentMetaData[] getPortComponents() {
        PortComponentMetaData[] portComponentMetaDataArray = new PortComponentMetaData[this.portComponents.size()];
        this.portComponents.toArray(portComponentMetaDataArray);
        return portComponentMetaDataArray;
    }

    public Collection<QName> getPortComponentQNames() {
        HashMap<String, QName> hashMap = new HashMap<String, QName>();
        for (PortComponentMetaData portComponentMetaData : this.portComponents) {
            QName qName = portComponentMetaData.getWsdlPort();
            hashMap.put(qName.getPrefix(), qName);
        }
        return hashMap.values();
    }

    public PortComponentMetaData getPortComponentByWsdlPort(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PortComponentMetaData portComponentMetaData : this.portComponents) {
            String string2 = portComponentMetaData.getWsdlPort().getLocalPart();
            if (string2.equals(string)) {
                return portComponentMetaData;
            }
            arrayList.add(string2);
        }
        log.error((Object)("Cannot get port component name '" + string + "', we have: " + arrayList));
        return null;
    }

    public String getWebserviceDescriptionName() {
        return this.webserviceDescriptionName;
    }

    public void setWebserviceDescriptionName(String string) {
        this.webserviceDescriptionName = string;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String string) {
        this.wsdlFile = string;
    }

    public String getJaxrpcMappingFile() {
        return this.jaxrpcMappingFile;
    }

    public void setJaxrpcMappingFile(String string) {
        this.jaxrpcMappingFile = string;
    }

    public String serialize() {
        StringBuilder stringBuilder = new StringBuilder("<webservice-description>");
        stringBuilder.append("<webservice-description-name>").append(this.webserviceDescriptionName).append("</webservice-description-name>");
        stringBuilder.append("<wsdl-file>").append(this.wsdlFile).append("</wsdl-file>");
        stringBuilder.append("<jaxrpc-mapping-file>").append(this.jaxrpcMappingFile).append("</jaxrpc-mapping-file>");
        for (PortComponentMetaData portComponentMetaData : this.portComponents) {
            stringBuilder.append(portComponentMetaData.serialize());
        }
        stringBuilder.append("</webservice-description>");
        return stringBuilder.toString();
    }
}

