/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.util.DateUtils;

public class FtpDirectoryTableModel
implements TableModel {
    private static final long serialVersionUID = 2468107659374857692L;
    private static final int MAX_SIZE = 1000;
    private static final String[] COL_NAMES = new String[]{"Directory", "User", "Time"};
    private Vector entries = new Vector();
    private EventListenerList listeners = new EventListenerList();

    public Class getColumnClass(int index) {
        return String.class;
    }

    public int getColumnCount() {
        return COL_NAMES.length;
    }

    public String getColumnName(int index) {
        return COL_NAMES[index];
    }

    public int getRowCount() {
        return this.entries.size();
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object val, int row, int col) {
    }

    public Object getValueAt(int row, int col) {
        String retVal = "";
        TableEntry entry = null;
        try {
            entry = (TableEntry)this.entries.get(row);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (entry == null) {
            return retVal;
        }
        switch (col) {
            case 0: {
                retVal = entry.dirName;
                break;
            }
            case 1: {
                retVal = entry.userName;
                break;
            }
            case 2: {
                retVal = entry.date;
            }
        }
        return retVal;
    }

    public int findColumn(String columnName) {
        int index = -1;
        int i = COL_NAMES.length;
        while (--i >= 0) {
            if (!COL_NAMES[i].equals(columnName)) continue;
            index = i;
            break;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newEntry(String file, User user) {
        String dirName = file;
        String userName = user.getName();
        String date = DateUtils.getISO8601Date((long)System.currentTimeMillis());
        TableEntry entry = new TableEntry(dirName, userName, date);
        int sz = this.entries.size();
        if (sz >= 1000) {
            this.clear();
            sz = 0;
        }
        Vector vector = this.entries;
        synchronized (vector) {
            this.entries.add(entry);
        }
        this.fireTableChanged(new TableModelEvent(this, ++sz, sz, -1, 1));
    }

    public void clear() {
        this.entries.clear();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(TableModelListener.class, l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(TableModelListener.class, l);
    }

    private void fireTableChanged(TableModelEvent e) {
        Object[] listenerArr = this.listeners.getListenerList();
        for (int i = listenerArr.length - 2; i >= 0; i -= 2) {
            if (listenerArr[i] != (class$javax$swing$event$TableModelListener == null ? FtpDirectoryTableModel.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) continue;
            ((TableModelListener)listenerArr[i + 1]).tableChanged(e);
        }
    }

    private static class TableEntry {
        final String dirName;
        final String userName;
        final String date;

        public TableEntry(String dirName, String userName, String date) {
            this.dirName = dirName;
            this.userName = userName;
            this.date = date;
        }
    }
}

