/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.listener.Connection;
import org.apache.ftpserver.listener.ConnectionManager;
import org.apache.ftpserver.listener.ConnectionManagerObserver;
import org.apache.ftpserver.util.DateUtils;

public class FtpConnectionTableModel
implements TableModel,
ConnectionManagerObserver {
    private static final long serialVersionUID = -6586674924776468079L;
    private static final String[] COL_NAMES = new String[]{"User", "Login Time", "Last Access Time", "IP"};
    private List connections = new Vector();
    private FtpServerContext serverContext;
    private EventListenerList listeners = new EventListenerList();

    public void refresh(FtpServerContext serverContext) {
        this.serverContext = serverContext;
        if (this.serverContext != null) {
            ConnectionManager conManager = this.serverContext.getConnectionManager();
            this.connections = conManager.getAllConnections();
            conManager.setObserver((ConnectionManagerObserver)this);
        } else {
            this.connections.clear();
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public Class getColumnClass(int index) {
        return String.class;
    }

    public int getColumnCount() {
        return COL_NAMES.length;
    }

    public String getColumnName(int index) {
        return COL_NAMES[index];
    }

    public int getRowCount() {
        return this.connections.size();
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object val, int row, int col) {
    }

    public int findColumn(String columnName) {
        int index = -1;
        int i = COL_NAMES.length;
        while (--i >= 0) {
            if (!COL_NAMES[i].equals(columnName)) continue;
            index = i;
            break;
        }
        return index;
    }

    public Object getValueAt(int row, int col) {
        String retVal = "";
        Connection thisCon = null;
        if (row < this.connections.size()) {
            thisCon = (Connection)this.connections.get(row);
        }
        if (thisCon == null) {
            return retVal;
        }
        FtpSession session = thisCon.getSession();
        if (session == null) {
            return retVal;
        }
        User user = session.getUser();
        InetAddress addr = null;
        Date date = null;
        switch (col) {
            case 0: {
                String name;
                if (user == null || (name = user.getName()) == null) break;
                retVal = name;
                break;
            }
            case 1: {
                date = session.getLoginTime();
                if (date == null) break;
                retVal = DateUtils.getISO8601Date((long)date.getTime());
                break;
            }
            case 2: {
                date = session.getLastAccessTime();
                if (date == null) break;
                retVal = DateUtils.getISO8601Date((long)date.getTime());
                break;
            }
            case 3: {
                addr = session.getClientAddress();
                if (addr == null) break;
                retVal = addr.getHostAddress();
            }
        }
        return retVal;
    }

    public Connection getConnection(int index) {
        if (index < this.connections.size()) {
            return (Connection)this.connections.get(index);
        }
        return null;
    }

    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(TableModelListener.class, l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(TableModelListener.class, l);
    }

    private void fireTableChanged(TableModelEvent e) {
        Object[] listenerArr = this.listeners.getListenerList();
        for (int i = listenerArr.length - 2; i >= 0; i -= 2) {
            if (listenerArr[i] != (class$javax$swing$event$TableModelListener == null ? FtpConnectionTableModel.class$("javax.swing.event.TableModelListener") : class$javax$swing$event$TableModelListener)) continue;
            ((TableModelListener)listenerArr[i + 1]).tableChanged(e);
        }
    }

    public void openedConnection(final Connection con) {
        Runnable runnable = new Runnable(){

            public void run() {
                FtpConnectionTableModel.this.connections.add(con);
                int sz = FtpConnectionTableModel.this.connections.size();
                FtpConnectionTableModel.this.fireTableChanged(new TableModelEvent(FtpConnectionTableModel.this, sz, sz, -1, 1));
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void closedConnection(final Connection con) {
        Runnable runnable = new Runnable(){

            public void run() {
                int index = FtpConnectionTableModel.this.connections.indexOf(con);
                if (index != -1) {
                    FtpConnectionTableModel.this.connections.remove(index);
                    FtpConnectionTableModel.this.fireTableChanged(new TableModelEvent(FtpConnectionTableModel.this, index, index, -1, -1));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void updatedConnection(final Connection con) {
        Runnable runnable = new Runnable(){

            public void run() {
                int index = FtpConnectionTableModel.this.connections.indexOf(con);
                if (index != -1) {
                    FtpConnectionTableModel.this.fireTableChanged(new TableModelEvent(FtpConnectionTableModel.this, index, index, -1, 0));
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

