/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.client;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.jboss.logging.Logger;
import org.jboss.remoting.samples.chat.client.ChatInfo;
import org.jboss.remoting.samples.chat.client.ChatMember;
import org.jboss.remoting.samples.chat.client.ChatMessage;
import org.jboss.remoting.samples.chat.client.CloseableFrame;
import org.jboss.remoting.samples.chat.client.ConnectionStrategy;
import org.jboss.remoting.samples.chat.client.CreateConnectionStrategy;
import org.jboss.remoting.samples.chat.client.CreateFrame;
import org.jboss.remoting.samples.chat.client.InfoConnectionStrategy;
import org.jboss.remoting.samples.chat.client.InfoFrame;
import org.jboss.remoting.samples.chat.client.JoinConnectionStrategy;
import org.jboss.remoting.samples.chat.client.JoinFrame;
import org.jboss.remoting.samples.chat.client.ListConnectionStrategy;
import org.jboss.remoting.samples.chat.client.ListFrame;
import org.jboss.remoting.samples.chat.client.RemoteStrategy;
import org.jboss.remoting.samples.chat.client.ShutDownDialog;
import org.jboss.remoting.samples.chat.client.TalkConnectionStrategy;
import org.jboss.remoting.samples.chat.client.TalkFrame;
import org.jboss.remoting.samples.chat.client.Wrapper;
import org.jboss.remoting.samples.chat.exceptions.ConnectionException;
import org.jboss.remoting.samples.chat.exceptions.CreateConnectionException;
import org.jboss.remoting.samples.chat.exceptions.JoinConnectionException;
import org.jboss.remoting.samples.chat.exceptions.ListConnectionException;
import org.jboss.remoting.samples.chat.exceptions.NameInUseException;
import org.jboss.remoting.samples.chat.exceptions.RemoteConnectionException;
import org.jboss.remoting.samples.chat.exceptions.ShuttingDownException;
import org.jboss.remoting.samples.chat.exceptions.TalkConnectionException;
import org.jboss.remoting.samples.chat.server.ChatServer;
import org.jboss.remoting.samples.chat.utility.ReadWriteArrayList;

public class LocalStrategy
implements ConnectionStrategy,
CreateConnectionStrategy,
InfoConnectionStrategy,
JoinConnectionStrategy,
ListConnectionStrategy {
    protected static final Logger log = Logger.getLogger(LocalStrategy.class);
    private RemoteStrategy remoteStrategy;
    private CloseableFrame parent;
    private CreateFrame createFrame;
    private InfoFrame infoFrame;
    private JoinFrame joinFrame;
    private ListFrame listFrame;
    private TalkFrame talkFrame;
    private Thread readThread;
    private boolean isChatting;
    private ShutDownDialog shuttingDownDialog = new ShutDownDialog();
    private Runnable shuttingDownDialogRunnable = new Runnable(){

        public void run() {
            LocalStrategy.this.shuttingDownDialog.show();
        }
    };

    public LocalStrategy(CloseableFrame parent, RemoteStrategy remoteStrategy) {
        this.parent = parent;
        this.remoteStrategy = remoteStrategy;
    }

    public void list() {
        final Wrapper chatRoomDescriptions = new Wrapper();
        Thread t = new Thread(){

            public void run() {
                try {
                    chatRoomDescriptions.set(LocalStrategy.this.remoteStrategy.list());
                }
                catch (ShuttingDownException e) {
                    SwingUtilities.invokeLater(LocalStrategy.this.shuttingDownDialogRunnable);
                }
                catch (RemoteConnectionException e) {
                    log.error((Object)e);
                }
                Runnable r = new Runnable(){

                    public void run() {
                        new ListFrame(LocalStrategy.this, (ArrayList)chatRoomDescriptions.get(), LocalStrategy.this.parent).show();
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        };
        t.start();
    }

    public void create() throws ConnectionException {
        this.createFrame = new CreateFrame(this, this.parent);
        this.createFrame.show();
    }

    public void createChat(final String description, final ChatMember owner) throws CreateConnectionException {
        Thread t = new Thread(){
            TalkFrame talkFrame;
            ReadWriteArrayList outgoingLines;
            ChatServer chatServer;
            {
                this.talkFrame = new TalkFrame(description, owner.get_name(), LocalStrategy.this.parent);
                this.outgoingLines = new ReadWriteArrayList();
                this.chatServer = null;
            }

            public void run() {
                try {
                    this.chatServer = LocalStrategy.this.remoteStrategy.createChat(description, owner, this.talkFrame, this.outgoingLines);
                }
                catch (ShuttingDownException sde) {
                    SwingUtilities.invokeLater(LocalStrategy.this.shuttingDownDialogRunnable);
                }
                catch (RemoteConnectionException e) {
                    log.error((Object)("Cannot create chat room: " + description));
                    log.error((Object)e);
                }
                catch (NameInUseException e) {
                    System.out.println("Pick a new name");
                }
                Runnable r = new Runnable(){

                    public void run() {
                        talkFrame.registerStrategy(new TalkConnectionStrategyImpl(owner, chatServer, outgoingLines));
                        talkFrame.show();
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        };
        t.start();
    }

    public void join(final ChatInfo chatInfo, final ChatMember newMember) throws JoinConnectionException {
        Thread t = new Thread(){
            TalkFrame talkFrame;
            ReadWriteArrayList outgoingLines;
            Wrapper remoteChatServerWrapper;
            ChatServer chatServer;
            {
                this.talkFrame = new TalkFrame(chatInfo.get_description(), newMember.get_name(), LocalStrategy.this.parent);
                this.outgoingLines = new ReadWriteArrayList();
                this.remoteChatServerWrapper = new Wrapper();
                this.chatServer = null;
            }

            public void run() {
                try {
                    this.chatServer = LocalStrategy.this.remoteStrategy.join(chatInfo.get_key(), newMember, this.talkFrame, this.outgoingLines);
                }
                catch (ShuttingDownException sde) {
                    SwingUtilities.invokeLater(LocalStrategy.this.shuttingDownDialogRunnable);
                }
                catch (RemoteConnectionException e) {
                    log.error((Object)("Cannot join chat room: " + chatInfo.get_description()));
                    log.error((Object)e);
                }
                catch (NameInUseException niue) {
                    System.out.println("Pick a new name");
                }
                Runnable r = new Runnable(){

                    public void run() {
                        talkFrame.registerStrategy(new TalkConnectionStrategyImpl(newMember, chatServer, outgoingLines));
                        talkFrame.registerChatKey(chatInfo.get_key());
                        talkFrame.show();
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        };
        t.start();
    }

    public void getId(ChatInfo chatInfo) {
        this.joinFrame = new JoinFrame(chatInfo, this, this.parent);
        this.joinFrame.show();
    }

    public void getInfo(ArrayList chatInfoList, int key) throws ListConnectionException {
        this.infoFrame = new InfoFrame(this, (ChatInfo)chatInfoList.get(key), this.parent);
        this.infoFrame.show();
    }

    public void notifyOnClose(Component c) {
        c.setVisible(false);
    }

    protected boolean isChatting() {
        return this.isChatting;
    }

    protected void setIsChatting(boolean b) {
        this.isChatting = b;
    }

    class TalkConnectionStrategyImpl
    implements TalkConnectionStrategy {
        private ChatServer chatServer;
        private ChatMember member;
        private ReadWriteArrayList outgoingLines;

        public TalkConnectionStrategyImpl(ChatMember member, ChatServer cs, ReadWriteArrayList outgoingLines) {
            this.chatServer = cs;
            this.member = member;
            this.outgoingLines = outgoingLines;
        }

        public void send(ChatMessage message) throws TalkConnectionException {
            this.outgoingLines.add(message);
        }

        public void leave() {
            Thread t = new Thread(){

                public void run() {
                    try {
                        TalkConnectionStrategyImpl.this.chatServer.leave(TalkConnectionStrategyImpl.this.member);
                    }
                    catch (ShuttingDownException sde) {
                        SwingUtilities.invokeLater(LocalStrategy.this.shuttingDownDialogRunnable);
                    }
                    catch (RemoteConnectionException e) {
                        log.error((Object)"TalkConnectionStrategy.leave(): unable to leave chat room");
                        log.error((Object)e);
                    }
                    TalkConnectionStrategyImpl.this.chatServer = null;
                }
            };
            t.start();
        }
    }
}

