/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.util.List;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Transition;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.BitSet;
import org.antlr.misc.IntSet;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public class CyclicDFACodeGenerator {
    protected CodeGenerator parentGenerator;
    protected IntSet visited;
    protected DFA dfa;

    public CyclicDFACodeGenerator(CodeGenerator codeGenerator) {
        this.parentGenerator = codeGenerator;
    }

    public StringTemplate genCyclicLookaheadDecision(StringTemplateGroup stringTemplateGroup, DFA dFA) {
        this.dfa = dFA;
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("cyclicDFA");
        int n = dFA.getDecisionNumber();
        stringTemplate.setAttribute("decisionNumber", (Object)new Integer(n));
        String string = dFA.getDecisionASTNode().getEnclosingRule();
        stringTemplate.setAttribute("ruleName", (Object)string);
        stringTemplate.setAttribute("ruleDescriptor", (Object)this.parentGenerator.grammar.getRule(string));
        stringTemplate.setAttribute("className", (Object)this.parentGenerator.getClassName());
        this.visited = new BitSet(dFA.getNumberOfStates());
        this.walkCyclicDFAGeneratingStateMachine(stringTemplateGroup, stringTemplate, dFA.startState);
        return stringTemplate;
    }

    protected void walkCyclicDFAGeneratingStateMachine(StringTemplateGroup stringTemplateGroup, StringTemplate stringTemplate, DFAState dFAState) {
        StringTemplate stringTemplate2;
        if (this.visited.member(dFAState.stateNumber)) {
            return;
        }
        this.visited.add(dFAState.stateNumber);
        if (dFAState.isAcceptState()) {
            stringTemplate2 = stringTemplateGroup.getInstanceOf("cyclicDFAAcceptState");
            stringTemplate2.setAttribute("predictAlt", (Object)new Integer(dFAState.getUniquelyPredictedAlt()));
        } else {
            stringTemplate2 = this.parentGenerator.canGenerateSwitch(dFAState) ? stringTemplateGroup.getInstanceOf("cyclicDFAStateSwitch") : stringTemplateGroup.getInstanceOf("cyclicDFAState");
            stringTemplate2.setAttribute("needErrorClause", (Object)new Boolean(true));
        }
        stringTemplate2.setAttribute("stateNumber", (Object)new Integer(dFAState.stateNumber));
        if (this.parentGenerator.canGenerateSwitch(dFAState)) {
            this.walkEdgesGeneratingComputedGoto(dFAState, stringTemplateGroup, stringTemplate2, stringTemplate);
        } else {
            this.walkEdgesGeneratingIfThenElse(dFAState, stringTemplateGroup, stringTemplate2, stringTemplate);
        }
        stringTemplate.setAttribute("states", (Object)stringTemplate2);
    }

    protected void walkEdgesGeneratingComputedGoto(DFAState dFAState, StringTemplateGroup stringTemplateGroup, StringTemplate stringTemplate, StringTemplate stringTemplate2) {
        for (int i = 0; i < dFAState.getNumberOfTransitions(); ++i) {
            Transition transition = dFAState.transition(i);
            int n = i + 1;
            Integer n2 = new Integer(n);
            if (transition.label.getAtom() == -2) {
                stringTemplate.removeAttribute("needErrorClause");
                stringTemplate.setAttribute("EOTTargetStateNumber", (Object)new Integer(transition.target.stateNumber));
            } else {
                StringTemplate stringTemplate3 = stringTemplateGroup.getInstanceOf("cyclicDFAEdgeSwitch");
                stringTemplate3.setAttribute("edgeNumber", (Object)n2);
                stringTemplate3.setAttribute("targetStateNumber", (Object)new Integer(transition.target.stateNumber));
                List list = transition.label.getSet().toList();
                for (int j = 0; j < list.size(); ++j) {
                    Integer n3 = (Integer)list.get(j);
                    String string = this.parentGenerator.getTokenTypeAsTargetLabel(n3);
                    list.set(j, string);
                }
                stringTemplate3.setAttribute("labels", (Object)list);
                stringTemplate.setAttribute("edges", (Object)stringTemplate3);
            }
            this.walkCyclicDFAGeneratingStateMachine(stringTemplateGroup, stringTemplate2, (DFAState)transition.target);
        }
    }

    protected void walkEdgesGeneratingIfThenElse(DFAState dFAState, StringTemplateGroup stringTemplateGroup, StringTemplate stringTemplate, StringTemplate stringTemplate2) {
        StringTemplate stringTemplate3 = null;
        for (int i = 0; i < dFAState.getNumberOfTransitions(); ++i) {
            Object object;
            StringTemplate stringTemplate4;
            Transition transition = dFAState.transition(i);
            if (transition.label.getAtom() == -2) {
                stringTemplate4 = stringTemplateGroup.getInstanceOf("eotDFAEdge");
                stringTemplate.removeAttribute("needErrorClause");
                stringTemplate3 = stringTemplate4;
            } else {
                stringTemplate4 = stringTemplateGroup.getInstanceOf("cyclicDFAEdge");
                object = this.parentGenerator.genLabelExpr(stringTemplateGroup, transition, 1);
                stringTemplate4.setAttribute("labelExpr", object);
            }
            stringTemplate4.setAttribute("edgeNumber", (Object)new Integer(i + 1));
            stringTemplate4.setAttribute("targetStateNumber", (Object)new Integer(transition.target.stateNumber));
            if (!transition.label.isSemanticPredicate()) {
                object = (DFAState)transition.target;
                stringTemplate4.setAttribute("predicates", (Object)((DFAState)object).getGatedPredicatesInNFAConfigurations());
            }
            if (transition.label.getAtom() != -2) {
                stringTemplate.setAttribute("edges", (Object)stringTemplate4);
            }
            this.walkCyclicDFAGeneratingStateMachine(stringTemplateGroup, stringTemplate2, (DFAState)transition.target);
        }
        if (stringTemplate3 != null) {
            stringTemplate.setAttribute("edges", stringTemplate3);
        }
    }

    public static class LabelEdgeNumberPair
    implements Comparable {
        public int value;
        public int edgeNumber;

        public LabelEdgeNumberPair(int n, int n2) {
            this.value = n;
            this.edgeNumber = n2;
        }

        public int compareTo(Object object) {
            LabelEdgeNumberPair labelEdgeNumberPair = (LabelEdgeNumberPair)object;
            return this.value - labelEdgeNumberPair.value;
        }

        public boolean equals(Object object) {
            LabelEdgeNumberPair labelEdgeNumberPair = (LabelEdgeNumberPair)object;
            return this.value == labelEdgeNumberPair.value;
        }
    }
}

