/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testing.core.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.drools.testing.core.beans.Result;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;

public abstract class RuleType
implements Serializable {
    private String _name;
    private boolean _fire;
    private boolean _has_fire;
    private List _resultList = new ArrayList();

    public void addResult(Result vResult) throws IndexOutOfBoundsException {
        this._resultList.add(vResult);
    }

    public void addResult(int index, Result vResult) throws IndexOutOfBoundsException {
        this._resultList.add(index, vResult);
    }

    public void deleteFire() {
        this._has_fire = false;
    }

    public Enumeration enumerateResult() {
        return Collections.enumeration(this._resultList);
    }

    public boolean getFire() {
        return this._fire;
    }

    public String getName() {
        return this._name;
    }

    public Result getResult(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._resultList.size()) {
            throw new IndexOutOfBoundsException("getResult: Index value '" + index + "' not in range [0.." + (this._resultList.size() - 1) + "]");
        }
        return (Result)this._resultList.get(index);
    }

    public Result[] getResult() {
        int size = this._resultList.size();
        Result[] array = new Result[size];
        for (int index = 0; index < size; ++index) {
            array[index] = (Result)this._resultList.get(index);
        }
        return array;
    }

    public int getResultCount() {
        return this._resultList.size();
    }

    public boolean hasFire() {
        return this._has_fire;
    }

    public boolean isFire() {
        return this._fire;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateResult() {
        return this._resultList.iterator();
    }

    public void removeAllResult() {
        this._resultList.clear();
    }

    public boolean removeResult(Result vResult) {
        boolean removed = this._resultList.remove(vResult);
        return removed;
    }

    public Result removeResultAt(int index) {
        Object obj = this._resultList.remove(index);
        return (Result)obj;
    }

    public void setFire(boolean fire) {
        this._fire = fire;
        this._has_fire = true;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setResult(int index, Result vResult) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._resultList.size()) {
            throw new IndexOutOfBoundsException("setResult: Index value '" + index + "' not in range [0.." + (this._resultList.size() - 1) + "]");
        }
        this._resultList.set(index, vResult);
    }

    public void setResult(Result[] vResultArray) {
        this._resultList.clear();
        for (int i = 0; i < vResultArray.length; ++i) {
            this._resultList.add(vResultArray[i]);
        }
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

