/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.test;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UnitTestBase {
    private String logEntryTemplate;
    private String className;
    private static Logger logger;

    private UnitTestBase() {
    }

    protected UnitTestBase(String componentName) {
        this.logEntryTemplate = componentName + "." + this.getClass().getName() + ".{0}: {1}";
        this.className = this.getClass().getName();
    }

    protected void entering(String methodName, Object[] params) {
        if (params != null) {
            logger.entering(this.className, methodName, params);
        } else {
            logger.entering(this.className, methodName);
        }
    }

    protected void exiting(String methodName) {
        logger.exiting(this.className, methodName);
    }

    protected void log(Level level, String methodName, String message) {
        Object[] args = new Object[]{methodName, message};
        logger.log(level, MessageFormat.format(this.logEntryTemplate, args));
    }

    protected void log(Level level, String methodName, String message, Object[] params) {
        Object[] args = new Object[]{methodName, message};
        logger.log(level, MessageFormat.format(this.logEntryTemplate, args), params);
    }

    static {
        try {
            logger = Logger.getLogger("com.sun.identity.test");
            logger.addHandler(new FileHandler("logs/unittest"));
            String logLevel = System.getProperty("log.level");
            if (logLevel != null) {
                logger.setLevel(Level.parse(logLevel));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

