/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.cmm.cim.OperationalStatus;
import com.sun.identity.monitoring.Monitoring;
import com.sun.identity.monitoring.MonitoringUtils;
import com.sun.mfwk.instrum.me.CIM_ManagedElementInstrum;
import com.sun.mfwk.instrum.me.CMM_ApplicationSystemInstrum;
import com.sun.mfwk.instrum.me.CMM_ConnectionPoolInstrum;
import com.sun.mfwk.instrum.me.CMM_RemoteServiceAccessPointInstrum;
import com.sun.mfwk.instrum.me.CMM_SWRProtocolEndPointInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceAccessURIInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceInstrum;
import com.sun.mfwk.instrum.me.MfManagedElementInstrumException;
import com.sun.mfwk.instrum.me.settings.CMM_ConnectionPoolSettingInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ConnectionPoolStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_RemoteServiceAccessPointStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ServiceAccessURIStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ServiceStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.MfTransactionInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrumException;
import com.sun.mfwk.instrum.server.MfManagedElementInfo;
import com.sun.mfwk.instrum.server.MfManagedElementServer;
import com.sun.mfwk.instrum.server.MfManagedElementServerException;
import com.sun.mfwk.instrum.server.MfManagedElementType;
import com.sun.mfwk.instrum.server.MfRelationInfo;
import com.sun.mfwk.instrum.server.MfRelationType;
import java.util.HashSet;

public class MonitoringAuth {
    private static CMM_ServiceInstrum amSvcAuth;
    private static CMM_ServiceInstrum amSvcAuthPlugin;
    private static CMM_ServiceInstrum amAuthPluginAD;
    private static CMM_RemoteServiceAccessPointInstrum amAuthRsapAdDest;
    private static CMM_ServiceInstrum amAuthPluginAnonymous;
    private static CMM_ServiceInstrum amAuthPluginCert;
    private static CMM_RemoteServiceAccessPointInstrum amAuthRsapCertDest;
    private static CMM_ServiceInstrum amAuthPluginHttpBasic;
    private static CMM_ServiceInstrum amAuthPluginJdbc;
    private static CMM_RemoteServiceAccessPointInstrum amAuthRsapJdbcDest;
    private static CMM_ServiceInstrum amAuthPluginLdap;
    private static CMM_RemoteServiceAccessPointInstrum amAuthRsapLdapDest;
    private static CMM_ServiceInstrum amAuthPluginMembership;
    private static CMM_RemoteServiceAccessPointInstrum amAuthRsapMembershipDest;
    private static CMM_ServiceInstrum amAuthPluginMsisdn;
    private static CMM_RemoteServiceAccessPointInstrum amAuthRsapMsisdnDest;
    private static CMM_ServiceInstrum amAuthPluginNT;
    private static CMM_RemoteServiceAccessPointInstrum amAuthRsapNtDest;
    private static CMM_ServiceInstrum amAuthPluginRadius;
    private static CMM_RemoteServiceAccessPointInstrum amAuthRsapRadiusDest;
    private static CMM_ServiceInstrum amAuthPluginSafeword;
    private static CMM_RemoteServiceAccessPointInstrum amAuthRsapSafewordDest;
    private static CMM_ServiceInstrum amAuthPluginSaml;
    private static CMM_ServiceInstrum amAuthPluginSecurid;
    private static CMM_SWRProtocolEndPointInstrum amAuthHapSecuridDest;
    private static CMM_ServiceInstrum amAuthPluginUnix;
    private static CMM_SWRProtocolEndPointInstrum amAuthHapUnixDest;
    private static CMM_ServiceInstrum amAuthPluginWindowsDesktopSso;
    private static CMM_RemoteServiceAccessPointInstrum amAuthRsapWindowsDesktopSsoDest;
    private static CMM_ServiceStatsInstrum amAuthSvcStats;
    private static CMM_ServiceAccessURIStatsInstrum amAuthLoginURIStats;
    private static CMM_ServiceAccessURIStatsInstrum amAuthLogoutURIStats;
    private static CMM_ServiceAccessURIStatsInstrum amAuthSvcURIStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amAuthRsapMsisdnStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amAuthRsapNtStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amAuthRsapJdbcStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amAuthRsapRadiusStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amAuthRsapAdStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amAuthRsapCertStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amAuthRsapSafewordStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amAuthRsapLdapStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amAuthRsapWindowsDesktopSsoStats;
    private static CMM_ConnectionPoolInstrum amAuthLdapConnPoolElement;
    private static CMM_ConnectionPoolStatsInstrum amAuthLdapConnPoolStats;
    private static CMM_ConnectionPoolSettingInstrum amAuthLdapConnPoolSetting;
    private static CMM_ServiceAccessURIInstrum am_auth_svc_uri;
    private static CMM_ServiceAccessURIInstrum am_auth_login_uri;
    private static CMM_ServiceAccessURIInstrum am_auth_logout_uri;

    private MonitoringAuth() {
    }

    public static CMM_ConnectionPoolStatsInstrum getConnectionPoolStatsInstrum() {
        return amAuthLdapConnPoolStats;
    }

    protected static int createAuth(MfManagedElementServer mfMEServer, CMM_ApplicationSystemInstrum amAppli) {
        Monitoring.debug.message("MonitoringAuth:createAuth");
        try {
            MfManagedElementInfo meInfo = mfMEServer.makeManagedElementInfo();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("authentication");
            MfRelationInfo relInfo = mfMEServer.makeRelationInfo();
            relInfo.setType(MfRelationType.CMM_HOSTED_SERVICE);
            MfRelationInstrum mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSvcAuth = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("authentication plugins");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuth, relInfo, meInfo);
            amSvcAuthPlugin = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("active directory");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginAD = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("active directory server");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amAuthRsapAdDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amAuthRsapAdDest, relInfo, (CIM_ManagedElementInstrum)amAuthPluginAD);
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("anonymous");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginAnonymous = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("certificate");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginCert = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("cert DB");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amAuthRsapCertDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("jdbc server");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amAuthRsapJdbcDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amAuthRsapJdbcDest, relInfo, (CIM_ManagedElementInstrum)amAuthPluginJdbc);
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("ldap");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginLdap = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("ldap server");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amAuthRsapLdapDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amAuthRsapLdapDest, relInfo, (CIM_ManagedElementInstrum)amAuthPluginLdap);
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("membership");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginMembership = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("ldap server");
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amAuthRsapLdapDest, relInfo, (CIM_ManagedElementInstrum)amAuthPluginMembership);
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("msisdn");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginMsisdn = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("msisdn server");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amAuthRsapMsisdnDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amAuthRsapMsisdnDest, relInfo, (CIM_ManagedElementInstrum)amAuthPluginMsisdn);
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("nt");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginNT = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("nt server");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amAuthRsapNtDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amAuthRsapNtDest, relInfo, (CIM_ManagedElementInstrum)amAuthPluginNT);
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("radius");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginRadius = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("radius server");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amAuthRsapRadiusDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amAuthRsapRadiusDest, relInfo, (CIM_ManagedElementInstrum)amAuthPluginRadius);
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("safeword");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginSafeword = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("safeword server");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amAuthRsapSafewordDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amAuthRsapSafewordDest, relInfo, (CIM_ManagedElementInstrum)amAuthPluginSafeword);
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("saml");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginSaml = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("securid");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginSecurid = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SWR_PROTOCOL_END_POINT);
            meInfo.setName("securid server");
            relInfo.setType(MfRelationType.CMM_RESOURCE_OF_SYSTEM);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amAuthHapSecuridDest = (CMM_SWRProtocolEndPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_RESOURCE);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amAuthPluginSecurid, relInfo, (CIM_ManagedElementInstrum)amAuthHapSecuridDest);
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("unix");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginUnix = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SWR_PROTOCOL_END_POINT);
            meInfo.setName("unix helper");
            relInfo.setType(MfRelationType.CMM_RESOURCE_OF_SYSTEM);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amAuthHapUnixDest = (CMM_SWRProtocolEndPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_RESOURCE);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amAuthPluginUnix, relInfo, (CIM_ManagedElementInstrum)amAuthHapUnixDest);
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("windowsdesktopsso");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuthPlugin, relInfo, meInfo);
            amAuthPluginWindowsDesktopSso = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("kerberos server");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amAuthRsapWindowsDesktopSsoDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amAuthRsapWindowsDesktopSsoDest, relInfo, (CIM_ManagedElementInstrum)amAuthPluginWindowsDesktopSso);
            Monitoring.debug.message("MonitoringAuth:createAuth:svcAccURIs");
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            meInfo.setName("auth service URI");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            am_auth_svc_uri = (CMM_ServiceAccessURIInstrum)mRI.getDestination();
            am_auth_svc_uri.setLabeledURI("%protocol://%host:%port/amserver/authservice");
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcAuth, relInfo, (CIM_ManagedElementInstrum)am_auth_svc_uri);
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            meInfo.setName("auth Login URI");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            am_auth_login_uri = (CMM_ServiceAccessURIInstrum)mRI.getDestination();
            am_auth_login_uri.setLabeledURI("%protocol://%host:%port/amserver/UI/Login");
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcAuth, relInfo, (CIM_ManagedElementInstrum)am_auth_login_uri);
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            meInfo.setName("auth Logout URI");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            am_auth_logout_uri = (CMM_ServiceAccessURIInstrum)mRI.getDestination();
            am_auth_logout_uri.setLabeledURI("%protocol://%host:%port/amserver/UI/Logout");
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcAuth, relInfo, (CIM_ManagedElementInstrum)am_auth_logout_uri);
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcAuth, relInfo, (CIM_ManagedElementInstrum)Monitoring.getAMJAXRPCURI());
            meInfo.setType(MfManagedElementType.CMM_SERVICE_STATS);
            meInfo.setName("auth rqt");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcAuth, relInfo, meInfo);
            amAuthSvcStats = (CMM_ServiceStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI_STATS);
            meInfo.setName("auth login URI");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)am_auth_login_uri, relInfo, meInfo);
            amAuthLoginURIStats = (CMM_ServiceAccessURIStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI_STATS);
            meInfo.setName("auth logout URI");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)am_auth_logout_uri, relInfo, meInfo);
            amAuthLogoutURIStats = (CMM_ServiceAccessURIStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI_STATS);
            meInfo.setName("auth service URI");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)am_auth_svc_uri, relInfo, meInfo);
            amAuthSvcURIStats = (CMM_ServiceAccessURIStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("auth MSISDN server stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAuthRsapMsisdnDest, relInfo, meInfo);
            amAuthRsapMsisdnStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("auth NT server stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAuthRsapNtDest, relInfo, meInfo);
            amAuthRsapNtStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("auth JDBC server stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAuthRsapJdbcDest, relInfo, meInfo);
            amAuthRsapJdbcStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("auth RADIUS server stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAuthRsapRadiusDest, relInfo, meInfo);
            amAuthRsapRadiusStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("auth Active Directory server stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAuthRsapAdDest, relInfo, meInfo);
            amAuthRsapAdStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("auth Certificate server stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAuthRsapCertDest, relInfo, meInfo);
            amAuthRsapCertStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("auth Windows Desktop SSO server stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAuthRsapWindowsDesktopSsoDest, relInfo, meInfo);
            amAuthRsapWindowsDesktopSsoStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("auth SafeWord server stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAuthRsapSafewordDest, relInfo, meInfo);
            amAuthRsapSafewordStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("auth LDAP server stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAuthRsapLdapDest, relInfo, meInfo);
            amAuthRsapLdapStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_CONNECTION_POOL);
            meInfo.setName("auth LDAP connection pool");
            relInfo.setType(MfRelationType.CMM_RESOURCE_OF_SYSTEM);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amAuthLdapConnPoolElement = (CMM_ConnectionPoolInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_RESOURCE);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcAuth, relInfo, (CIM_ManagedElementInstrum)amAuthLdapConnPoolElement);
            meInfo.setType(MfManagedElementType.CMM_CONNECTION_POOL_STATS);
            meInfo.setName("auth LDAP connection pool stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAuthLdapConnPoolElement, relInfo, meInfo);
            amAuthLdapConnPoolStats = (CMM_ConnectionPoolStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_CONNECTION_POOL_SETTING);
            meInfo.setName("auth LDAP connection pool setting");
            relInfo.setType(MfRelationType.CMM_SCOPED_SETTING);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAuthLdapConnPoolElement, relInfo, meInfo);
            amAuthLdapConnPoolSetting = (CMM_ConnectionPoolSettingInstrum)mRI.getDestination();
            MonitoringAuth.initStats();
        }
        catch (MfManagedElementServerException mmese) {
            Monitoring.debug.error("createAuth: " + mmese.getMessage());
        }
        catch (MfRelationInstrumException mrie) {
            Monitoring.debug.error("createAuth: " + mrie.getMessage());
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("createAuth:from initStats(): " + mmeie.getMessage());
        }
        return 0;
    }

    public static void initAttributes() {
    }

    private static void initStats() throws MfManagedElementInstrumException {
        amAuthSvcStats.setInRequestsInBytes(1024L);
        amAuthSvcStats.setOutRequestsInBytes(0L);
        amAuthSvcStats.setSampleInterval(0L);
        MfTransactionInstrum trans = amAuthSvcStats.getTransaction();
        if (trans.start() == -1 && Monitoring.debug.messageEnabled()) {
            Monitoring.debug.message("MonitoringAuth:initStats:trans:code = " + trans.getErrorCode() + ", errmsg = " + trans.getErrorMessage(trans.getErrorCode()));
        }
        Monitoring.debug.message("MonitoringAuth:initStats:trans started");
        if (trans.stop(0) == -1 && Monitoring.debug.messageEnabled()) {
            Monitoring.debug.message("MonitoringAuth:initStats:trans stop:code = " + trans.getErrorCode() + ", errmsg = " + trans.getErrorMessage(trans.getErrorCode()));
        }
        Monitoring.debug.message("MonitoringAuth:initStats:trans ended");
        MonitoringUtils.initConnPoolStats(amAuthLdapConnPoolStats, "authentication");
        MonitoringUtils.initConnPoolSetting(amAuthLdapConnPoolSetting, "authentication");
        MonitoringUtils.initRsapStats(amAuthRsapMsisdnStats, "MSISDN authentication");
        MonitoringUtils.initRsapStats(amAuthRsapNtStats, "NT authentication");
        MonitoringUtils.initRsapStats(amAuthRsapJdbcStats, "JDBC authentication");
        MonitoringUtils.initRsapStats(amAuthRsapRadiusStats, "RADIUS authentication");
        MonitoringUtils.initRsapStats(amAuthRsapAdStats, "AD authentication");
        MonitoringUtils.initRsapStats(amAuthRsapCertStats, "Certificate authentication");
        MonitoringUtils.initRsapStats(amAuthRsapWindowsDesktopSsoStats, "Windows desktop SSO authentication");
        MonitoringUtils.initRsapStats(amAuthRsapSafewordStats, "SafeWord authentication");
        MonitoringUtils.initRsapStats(amAuthRsapLdapStats, "LDAP authentication");
        MonitoringUtils.initSvcUriStats(amAuthLoginURIStats, "auth login");
        MonitoringUtils.initSvcUriStats(amAuthLogoutURIStats, "auth logout");
        MonitoringUtils.initSvcUriStats(amAuthSvcURIStats, "authentication");
    }

    public static void setStatus(OperationalStatus status) {
        HashSet<OperationalStatus> authStatus = new HashSet<OperationalStatus>();
        authStatus.add(status);
        if (amSvcAuth == null || amSvcAuthPlugin == null) {
            return;
        }
        try {
            amSvcAuth.setOperationalStatus(authStatus);
            amSvcAuthPlugin.setOperationalStatus(authStatus);
            if (amAuthPluginAD != null) {
                amAuthPluginAD.setOperationalStatus(authStatus);
            }
            if (amAuthPluginAnonymous != null) {
                amAuthPluginAnonymous.setOperationalStatus(authStatus);
            }
            if (amAuthPluginCert != null) {
                amAuthPluginCert.setOperationalStatus(authStatus);
            }
            if (amAuthPluginHttpBasic != null) {
                amAuthPluginHttpBasic.setOperationalStatus(authStatus);
            }
            if (amAuthPluginJdbc != null) {
                amAuthPluginJdbc.setOperationalStatus(authStatus);
            }
            if (amAuthPluginLdap != null) {
                amAuthPluginLdap.setOperationalStatus(authStatus);
            }
            if (amAuthPluginMembership != null) {
                amAuthPluginMembership.setOperationalStatus(authStatus);
            }
            if (amAuthPluginMsisdn != null) {
                amAuthPluginMsisdn.setOperationalStatus(authStatus);
            }
            if (amAuthPluginNT != null) {
                amAuthPluginNT.setOperationalStatus(authStatus);
            }
            if (amAuthPluginRadius != null) {
                amAuthPluginRadius.setOperationalStatus(authStatus);
            }
            if (amAuthPluginSafeword != null) {
                amAuthPluginSafeword.setOperationalStatus(authStatus);
            }
            if (amAuthPluginSaml != null) {
                amAuthPluginSaml.setOperationalStatus(authStatus);
            }
            if (amAuthPluginSecurid != null) {
                amAuthPluginSecurid.setOperationalStatus(authStatus);
            }
            if (amAuthPluginUnix != null) {
                amAuthPluginUnix.setOperationalStatus(authStatus);
            }
            if (amAuthPluginWindowsDesktopSso != null) {
                amAuthPluginWindowsDesktopSso.setOperationalStatus(authStatus);
            }
            if (am_auth_logout_uri != null) {
                am_auth_logout_uri.setOperationalStatus(authStatus);
            }
            if (am_auth_login_uri != null) {
                am_auth_login_uri.setOperationalStatus(authStatus);
            }
            if (am_auth_svc_uri != null) {
                am_auth_svc_uri.setOperationalStatus(authStatus);
            }
            if (amAuthLdapConnPoolElement != null) {
                amAuthLdapConnPoolElement.setOperationalStatus(authStatus);
            }
            if (amAuthHapUnixDest != null) {
                amAuthHapUnixDest.setOperationalStatus(authStatus);
            }
            if (amAuthRsapAdDest != null) {
                amAuthRsapAdDest.setOperationalStatus(authStatus);
            }
            if (amAuthRsapRadiusDest != null) {
                amAuthRsapRadiusDest.setOperationalStatus(authStatus);
            }
            if (amAuthRsapSafewordDest != null) {
                amAuthRsapSafewordDest.setOperationalStatus(authStatus);
            }
            if (amAuthRsapCertDest != null) {
                amAuthRsapCertDest.setOperationalStatus(authStatus);
            }
            if (amAuthHapSecuridDest != null) {
                amAuthHapSecuridDest.setOperationalStatus(authStatus);
            }
            if (amAuthRsapWindowsDesktopSsoDest != null) {
                amAuthRsapWindowsDesktopSsoDest.setOperationalStatus(authStatus);
            }
            if (amAuthRsapLdapDest != null) {
                amAuthRsapLdapDest.setOperationalStatus(authStatus);
            }
            if (amAuthRsapJdbcDest != null) {
                amAuthRsapJdbcDest.setOperationalStatus(authStatus);
            }
            if (amAuthRsapNtDest != null) {
                amAuthRsapNtDest.setOperationalStatus(authStatus);
            }
            if (amAuthRsapMsisdnDest != null) {
                amAuthRsapMsisdnDest.setOperationalStatus(authStatus);
            }
            if (Monitoring.debug.messageEnabled()) {
                Monitoring.debug.message("MonitoringAuth:setStatus = " + status);
            }
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringAuth:setStatus: " + mmeie.getMessage());
        }
    }

    public static CMM_ServiceStatsInstrum getAuthSvcStats() {
        return amAuthSvcStats;
    }

    protected static CMM_ServiceInstrum getSvcAuth() {
        return amSvcAuth;
    }

    public static void moduleStats(String authModule, String method) {
        if (Monitoring.debug.messageEnabled()) {
            Monitoring.debug.error("MonitoringAuth:moduleStats:authModule = " + authModule + ", method = " + method);
        }
        CMM_RemoteServiceAccessPointStatsInstrum stats = null;
        if (authModule.equalsIgnoreCase("AD")) {
            stats = amAuthRsapAdStats;
        } else if (!authModule.equalsIgnoreCase("Anonymous") && !authModule.equalsIgnoreCase("Application")) {
            if (authModule.equalsIgnoreCase("Cert")) {
                stats = amAuthRsapCertStats;
            } else if (!authModule.equalsIgnoreCase("DataStore") && !authModule.equalsIgnoreCase("HTTPBasic")) {
                if (authModule.equalsIgnoreCase("JDBC")) {
                    stats = amAuthRsapJdbcStats;
                } else if (authModule.equalsIgnoreCase("LDAP")) {
                    stats = amAuthRsapLdapStats;
                } else if (!authModule.equalsIgnoreCase("Membership")) {
                    if (authModule.equalsIgnoreCase("MSISDN")) {
                        stats = amAuthRsapMsisdnStats;
                    } else if (authModule.equalsIgnoreCase("NT")) {
                        stats = amAuthRsapNtStats;
                    } else if (authModule.equalsIgnoreCase("RADIUS")) {
                        stats = amAuthRsapRadiusStats;
                    } else if (authModule.equalsIgnoreCase("SafeWord")) {
                        stats = amAuthRsapSafewordStats;
                    } else if (!(authModule.equalsIgnoreCase("SAML") || authModule.equalsIgnoreCase("SecurID") || authModule.equalsIgnoreCase("Unix"))) {
                        if (authModule.equalsIgnoreCase("WindowsDesktopSSO")) {
                            stats = amAuthRsapWindowsDesktopSsoStats;
                        } else {
                            Monitoring.debug.error("MonitoringAuth:moduleStats:don't know this module: " + authModule);
                        }
                    }
                }
            }
        }
        if (stats != null) {
            try {
                if (method.equalsIgnoreCase("login")) {
                    stats.addRequestsCount(1L);
                } else if (method.equalsIgnoreCase("commit")) {
                    stats.addConnectionsCount(1L);
                } else if (method.equalsIgnoreCase("abort")) {
                    stats.addAbortedConnectionsCount(1L);
                } else {
                    Monitoring.debug.error("MonitoringAuth:moduleStats:don't know this method: " + method);
                }
            }
            catch (MfManagedElementInstrumException meie) {
                Monitoring.debug.error("MonitoringAuth:moduleStats:error updating stats: " + meie.getMessage());
            }
        }
    }

    public static void incrementAuthLoginURI(boolean successful) {
        if (Monitoring.debug.messageEnabled()) {
            Monitoring.debug.message("incrementAuthLoginURI: successful = " + successful + ", amAuthLoginURIStats = " + amAuthLoginURIStats);
        }
        if (amAuthLoginURIStats == null) {
            return;
        }
        try {
            if (successful) {
                amAuthLoginURIStats.addRequestsCount(1L);
            } else {
                amAuthLoginURIStats.addFailedRequestsCount(1L);
            }
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringAuth:incrementAuthLoginURI:successful = " + successful + ", error = " + mmeie.getMessage());
        }
    }

    public static void incrementAuthLogoutURI(boolean successful) {
        if (Monitoring.debug.messageEnabled()) {
            Monitoring.debug.message("incrementAuthLogoutURI: successful = " + successful + ", amAuthLogoutURIStats = " + amAuthLogoutURIStats);
        }
        if (amAuthLogoutURIStats == null) {
            return;
        }
        try {
            if (successful) {
                amAuthLogoutURIStats.addRequestsCount(1L);
            } else {
                amAuthLogoutURIStats.addFailedRequestsCount(1L);
            }
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringAuth:incrementAuthLogoutURI:successful = " + successful + ", error = " + mmeie.getMessage());
        }
    }
}

