/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.context.impl;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.context.Status;
import com.sun.identity.xacml.context.StatusCode;
import com.sun.identity.xacml.context.StatusDetail;
import com.sun.identity.xacml.context.StatusMessage;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StatusImpl
implements Status {
    private StatusCode statusCode;
    private StatusMessage statusMessage;
    private StatusDetail statusDetail;
    private boolean mutable = true;

    public StatusImpl() throws XACMLException {
    }

    public StatusImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument((String)xml, (Debug)XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("StatusImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public StatusImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (statusCode == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        this.statusCode = statusCode;
    }

    public StatusMessage getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(StatusMessage statusMessage) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        this.statusMessage = statusMessage;
    }

    public StatusDetail getStatusDetail() {
        return this.statusDetail;
    }

    public void setStatusDetail(StatusDetail statusDetail) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        this.statusDetail = statusDetail;
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        StringBuffer sb = new StringBuffer(2000);
        String nsPrefix = "";
        String nsDeclaration = "";
        if (includeNSPrefix) {
            nsPrefix = XACMLConstants.CONTEXT_NS_PREFIX + ":";
        }
        if (declareNS) {
            nsDeclaration = XACMLConstants.CONTEXT_NS_DECLARATION;
        }
        sb.append("<").append(nsPrefix).append("Status").append(nsDeclaration).append(">\n");
        if (this.statusCode != null) {
            sb.append(this.statusCode.toXMLString(includeNSPrefix, false));
        }
        if (this.statusMessage != null) {
            sb.append(this.statusMessage.toXMLString(includeNSPrefix, false));
        }
        if (this.statusDetail != null) {
            sb.append(this.statusDetail.toXMLString(includeNSPrefix, false));
        }
        sb.append("</").append(nsPrefix).append("Status").append(">\n");
        return sb.toString();
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void makeImmutable() {
        if (this.mutable) {
            if (this.statusCode != null) {
                this.statusCode.makeImmutable();
            }
            if (this.statusMessage != null) {
                this.statusMessage.makeImmutable();
            }
            if (this.statusDetail != null) {
                this.statusDetail.makeImmutable();
            }
            this.mutable = false;
        }
    }

    private void processElement(Element element) throws XACMLException {
        if (element == null) {
            XACMLSDKUtils.debug.error("StatusImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            XACMLSDKUtils.debug.error("StatusImpl.processElement(): local name missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        if (!elemName.equals("Status")) {
            XACMLSDKUtils.debug.error("StatusImpl.processElement(): invalid local name " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_local_name"));
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        ArrayList<Node> childElements = new ArrayList<Node>();
        for (int i = 0; i < numOfNodes; ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            childElements.add(child);
        }
        int childCount = childElements.size();
        if (childCount < 1) {
            XACMLSDKUtils.debug.error("StatusImpl.processElement(): invalid child element count: " + childCount);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_child_count"));
        }
        if (childCount > 3) {
            XACMLSDKUtils.debug.error("StatusImpl.processElement(): invalid child element count: " + childCount);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_child_count"));
        }
        Element firstChild = (Element)childElements.get(0);
        String firstChildName = firstChild.getLocalName();
        if (!firstChildName.equals("StatusCode")) {
            XACMLSDKUtils.debug.error("StatusImpl.processElement(): invalid first child element: " + firstChildName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_first_child"));
        }
        this.statusCode = ContextFactory.getInstance().createStatusCode(firstChild);
        if (childCount > 1) {
            Element secondChild = (Element)childElements.get(1);
            String secondChildName = secondChild.getLocalName();
            if (secondChildName.equals("StatusMessage")) {
                this.statusMessage = ContextFactory.getInstance().createStatusMessage(secondChild);
            } else if (secondChildName.equals("StatusDetail")) {
                if (childCount == 2) {
                    this.statusDetail = ContextFactory.getInstance().createStatusDetail(secondChild);
                } else {
                    XACMLSDKUtils.debug.error("StatusImpl.processElement(): invalid second child element: " + secondChildName);
                    throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_second_child"));
                }
            }
            if (childCount > 2) {
                Element thirdChild = (Element)childElements.get(2);
                String thirdChildName = thirdChild.getLocalName();
                if (thirdChildName.equals("StatusDetail")) {
                    this.statusDetail = ContextFactory.getInstance().createStatusDetail(thirdChild);
                } else {
                    XACMLSDKUtils.debug.error("StatusImpl.processElement(): invalid third child element: " + thirdChildName);
                    throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_third_child"));
                }
            }
        }
    }
}

