/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.context.impl;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.StatusCode;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StatusCodeImpl
implements StatusCode {
    String value = null;
    String minorCodeValue = null;
    private boolean mutable = true;

    public StatusCodeImpl() throws XACMLException {
    }

    public StatusCodeImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument((String)xml, (Debug)XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("StatusCodeImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public StatusCodeImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (value == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        if (!XACMLSDKUtils.isValidStatusCode(value)) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_value"));
        }
        this.value = value;
    }

    public String getMinorCodeValue() {
        return this.minorCodeValue;
    }

    public void setMinorCodeValue(String minorCodeValue) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (this.value == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("null_not_valid"));
        }
        if (!XACMLSDKUtils.isValidMinorStatusCode(this.value)) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_value"));
        }
        this.minorCodeValue = minorCodeValue;
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        StringBuffer sb = new StringBuffer(2000);
        String nsPrefix = "";
        String nsDeclaration = "";
        if (includeNSPrefix) {
            nsPrefix = XACMLConstants.CONTEXT_NS_PREFIX + ":";
        }
        if (declareNS) {
            nsDeclaration = XACMLConstants.CONTEXT_NS_DECLARATION;
        }
        sb.append("<").append(nsPrefix).append("StatusCode").append(" ").append(nsDeclaration);
        if (this.value != null) {
            sb.append("Value").append("=").append(XACMLSDKUtils.quote(this.value));
        }
        sb.append(">");
        if (this.minorCodeValue != null) {
            sb.append("<").append(nsPrefix).append("StatusCode").append(" ").append(nsDeclaration).append("Value").append("=").append(XACMLSDKUtils.quote(this.minorCodeValue)).append(">");
            sb.append("</").append(nsPrefix).append("StatusCode").append(">");
        }
        sb.append("</").append(nsPrefix).append("StatusCode").append(">\n");
        return sb.toString();
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    private void processElement(Element element) throws XACMLException {
        if (element == null) {
            XACMLSDKUtils.debug.error("StatusMessageImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            XACMLSDKUtils.debug.error("StatusMessageImpl.processElement(): local name missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        if (!elemName.equals("StatusCode")) {
            XACMLSDKUtils.debug.error("StatusMessageImpl.processElement(): invalid local name " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_local_name"));
        }
        String attrValue = element.getAttribute("Value");
        if (attrValue == null || attrValue.length() == 0) {
            XACMLSDKUtils.debug.error("StatusCodeImpl.processElement(): statuscode missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_status_code"));
        }
        if (!XACMLSDKUtils.isValidStatusMessage(attrValue.trim())) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_value"));
        }
        this.value = attrValue;
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        ArrayList<Node> childElements = new ArrayList<Node>();
        for (int i = 0; i < numOfNodes; ++i) {
            Node child = nodes.item(i);
            if (child.getNodeType() != 1) continue;
            childElements.add(child);
        }
        int childCount = childElements.size();
        if (childCount > 1) {
            XACMLSDKUtils.debug.error("ResultImpl.processElement(): invalid child element count: " + childCount);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_child_count"));
        }
        if (childCount == 1) {
            Element childElement = (Element)childElements.get(0);
            elemName = childElement.getLocalName();
            if (elemName == null) {
                XACMLSDKUtils.debug.error("StatusMessageImpl.processElement(): local name missing");
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
            }
            if (!elemName.equals("StatusCode")) {
                XACMLSDKUtils.debug.error("StatusMessageImpl.processElement(): invalid local name " + elemName);
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_local_name"));
            }
            attrValue = childElement.getAttribute("Value");
            if (attrValue == null || attrValue.length() == 0) {
                XACMLSDKUtils.debug.error("StatusCodeImpl.processElement(): minor statuscode missing");
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_minor_status_code"));
            }
            if (!XACMLSDKUtils.isValidStatusMessage(attrValue.trim())) {
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_value"));
            }
            this.minorCodeValue = attrValue;
        }
    }
}

