/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.context.impl;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.Attribute;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.context.Resource;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceImpl
implements Resource {
    private List attributes;
    private Element resourceContent;
    private boolean isMutable = true;

    public ResourceImpl() {
    }

    public ResourceImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument((String)xml, (Debug)XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("SubjectImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public ResourceImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws XACMLException {
        if (element == null) {
            XACMLSDKUtils.debug.error("ResourceImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            XACMLSDKUtils.debug.error("ResourceImpl.processElement(): local name missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        if (!elemName.equals(XACMLConstants.RESOURCE)) {
            XACMLSDKUtils.debug.error("ResourceImpl.processElement(): invalid local name " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_local_name"));
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        if (numOfNodes > 0) {
            ContextFactory factory = ContextFactory.getInstance();
            for (int i = 0; i < numOfNodes; ++i) {
                Node child = nodes.item(i);
                if (child.getNodeType() != 1) continue;
                String childName = child.getLocalName();
                if (childName.equals(XACMLConstants.ATTRIBUTE)) {
                    if (this.attributes == null) {
                        this.attributes = new ArrayList();
                    }
                    Attribute attribute = factory.getInstance().createAttribute((Element)child);
                    this.attributes.add(attribute);
                    continue;
                }
                if (!childName.equals(XACMLConstants.RESOURCE_CONTENT)) continue;
                this.resourceContent = (Element)child;
            }
        }
    }

    public Element getResourceContent() {
        return this.resourceContent;
    }

    public void setResourceContent(Element resourceContent) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        String elemName = resourceContent.getLocalName();
        if (elemName == null || !elemName.equals(XACMLConstants.RESOURCE_CONTENT)) {
            XACMLSDKUtils.debug.error("StatusMessageImpl.processElement():local name missing or incorrect");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        this.resourceContent = resourceContent;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attributes) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (attributes != null && !attributes.isEmpty()) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.addAll(attributes);
        }
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        StringBuffer sb = new StringBuffer(2000);
        StringBuffer NS = new StringBuffer(100);
        String appendNS = "";
        if (declareNS) {
            NS.append(XACMLConstants.CONTEXT_NS_DECLARATION).append(XACMLConstants.SPACE);
            NS.append(XACMLConstants.XSI_NS_URI).append(XACMLConstants.SPACE).append(XACMLConstants.CONTEXT_SCHEMA_LOCATION);
        }
        if (includeNSPrefix) {
            appendNS = XACMLConstants.CONTEXT_NS_PREFIX + ":";
        }
        sb.append("<").append(appendNS).append(XACMLConstants.RESOURCE).append(NS);
        sb.append(">");
        int length = 0;
        if (this.attributes != null) {
            sb.append("\n");
            length = this.attributes.size();
            for (int i = 0; i < length; ++i) {
                Attribute attr = (Attribute)this.attributes.get(i);
                sb.append(attr.toXMLString(includeNSPrefix, false));
            }
        }
        if (this.resourceContent != null) {
            sb.append("\n");
            if (includeNSPrefix && this.resourceContent.getPrefix() == null) {
                this.resourceContent.setPrefix(appendNS.substring(0, appendNS.length() - 1));
            }
            if (declareNS) {
                int index = NS.indexOf("=");
                String namespaceName = NS.substring(0, index);
                String namespaceURI = NS.substring(index + 1);
                if (this.resourceContent.getNamespaceURI() == null) {
                    this.resourceContent.setAttribute(namespaceName, namespaceURI);
                }
            }
            sb.append(XMLUtils.print((Node)this.resourceContent));
        }
        sb.append("</").append(appendNS).append(XACMLConstants.RESOURCE);
        sb.append(">\n");
        return sb.toString();
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, false);
    }

    public void makeImmutable() {
    }

    public boolean isMutable() {
        return this.isMutable;
    }
}

