/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.servlet;

import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.wsfederation.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.wsfederation.logging.LogUtil;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import com.sun.identity.wsfederation.plugins.IDPAccountMapper;
import com.sun.identity.wsfederation.plugins.IDPAttributeMapper;
import com.sun.identity.wsfederation.profile.IDPSSOUtil;
import com.sun.identity.wsfederation.profile.RequestSecurityTokenResponse;
import com.sun.identity.wsfederation.profile.SAML11RequestedSecurityToken;
import com.sun.identity.wsfederation.servlet.WSFederationAction;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPSigninRequest
extends WSFederationAction {
    private static Debug debug = WSFederationUtils.debug;
    String wtrealm;
    String whr;
    String wct;
    String wctx;
    String wreply;

    public IPSigninRequest(HttpServletRequest request, HttpServletResponse response, String whr, String wtrealm, String wct, String wctx, String wreply) {
        super(request, response);
        this.whr = whr;
        this.wtrealm = wtrealm;
        this.wct = wct;
        this.wctx = wctx;
        this.wreply = wreply;
    }

    @Override
    public void process() throws IOException, WSFederationException {
        String classMethod = "IPSigninRequest.process: ";
        Object session = null;
        String idpMetaAlias = WSFederationMetaUtils.getMetaAliasByUri(this.request.getRequestURI());
        if (idpMetaAlias == null || idpMetaAlias.trim().length() == 0) {
            debug.error(classMethod + "unable to get IDP meta alias from request.");
            throw new WSFederationException(WSFederationUtils.bundle.getString("IDPMetaAliasNotFound"));
        }
        String idpEntityID = WSFederationMetaManager.getEntityByMetaAlias(idpMetaAlias);
        if (idpEntityID == null || idpEntityID.trim().length() == 0) {
            debug.error(classMethod + "Unable to get IDP Entity ID from metaAlias");
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullIDPEntityID"));
        }
        String realm = WSFederationMetaUtils.getRealmByMetaAlias(idpMetaAlias);
        String spEntityID = WSFederationMetaManager.getEntityByTokenIssuerName(realm, this.wtrealm);
        if (spEntityID == null || spEntityID.trim().length() == 0) {
            debug.error(classMethod + "Unable to get SP Entity ID from wtrealm");
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullIDPEntityID"));
        }
        if (!WSFederationMetaManager.isTrustedProvider(realm, idpEntityID, spEntityID)) {
            debug.error(classMethod + "The remote provider is not valid.");
            throw new WSFederationException(WSFederationUtils.bundle.getString("invalidReceiver"));
        }
        try {
            session = WSFederationUtils.sessionProvider.getSession(this.request);
        }
        catch (SessionException se) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "Unable to retrieve user session.");
            }
            session = null;
        }
        if (session == null) {
            this.redirectAuthentication(idpEntityID, realm);
            return;
        }
        boolean sessionUpgrade = false;
        if (!sessionUpgrade) {
            MultiProtocolUtils.addFederationProtocol(session, "wsfed");
            this.sendResponse(session, idpEntityID, spEntityID, idpMetaAlias, realm);
        }
    }

    private void redirectAuthentication(String idpEntityID, String realm) throws WSFederationException, IOException {
        String classMethod = "IDPSSOFederate.redirectAuthentication: ";
        StringBuffer newURL = new StringBuffer(IDPSSOUtil.getAuthenticationServiceURL(realm, idpEntityID, this.request));
        if (newURL.indexOf("?") == -1) {
            newURL.append("?goto=");
        } else {
            newURL.append("&goto=");
        }
        StringBuffer target = this.request.getRequestURL().append("?").append(this.request.getQueryString());
        if (debug.messageEnabled()) {
            debug.message(classMethod + "Target to get back here: " + target.toString());
        }
        newURL.append(URLEncDec.encode((String)target.toString()));
        if (debug.messageEnabled()) {
            debug.message(classMethod + "New URL for authentication: " + newURL.toString());
        }
        WSFederationUtils.sessionProvider.setLoadBalancerCookie(this.response);
        this.response.sendRedirect(newURL.toString());
    }

    private void sendResponse(Object session, String idpEntityId, String spEntityId, String idpMetaAlias, String realm) throws WSFederationException, IOException {
        RequestSecurityTokenResponse rstr;
        String strWantAssertionSigned;
        String classMethod = "IDPSSOFederate.sendResponse: ";
        String acsURL = IDPSSOUtil.getACSurl(spEntityId, realm, this.wreply);
        if (acsURL == null || acsURL.trim().length() == 0) {
            debug.error(classMethod + "no ACS URL found.");
            String[] data = new String[]{this.wtrealm};
            LogUtil.error(Level.INFO, "NO_ACS_URL", data, null);
            throw new WSFederationException(WSFederationUtils.bundle.getString("unableTofindACSURL"));
        }
        IDPSSOConfigElement idpConfig = WSFederationMetaManager.getIDPSSOConfig(realm, idpEntityId);
        if (idpConfig == null) {
            debug.error(classMethod + "cannot find configuration for IdP " + idpEntityId);
            throw new WSFederationException(WSFederationUtils.bundle.getString("unableToFindIDPConfiguration"));
        }
        SPSSOConfigElement spConfig = WSFederationMetaManager.getSPSSOConfig(realm, spEntityId);
        if (spConfig == null) {
            debug.error(classMethod + "cannot find configuration for SP " + spEntityId);
            throw new WSFederationException(WSFederationUtils.bundle.getString("unableToFindSPConfiguration"));
        }
        String authMethod = null;
        String authSSOInstant = null;
        String userid = null;
        try {
            authMethod = WSFederationUtils.sessionProvider.getProperty(session, "authMethod")[0];
            authSSOInstant = WSFederationUtils.sessionProvider.getProperty(session, "authInstant")[0];
            userid = WSFederationUtils.sessionProvider.getProperty(session, "UserId")[0];
        }
        catch (SessionException se) {
            throw new WSFederationException((Throwable)((Object)se));
        }
        IDPAttributeMapper attrMapper = IPSigninRequest.getIDPAttributeMapper(WSFederationMetaUtils.getAttributes(idpConfig));
        IDPAccountMapper accountMapper = IPSigninRequest.getIDPAccountMapper(WSFederationMetaUtils.getAttributes(idpConfig));
        List attributes = attrMapper.getAttributes(session, idpEntityId, spEntityId, realm);
        Date authInstant = null;
        if (authSSOInstant == null || authSSOInstant.equals("")) {
            authInstant = new Date();
        } else {
            try {
                authInstant = DateUtils.stringToDate((String)authSSOInstant);
            }
            catch (ParseException pe) {
                throw new WSFederationException(pe);
            }
        }
        NameIdentifier ni = accountMapper.getNameID(session, realm, idpEntityId, spEntityId);
        int notBeforeSkew = 600;
        String notBeforeSkewStr = WSFederationMetaUtils.getAttribute(idpConfig, "assertionNotBeforeTimeSkew");
        if (notBeforeSkewStr != null) {
            try {
                notBeforeSkew = Integer.parseInt(notBeforeSkewStr);
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "got not before skew from config:" + notBeforeSkew);
                }
            }
            catch (NumberFormatException nfe) {
                debug.error(classMethod + "Failed to get not before skew from IDP SSO config: ", (Throwable)nfe);
                throw new WSFederationException(nfe);
            }
        }
        int effectiveTime = 600;
        String effectiveTimeStr = WSFederationMetaUtils.getAttribute(idpConfig, "assertionEffectiveTime");
        if (effectiveTimeStr != null) {
            try {
                effectiveTime = Integer.parseInt(effectiveTimeStr);
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "got effective time from config:" + effectiveTime);
                }
            }
            catch (NumberFormatException nfe) {
                debug.error(classMethod + "Failed to get assertion effective time from " + "IDP SSO config: ", (Throwable)nfe);
                throw new WSFederationException(nfe);
            }
        }
        boolean wantAssertionSigned = (strWantAssertionSigned = WSFederationMetaUtils.getAttribute(spConfig, "wantAssertionSigned")) != null ? Boolean.parseBoolean(strWantAssertionSigned) : true;
        String certAlias = WSFederationMetaUtils.getAttribute(idpConfig, "signingCertAlias");
        if (wantAssertionSigned && certAlias == null) {
            debug.error(classMethod + "SP wants signed assertion, but no signing cert is " + "configured");
            throw new WSFederationException(WSFederationUtils.bundle.getString("noIdPCertAlias"));
        }
        if (!wantAssertionSigned) {
            certAlias = null;
        }
        if ((rstr = new RequestSecurityTokenResponse(new SAML11RequestedSecurityToken(realm, spEntityId, idpEntityId, notBeforeSkew, effectiveTime, certAlias, authMethod, authInstant, ni, attributes), this.wtrealm)) == null) {
            debug.error(classMethod + "response is null");
            String errorMsg = WSFederationUtils.bundle.getString("UnableToCreateAssertion");
            return;
        }
        try {
            ArrayList<String> newSpList;
            String[] values = new String[]{idpMetaAlias};
            String[] spList = WSFederationUtils.sessionProvider.getProperty(session, "sun-fm-wsfed-sp-list");
            ArrayList<String> arrayList = newSpList = spList != null ? new ArrayList<String>(Arrays.asList(spList)) : new ArrayList();
            if (!newSpList.contains(spEntityId)) {
                newSpList.add(spEntityId);
                WSFederationUtils.sessionProvider.setProperty(session, "sun-fm-wsfed-sp-list", newSpList.toArray(new String[0]));
            }
        }
        catch (SessionException e) {
            debug.error(classMethod + "error setting idpMetaAlias into the session: ", (Throwable)((Object)e));
        }
        try {
            this.postToTarget(rstr, acsURL);
        }
        catch (ServletException se) {
            throw new WSFederationException(se);
        }
    }

    private void postToTarget(RequestSecurityTokenResponse rstr, String targetURL) throws IOException, ServletException {
        String classMethod = "IDPSSOUtil.postToTarget: ";
        String wresult = XMLUtils.escapeSpecialCharacters((String)rstr.toString());
        if (debug.messageEnabled()) {
            debug.message(classMethod + "wresult: " + wresult);
        }
        this.request.setAttribute("com.sun.identity.wsfederation.post.action", (Object)targetURL);
        this.request.setAttribute("com.sun.identity.wsfederation.post.wa", (Object)"wsignin1.0");
        this.request.setAttribute("com.sun.identity.wsfederation.post.wctx", (Object)this.wctx);
        this.request.setAttribute("com.sun.identity.wsfederation.post.wresult", (Object)wresult);
        this.request.getRequestDispatcher("/wsfederation/jsp/post.jsp").forward((ServletRequest)this.request, (ServletResponse)this.response);
    }

    private static IDPAccountMapper getIDPAccountMapper(Map<String, List<String>> attributes) throws WSFederationException {
        IDPAccountMapper accountMapper = null;
        List<String> accountMapperList = attributes.get("idpAccountMapper");
        if (accountMapperList != null) {
            try {
                accountMapper = (IDPAccountMapper)Class.forName(accountMapperList.get(0)).newInstance();
            }
            catch (ClassNotFoundException cfe) {
                throw new WSFederationException(cfe);
            }
            catch (InstantiationException ie) {
                throw new WSFederationException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new WSFederationException(iae);
            }
        }
        if (accountMapper == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("failedAcctMapper"));
        }
        return accountMapper;
    }

    private static IDPAttributeMapper getIDPAttributeMapper(Map<String, List<String>> attributes) throws WSFederationException {
        IDPAttributeMapper attrMapper = null;
        List<String> attrMapperList = attributes.get("idpAttributeMapper");
        if (attrMapperList != null) {
            try {
                attrMapper = (IDPAttributeMapper)Class.forName(attrMapperList.get(0)).newInstance();
            }
            catch (ClassNotFoundException cfe) {
                throw new WSFederationException(cfe);
            }
            catch (InstantiationException ie) {
                throw new WSFederationException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new WSFederationException(iae);
            }
        }
        if (attrMapper == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("failedAttrMapper"));
        }
        return attrMapper;
    }
}

