/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.servlet;

import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.logging.LogUtil;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import com.sun.identity.wsfederation.servlet.WSFederationAction;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IPRPSignoutRequest
extends WSFederationAction {
    private static Debug debug = WSFederationUtils.debug;
    private String wreply;

    public IPRPSignoutRequest(HttpServletRequest request, HttpServletResponse response, String wreply) {
        super(request, response);
        this.wreply = wreply;
    }

    public void process() throws IOException, WSFederationException {
        Object session;
        String entityId;
        String realm;
        String classMethod;
        block20: {
            classMethod = "IPRPSignoutRequest.process: ";
            String metaAlias = WSFederationMetaUtils.getMetaAliasByUri(this.request.getRequestURI());
            if (metaAlias == null || metaAlias.trim().length() == 0) {
                debug.error(classMethod + "Unable to get meta alias from request");
                throw new WSFederationException(WSFederationUtils.bundle.getString("MetaAliasNotFound"));
            }
            realm = WSFederationMetaUtils.getRealmByMetaAlias(metaAlias);
            if (realm == null || realm.trim().length() == 0) {
                debug.error(classMethod + "Unable to get realm from request");
                throw new WSFederationException(WSFederationUtils.bundle.getString("nullRealm"));
            }
            entityId = WSFederationMetaManager.getEntityByMetaAlias(metaAlias);
            if (entityId == null || entityId.trim().length() == 0) {
                debug.error(classMethod + "Unable to get Entity ID from metaAlias" + metaAlias);
                throw new WSFederationException(WSFederationUtils.bundle.getString("nullEntityID"));
            }
            session = null;
            try {
                session = WSFederationUtils.sessionProvider.getSession(this.request);
            }
            catch (SessionException se) {
                if (!debug.messageEnabled()) break block20;
                debug.message(classMethod + "Session exception" + se.getLocalizedMessage());
            }
        }
        try {
            BaseConfigType config = WSFederationMetaManager.getBaseConfig(realm, entityId);
            String displayName = WSFederationMetaUtils.getAttribute(config, "displayName");
            if (displayName == null) {
                displayName = entityId;
            }
            this.request.setAttribute("com.sun.identity.wsfederation.logout.displayname", (Object)displayName);
            this.request.setAttribute("com.sun.identity.wsfederation.logout.wreply", (Object)this.wreply);
            this.request.setAttribute("famrealm", (Object)realm);
            this.request.setAttribute("wsfed-entityid", (Object)entityId);
            LinkedHashMap<String, String> providerList = new LinkedHashMap<String, String>();
            if (session != null) {
                String[] spList;
                String[] idpList = WSFederationUtils.sessionProvider.getProperty(session, "sun-fm-wsfed-idp");
                if (idpList != null && idpList.length > 0 && idpList[0] != null && idpList[0].length() > 0) {
                    FederationElement fed = WSFederationMetaManager.getEntityDescriptor(realm, idpList[0]);
                    String endpoint = WSFederationMetaManager.getTokenIssuerEndpoint(fed);
                    String url = endpoint + "?wa=" + "wsignout1.0";
                    config = WSFederationMetaManager.getBaseConfig(realm, idpList[0]);
                    displayName = WSFederationMetaUtils.getAttribute(config, "displayName");
                    if (displayName == null) {
                        displayName = idpList[0];
                    }
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "sending signout to " + url);
                    }
                    providerList.put(url, displayName);
                }
                if ((spList = WSFederationUtils.sessionProvider.getProperty(session, "sun-fm-wsfed-sp-list")) != null && spList.length > 0 && spList[0] != null && spList[0].length() > 0) {
                    for (int i = 0; i < spList.length; ++i) {
                        config = WSFederationMetaManager.getBaseConfig(realm, spList[i]);
                        displayName = WSFederationMetaUtils.getAttribute(config, "displayName");
                        if (displayName == null) {
                            displayName = spList[i];
                        }
                        FederationElement fed = WSFederationMetaManager.getEntityDescriptor(realm, spList[i]);
                        String endpoint = WSFederationMetaManager.getTokenIssuerEndpoint(fed);
                        String url = endpoint + "?wa=" + "wsignout1.0";
                        if (debug.messageEnabled()) {
                            debug.message(classMethod + "sending signout to " + url);
                        }
                        providerList.put(url, displayName);
                    }
                    String[] empty = new String[]{""};
                    WSFederationUtils.sessionProvider.setProperty(session, "sun-fm-wsfed-sp-list", empty);
                }
                if (debug.messageEnabled()) {
                    debug.message(classMethod + "destroying session " + session);
                }
                MultiProtocolUtils.invalidateSession(session, this.request, this.response, "wsfed");
            }
            this.request.setAttribute("com.sun.identity.wsfederation.logout.providerlist", providerList);
            this.request.getRequestDispatcher("/wsfederation/jsp/logout.jsp").forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException se) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "Servlet exception" + se.getLocalizedMessage());
            }
            throw new WSFederationException(se);
        }
        catch (SessionException se) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "Session exception" + se.getLocalizedMessage());
            }
            throw new WSFederationException((Throwable)((Object)se));
        }
        String[] data = new String[]{this.wreply};
        LogUtil.access(Level.INFO, "SLO_SUCCESSFUL", data, session);
    }
}

