/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.profile;

import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.LogUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.logging.LogUtil;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import com.sun.identity.wsfederation.profile.RequestedSecurityToken;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML11RequestedSecurityToken
implements RequestedSecurityToken {
    private static Debug debug = WSFederationUtils.debug;
    protected Assertion assertion = null;
    protected String xmlString = null;
    protected boolean signed = false;

    public SAML11RequestedSecurityToken(Node token) throws WSFederationException {
        List signs;
        int signsSize;
        String classMethod = "SAML11RequestedSecurityToken.SAML11RequestedSecurityToken(Node)";
        if (!token.getLocalName().equals("RequestedSecurityToken")) {
            debug.error("Got node " + token.getLocalName() + " (expecting " + "urn:oasis:names:tc:SAML:1.0:assertion" + ":" + "Assertion" + ")");
            throw new WSFederationException(WSFederationUtils.bundle.getString("invalidToken"));
        }
        Element ae = (Element)token.getFirstChild();
        if (!ae.getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion") || !ae.getLocalName().equals("Assertion")) {
            debug.error("Got node " + ae.getLocalName() + " (expecting " + "urn:oasis:names:tc:SAML:1.0:assertion" + ":" + "Assertion" + ")");
            throw new WSFederationException(WSFederationUtils.bundle.getString("invalidToken"));
        }
        try {
            this.assertion = new Assertion(ae);
        }
        catch (SAMLException se) {
            if (debug.messageEnabled()) {
                debug.message("Caught SAMLException, rethrowing", (Throwable)((Object)se));
            }
            throw new WSFederationException((Throwable)((Object)se));
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "found Assertion with issuer:" + this.assertion.getIssuer());
        }
        if ((signsSize = (signs = XMLUtils.getElementsByTagNameNS1((Element)ae, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature")).size()) == 1) {
            this.xmlString = XMLUtils.print((Node)ae);
            this.signed = true;
            if (debug.messageEnabled()) {
                debug.message(classMethod + "found signature");
            }
        } else if (signsSize != 0) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "included more than one Signature element.");
            }
            throw new WSFederationException(WSFederationUtils.bundle.getString("moreElement"));
        }
    }

    public SAML11RequestedSecurityToken(String realm, String spEntityId, String idpEntityId, int notBeforeSkew, int effectiveTime, String certAlias, String authMethod, Date authInstant, NameIdentifier ni, List attributes) throws WSFederationException {
        String classMethod = "SAML11RequestedSecurityToken.SAML11RequestedSecurityToken(String*)";
        try {
            Subject sub = new Subject(ni);
            HashSet<SubjectStatement> statements = new HashSet<SubjectStatement>();
            statements.add(new AuthenticationStatement(authMethod, authInstant, sub, null, null));
            if (attributes != null && !attributes.isEmpty()) {
                statements.add(new AttributeStatement(sub, attributes));
            }
            Date issueInstant = new Date();
            long skewPeriod = (long)notBeforeSkew * 1000L;
            Date notBefore = new Date(issueInstant.getTime() - skewPeriod);
            long period = (long)effectiveTime * 1000L;
            Date notAfter = new Date(issueInstant.getTime() + period);
            FederationElement idp = WSFederationMetaManager.getEntityDescriptor(realm, idpEntityId);
            FederationElement sp = WSFederationMetaManager.getEntityDescriptor(realm, spEntityId);
            String issuer = WSFederationMetaManager.getTokenIssuerName(idp);
            ArrayList<String> targets = new ArrayList<String>();
            targets.add(WSFederationMetaManager.getTokenIssuerName(sp));
            AudienceRestrictionCondition arc = new AudienceRestrictionCondition(targets);
            Conditions cond = new Conditions(notBefore, notAfter, null, arc);
            this.assertion = new Assertion(null, issuer, issueInstant, cond, statements);
            String aIDString = this.assertion.getAssertionID();
            if (certAlias != null) {
                this.assertion.signXML(certAlias);
            }
            if (LogUtils.isAccessLoggable(Level.FINER)) {
                String[] data = new String[]{WSFederationUtils.bundle.getString("assertionCreated"), this.assertion.toString(true, true)};
                LogUtils.access(Level.FINER, "ASSERTION_CREATED", data);
            } else {
                String[] data = new String[]{WSFederationUtils.bundle.getString("assertionCreated"), aIDString};
                LogUtils.access(Level.INFO, "ASSERTION_CREATED", data);
            }
        }
        catch (SAMLException se) {
            throw new WSFederationException((Throwable)((Object)se));
        }
    }

    @Override
    public String getTokenId() {
        return this.assertion.getAssertionID();
    }

    @Override
    public String getIssuer() {
        return this.assertion.getIssuer();
    }

    @Override
    public List getAttributes() {
        AttributeStatement attributeStatement = null;
        for (Statement statement : this.assertion.getStatement()) {
            if (statement.getStatementType() != 3) continue;
            attributeStatement = (AttributeStatement)statement;
            break;
        }
        if (attributeStatement == null) {
            return null;
        }
        return attributeStatement.getAttribute();
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<wst:RequestedSecurityToken>").append(this.assertion.toString(true, true)).append("</wst:RequestedSecurityToken>");
        return buffer.toString();
    }

    @Override
    public Map<String, Object> verifyToken(String realm, String hostEntityId, int timeskew) throws WSFederationException {
        long maxSessionTime;
        Date sessionNotOnOrAfter;
        boolean wantAssertionSigned;
        String classMethod = "SAML11RequestedSecurityToken.verifyToken";
        String issuer = this.assertion.getIssuer();
        String remoteEntityId = WSFederationMetaManager.getEntityByTokenIssuerName(realm, issuer);
        if (!WSFederationMetaManager.isTrustedProvider(realm, hostEntityId, remoteEntityId)) {
            String[] data = new String[]{LogUtil.isErrorLoggable(Level.FINER) ? this.toString() : this.getTokenId(), realm, hostEntityId};
            LogUtil.error(Level.INFO, "UNTRUSTED_ISSUER", data, null);
            throw new WSFederationException(WSFederationUtils.bundle.getString("untrustedIssuer"));
        }
        SPSSOConfigElement spConfig = WSFederationMetaManager.getSPSSOConfig(realm, hostEntityId);
        if (spConfig == null) {
            debug.error(classMethod + "cannot find configuration for SP " + hostEntityId);
            throw new WSFederationException("unableToFindSPConfiguration");
        }
        String strWantAssertionSigned = WSFederationMetaUtils.getAttribute(spConfig, "wantAssertionSigned");
        boolean bl = wantAssertionSigned = strWantAssertionSigned != null ? Boolean.parseBoolean(strWantAssertionSigned) : true;
        if (wantAssertionSigned && !WSFederationUtils.isSignatureValid(this.assertion, realm, remoteEntityId)) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("invalidSignature"));
        }
        Subject assertionSubject = null;
        for (Statement statement : this.assertion.getStatement()) {
            if (statement.getStatementType() != 1) continue;
            assertionSubject = ((SubjectStatement)statement).getSubject();
            break;
        }
        if (assertionSubject == null) {
            String[] data = new String[]{LogUtil.isErrorLoggable(Level.FINER) ? this.toString() : this.getTokenId()};
            LogUtil.error(Level.INFO, "MISSING_SUBJECT", data, null);
            throw new WSFederationException(WSFederationUtils.bundle.getString("missingSubject"));
        }
        if (!WSFederationUtils.isTimeValid(this.assertion, timeskew)) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("timeInvalid"));
        }
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        assertions.add(this.assertion);
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        attrMap.put("Subject", assertionSubject);
        attrMap.put("assertion", this.assertion);
        attrMap.put("assertions", assertions);
        int authLevel = 0;
        if (authLevel >= 0) {
            attrMap.put("AuthLevel", new Integer(authLevel));
        }
        if ((sessionNotOnOrAfter = this.assertion.getConditions().getNotOnorAfter()) != null && (maxSessionTime = (sessionNotOnOrAfter.getTime() - System.currentTimeMillis()) / 60000L) > 0L) {
            attrMap.put("maxSessionTime", new Long(maxSessionTime));
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + " Attribute Map : " + attrMap);
        }
        return attrMap;
    }
}

