/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.profile;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.TokenIssuerEndpointElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

public class IDPSSOUtil {
    private static Debug debug = WSFederationUtils.debug;

    public static String getAuthenticationServiceURL(String realm, String hostEntityId, HttpServletRequest request) {
        String classMethod = "IDPSSOUtil.getAuthenticationServiceURL: ";
        String authUrl = SystemConfigurationUtil.getProperty("com.sun.identity.federation.services.idpLoginURL");
        if (authUrl == null || authUrl.trim().length() == 0) {
            block6: {
                try {
                    IDPSSOConfigElement config = WSFederationMetaManager.getIDPSSOConfig(realm, hostEntityId);
                    authUrl = WSFederationMetaUtils.getAttribute(config, "AuthUrl");
                }
                catch (WSFederationMetaException sme) {
                    if (!debug.messageEnabled()) break block6;
                    debug.message(classMethod + "get IDPSSOConfig failed:", (Throwable)((Object)sme));
                }
            }
            if (authUrl == null) {
                String uri;
                String deploymentURI = uri = request.getRequestURI();
                int firstSlashIndex = uri.indexOf("/");
                int secondSlashIndex = uri.indexOf("/", firstSlashIndex + 1);
                if (secondSlashIndex != -1) {
                    deploymentURI = uri.substring(0, secondSlashIndex);
                }
                StringBuffer sb = new StringBuffer(100);
                sb.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(deploymentURI).append("/UI/Login?realm=").append(realm);
                authUrl = sb.toString();
            }
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "auth url=:" + authUrl);
        }
        return authUrl;
    }

    public static String getACSurl(String entityId, String realm, String wreply) throws WSFederationMetaException {
        FederationElement sp = WSFederationMetaManager.getEntityDescriptor(realm, entityId);
        if (wreply == null) {
            return WSFederationMetaManager.getTokenIssuerEndpoint(sp);
        }
        for (Object o : sp.getAny()) {
            if (!(o instanceof TokenIssuerEndpointElement)) continue;
            try {
                URL replyUrl = new URL(wreply);
                URL thisUrl = new URL(((TokenIssuerEndpointElement)o).getAddress().getValue());
                if (!replyUrl.equals(thisUrl)) continue;
                return wreply;
            }
            catch (MalformedURLException mue) {
                return null;
            }
        }
        return null;
    }
}

