/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.plugins;

import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.plugins.DefaultAttributeMapper;
import com.sun.identity.wsfederation.plugins.SPAttributeMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class DefaultSPAttributeMapper
extends DefaultAttributeMapper
implements SPAttributeMapper {
    public DefaultSPAttributeMapper() {
        debug.message("DefaultSPAttributeMapper.constructor");
        this.role = "SP";
    }

    public Map getAttributes(List attributes, String userID, String hostEntityID, String remoteEntityID, String realm) throws WSFederationException {
        if (attributes == null || attributes.size() == 0) {
            throw new WSFederationException(bundle.getString("nullAttributes"));
        }
        if (hostEntityID == null) {
            throw new WSFederationException(bundle.getString("nullHostEntityID"));
        }
        if (realm == null) {
            throw new WSFederationException(bundle.getString("nullRealm"));
        }
        HashMap map = new HashMap();
        Map configMap = this.getConfigAttributeMap(realm, hostEntityID);
        for (Attribute attribute : attributes) {
            Set existingValues;
            HashSet<String> values = new HashSet<String>();
            try {
                List attrValues = attribute.getAttributeValue();
                for (Element attrValue : attrValues) {
                    values.add(XMLUtils.getElementValue((Element)attrValue));
                }
            }
            catch (SAMLException se) {
                throw new WSFederationException((Throwable)((Object)se));
            }
            String attributeName = attribute.getAttributeName();
            String localAttribute = (String)configMap.get(attributeName);
            if (localAttribute == null || localAttribute.length() == 0) {
                localAttribute = attributeName;
            }
            if ((existingValues = (Set)map.get(localAttribute)) != null) {
                existingValues.addAll(values);
                continue;
            }
            map.put(localAttribute, values);
        }
        return map;
    }
}

