/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.plugins;

import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.plugins.DefaultAccountMapper;
import com.sun.identity.wsfederation.plugins.SPAccountMapper;
import com.sun.identity.wsfederation.profile.RequestSecurityTokenResponse;
import com.sun.identity.wsfederation.profile.SAML11RequestedSecurityToken;
import java.security.PrivateKey;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultLibrarySPAccountMapper
extends DefaultAccountMapper
implements SPAccountMapper {
    private PrivateKey decryptionKey = null;

    public DefaultLibrarySPAccountMapper() {
        debug.message("DefaultLibrarySPAccountMapper.constructor: ");
        this.role = "SPRole";
    }

    public String getIdentity(RequestSecurityTokenResponse rstr, String hostEntityID, String realm) throws WSFederationException {
        if (rstr == null) {
            throw new WSFederationException(bundle.getString("nullRstr"));
        }
        if (hostEntityID == null) {
            throw new WSFederationException(bundle.getString("nullHostEntityID"));
        }
        if (realm == null) {
            throw new WSFederationException(bundle.getString("nullRealm"));
        }
        SAML11RequestedSecurityToken rst = (SAML11RequestedSecurityToken)rstr.getRequestedSecurityToken();
        Subject subject = null;
        Assertion assertion = rst.getAssertion();
        for (Statement statement : assertion.getStatement()) {
            if (statement.getStatementType() != 1) continue;
            subject = ((SubjectStatement)statement).getSubject();
            break;
        }
        NameIdentifier nameID = subject.getNameIdentifier();
        String userID = null;
        String format = nameID.getFormat();
        String remoteEntityID = WSFederationMetaManager.getEntityByTokenIssuerName(realm, assertion.getIssuer());
        if (debug.messageEnabled()) {
            debug.message("DefaultLibrarySPAccountMapper.getIdentity(Assertion): realm = " + realm + " hostEntityID = " + hostEntityID);
        }
        try {
            userID = dsProvider.getUserID(realm, this.getSearchParameters(nameID, hostEntityID, remoteEntityID));
        }
        catch (DataStoreProviderException dse) {
            debug.error("DefaultLibrarySPAccountMapper.getIdentity(Assertion): DataStoreProviderException", (Throwable)((Object)dse));
            throw new WSFederationException((Throwable)((Object)dse));
        }
        return userID;
    }

    protected boolean isDynamicalOrIgnoredProfile(String realm) {
        return true;
    }

    private Set getAttribute(AttributeStatement statement, String attributeName, String realm, String hostEntityID) {
        if (debug.messageEnabled()) {
            debug.message("DefaultLibrarySPAccountMapper.getAttribute: attributeName =" + attributeName);
        }
        List list = statement.getAttribute();
        for (Attribute attribute : list) {
            if (!attributeName.equalsIgnoreCase(attribute.getAttributeName())) continue;
            List values = null;
            try {
                values = attribute.getAttributeValue();
            }
            catch (SAMLException se) {
                // empty catch block
            }
            if (values == null || values.size() == 0) {
                return null;
            }
            HashSet set = new HashSet();
            set.addAll(values);
            return set;
        }
        return null;
    }
}

