/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.plugins;

import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class DefaultAttributeMapper {
    protected static Debug debug = WSFederationUtils.debug;
    protected static ResourceBundle bundle = WSFederationUtils.bundle;
    protected static DataStoreProvider dsProvider = WSFederationUtils.dsProvider;
    protected static final String IDP = "IDP";
    protected static final String SP = "SP";
    protected String role = null;

    public Map getConfigAttributeMap(String realm, String hostEntityID) throws WSFederationException {
        if (realm == null) {
            throw new WSFederationException(bundle.getString("nullRealm"));
        }
        if (hostEntityID == null) {
            throw new WSFederationException(bundle.getString("nullHostEntityID"));
        }
        try {
            BaseConfigType config = null;
            config = this.role.equals(SP) ? WSFederationMetaManager.getSPSSOConfig(realm, hostEntityID) : WSFederationMetaManager.getIDPSSOConfig(realm, hostEntityID);
            if (config == null) {
                if (debug.warningEnabled()) {
                    debug.warning("DefaultAttributeMapper.getConfigAttributeMap: configuration is not defined.");
                }
                return Collections.EMPTY_MAP;
            }
            Map<String, List<String>> attribConfig = WSFederationMetaUtils.getAttributes(config);
            List<String> mappedAttributes = attribConfig.get("attributeMap");
            if (mappedAttributes == null || mappedAttributes.size() == 0) {
                if (debug.messageEnabled()) {
                    debug.message("DefaultAttributeMapper.getConfigAttributeMap:Attribute map is not defined for entity: " + hostEntityID);
                }
                return Collections.EMPTY_MAP;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (String entry : mappedAttributes) {
                if (entry.indexOf("=") == -1) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("DefaultAttributeMapper.getConfigAttributeMap: Invalid entry." + entry);
                    continue;
                }
                StringTokenizer st = new StringTokenizer(entry, "=");
                map.put(st.nextToken(), st.nextToken());
            }
            return map;
        }
        catch (WSFederationMetaException sme) {
            debug.error("DefaultAttributeMapper.getConfigAttributeMap: Meta Exception", (Throwable)((Object)sme));
            throw new WSFederationException((Throwable)((Object)sme));
        }
    }
}

