/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.meta;

import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.OfflineResolver;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.AttributeType;
import com.sun.identity.wsfederation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.wsfederation.jaxb.entityconfig.FederationConfigElement;
import com.sun.identity.wsfederation.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.wsfederation.jaxb.entityconfig.ObjectFactory;
import com.sun.identity.wsfederation.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.TokenSigningKeyInfoElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import com.sun.org.apache.xml.internal.security.Init;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.keys.storage.implementations.KeyStoreResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignature;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WSFederationMetaSecurityUtils {
    private static Debug debug = WSFederationMetaUtils.debug;
    private static KeyProvider keyProvider = null;
    private static KeyStore keyStore = null;
    private static boolean checkCert = true;
    private static boolean keyProviderInitialized = false;
    public static final String NS_META = "http://schemas.xmlsoap.org/ws/2006/12/federation";
    public static final String NS_XMLSIG = "http://www.w3.org/2000/09/xmldsig#";
    public static final String NS_XMLENC = "http://www.w3.org/2001/04/xmlenc#";
    public static final String PREFIX_XMLSIG = "ds";
    public static final String PREFIX_XMLENC = "xenc";
    public static final String TAG_KEY_INFO = "KeyInfo";
    public static final String TAG_KEY_DESCRIPTOR = "KeyDescriptor";
    public static final String TAG_SP_SSO_DESCRIPTOR = "SPSSODescriptor";
    public static final String TAG_IDP_SSO_DESCRIPTOR = "IDPSSODescriptor";
    public static final String ATTR_USE = "use";
    public static final String ATTR_ID = "ID";

    private WSFederationMetaSecurityUtils() {
    }

    private static void initializeKeyStore() {
        if (keyProviderInitialized) {
            return;
        }
        Init.init();
        keyProvider = KeyUtil.getKeyProviderInstance();
        if (keyProvider instanceof JKSKeyProvider) {
            keyStore = ((JKSKeyProvider)keyProvider).getKeyStore();
        }
        try {
            String valCert = SystemPropertiesManager.get((String)"com.sun.identity.saml.checkcert", (String)"on");
            checkCert = valCert.trim().equalsIgnoreCase("on");
        }
        catch (Exception e) {
            checkCert = true;
        }
        keyProviderInitialized = true;
    }

    public static Document sign(FederationElement descriptor, SPSSOConfigElement spconfig, IDPSSOConfigElement idpconfig) throws JAXBException, WSFederationMetaException {
        return null;
    }

    public static void verifySignature(Document doc) throws WSFederationMetaException {
        String classMethod = "WSFederationMetaSecurityUtils.verifySignature: ";
        NodeList sigElements = null;
        try {
            Element nscontext = XMLUtils.createDSctx((Document)doc, (String)PREFIX_XMLSIG, (String)NS_XMLSIG);
            sigElements = XPathAPI.selectNodeList(doc, "//ds:Signature", nscontext);
        }
        catch (Exception ex) {
            debug.error(classMethod, (Throwable)ex);
            throw new WSFederationMetaException(ex);
        }
        int numSigs = sigElements.getLength();
        if (debug.messageEnabled()) {
            debug.message(classMethod + "# of signatures = " + numSigs);
        }
        if (numSigs == 0) {
            return;
        }
        WSFederationMetaSecurityUtils.initializeKeyStore();
        for (int i = 0; i < numSigs; ++i) {
            Element sigElement = (Element)sigElements.item(i);
            String sigParentName = sigElement.getParentNode().getLocalName();
            Object[] objs = new Object[]{sigParentName};
            if (debug.messageEnabled()) {
                debug.message(classMethod + "verifying signature under " + sigParentName);
            }
            try {
                XMLSignature signature = new XMLSignature(sigElement, "");
                signature.addResourceResolver(new OfflineResolver());
                KeyInfo ki = signature.getKeyInfo();
                X509Certificate x509cert = null;
                if (ki != null && ki.containsX509Data()) {
                    if (keyStore != null) {
                        StorageResolver sr = new StorageResolver(new KeyStoreResolver(keyStore));
                        ki.addStorageResolver(sr);
                    }
                    x509cert = ki.getX509Certificate();
                }
                if (x509cert == null) {
                    Element kd;
                    String use;
                    String xpath;
                    Node node;
                    if (debug.messageEnabled()) {
                        debug.message(classMethod + "" + "try to find cert in KeyDescriptor");
                    }
                    if ((node = XPathAPI.selectSingleNode(sigElement, xpath = "following-sibling::*[local-name()=\"KeyDescriptor\" and namespace-uri()=\"http://schemas.xmlsoap.org/ws/2006/12/federation\"]")) != null && (use = (kd = (Element)node).getAttributeNS(null, ATTR_USE)).equals("signing")) {
                        NodeList nl = kd.getChildNodes();
                        for (int j = 0; j < nl.getLength(); ++j) {
                            Node child = nl.item(j);
                            if (child.getNodeType() != 1) continue;
                            String localName = child.getLocalName();
                            String ns = child.getNamespaceURI();
                            if (!TAG_KEY_INFO.equals(localName) || !NS_XMLSIG.equals(ns) || !(ki = new KeyInfo((Element)child, "")).containsX509Data()) break;
                            if (keyStore != null) {
                                KeyStoreResolver ksr = new KeyStoreResolver(keyStore);
                                StorageResolver sr = new StorageResolver(ksr);
                                ki.addStorageResolver(sr);
                            }
                            x509cert = ki.getX509Certificate();
                            break;
                        }
                    }
                }
                if (x509cert == null) {
                    throw new WSFederationMetaException("verify_no_cert", objs);
                }
                if (checkCert && keyProvider.getCertificateAlias(x509cert) == null) {
                    throw new WSFederationMetaException("untrusted_cert", objs);
                }
                PublicKey pk = x509cert.getPublicKey();
                if (signature.checkSignatureValue(pk)) continue;
                throw new WSFederationMetaException("verify_fail", objs);
            }
            catch (WSFederationMetaException sme) {
                throw sme;
            }
            catch (Exception ex) {
                debug.error(classMethod, (Throwable)ex);
                throw new WSFederationMetaException(Locale.getString((ResourceBundle)WSFederationUtils.bundle, (String)"verify_fail", (Object[])objs) + "\n" + ex.getMessage());
            }
        }
    }

    public static String formatBase64BinaryElement(String xmlstr) {
        int from = 0;
        int index = xmlstr.indexOf("<ds:X509Certificate>");
        int xmlLength = xmlstr.length();
        StringBuffer sb = new StringBuffer(xmlLength + 100);
        while (index != -1) {
            int i;
            sb.append(xmlstr.substring(from, index));
            int indexEnd = xmlstr.indexOf("</ds:X509Certificate>", index);
            String encoded = xmlstr.substring(index + 20, indexEnd);
            int encodedLength = encoded.length();
            sb.append("<ds:X509Certificate>\n");
            for (i = 0; i < encodedLength - 76; i += 76) {
                sb.append(encoded.substring(i, i + 76)).append("\n");
            }
            int nlIndex = xmlstr.lastIndexOf(10, index);
            String indention = xmlstr.substring(nlIndex + 1, index);
            sb.append(encoded.substring(i, encodedLength)).append("\n").append(indention).append("</ds:X509Certificate>");
            from = indexEnd + 21;
            index = xmlstr.indexOf("<ds:X509Certificate>", from);
        }
        sb.append(xmlstr.substring(from, xmlLength));
        return sb.toString();
    }

    public static String buildX509Certificate(String certAlias) throws WSFederationMetaException {
        block4: {
            String classMethod = "WSFederationMetaSecurityUtils.buildX509Certificate: ";
            if (certAlias == null || certAlias.trim().length() == 0) {
                return null;
            }
            X509Certificate cert = KeyUtil.getKeyProviderInstance().getX509Certificate(certAlias);
            if (cert != null) {
                try {
                    return Base64.encode((byte[])cert.getEncoded(), (int)76);
                }
                catch (Exception ex) {
                    if (!debug.messageEnabled()) break block4;
                    debug.message(classMethod, (Throwable)ex);
                }
            }
        }
        Object[] objs = new Object[]{certAlias};
        throw new WSFederationMetaException("invalid_cert_alias", objs);
    }

    public static void updateProviderKeyInfo(String realm, String entityID, String certAlias, boolean isIDP) throws WSFederationMetaException {
        FederationConfigElement config = WSFederationMetaManager.getEntityConfig(realm, entityID);
        if (!config.isHosted()) {
            Object[] args = new String[]{entityID, realm};
            throw new WSFederationMetaException("entityNotHosted", args);
        }
        FederationElement desp = WSFederationMetaManager.getEntityDescriptor(realm, entityID);
        if (isIDP) {
            IDPSSOConfigElement idpConfig = WSFederationMetaManager.getIDPSSOConfig(realm, entityID);
            if (idpConfig == null || desp == null) {
                Object[] args = new String[]{entityID, realm};
                throw new WSFederationMetaException("entityNotIDP", args);
            }
            if (certAlias == null || certAlias.length() == 0) {
                WSFederationMetaSecurityUtils.removeKeyDescriptor(desp);
                WSFederationMetaSecurityUtils.setExtendedAttributeValue(idpConfig, "signingCertAlias", null);
            } else {
                TokenSigningKeyInfoElement kde = WSFederationMetaSecurityUtils.getKeyDescriptor(certAlias);
                WSFederationMetaSecurityUtils.updateKeyDescriptor(desp, kde);
                HashSet<String> value = new HashSet<String>();
                value.add(certAlias);
                WSFederationMetaSecurityUtils.setExtendedAttributeValue(idpConfig, "signingCertAlias", value);
            }
        } else {
            SPSSOConfigElement spConfig = WSFederationMetaManager.getSPSSOConfig(realm, entityID);
            if (spConfig == null || desp == null) {
                Object[] args = new String[]{entityID, realm};
                throw new WSFederationMetaException("entityNotSP", args);
            }
            if (certAlias == null || certAlias.length() == 0) {
                WSFederationMetaSecurityUtils.removeKeyDescriptor(desp);
                WSFederationMetaSecurityUtils.setExtendedAttributeValue(spConfig, "signingCertAlias", null);
            } else {
                TokenSigningKeyInfoElement kde = WSFederationMetaSecurityUtils.getKeyDescriptor(certAlias);
                WSFederationMetaSecurityUtils.updateKeyDescriptor(desp, kde);
                HashSet<String> value = new HashSet<String>();
                value.add(certAlias);
                WSFederationMetaSecurityUtils.setExtendedAttributeValue(spConfig, "signingCertAlias", value);
            }
        }
        WSFederationMetaManager.setFederation(realm, desp);
        WSFederationMetaManager.setEntityConfig(realm, config);
    }

    private static void updateKeyDescriptor(FederationElement desp, TokenSigningKeyInfoElement newKey) {
        List objList = desp.getAny();
        Iterator iter = objList.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof TokenSigningKeyInfoElement)) continue;
            iter.remove();
        }
        desp.getAny().add(0, newKey);
    }

    private static void removeKeyDescriptor(FederationElement desp) {
        List objList = desp.getAny();
        Iterator iter = objList.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof TokenSigningKeyInfoElement)) continue;
            iter.remove();
        }
    }

    private static void setExtendedAttributeValue(BaseConfigType config, String attrName, Set attrVal) throws WSFederationMetaException {
        try {
            List attributes = config.getAttribute();
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                AttributeType avp = (AttributeType)iter.next();
                if (!avp.getName().trim().equalsIgnoreCase(attrName)) continue;
                iter.remove();
            }
            if (attrVal != null) {
                ObjectFactory factory = new ObjectFactory();
                AttributeType atype = factory.createAttributeType();
                atype.setName(attrName);
                atype.getValue().addAll(attrVal);
                config.getAttribute().add(atype);
            }
        }
        catch (JAXBException e) {
            throw new WSFederationMetaException(e);
        }
    }

    private static TokenSigningKeyInfoElement getKeyDescriptor(String certAlias) throws WSFederationMetaException {
        try {
            String certString = WSFederationMetaSecurityUtils.buildX509Certificate(certAlias);
            StringBuffer sb = new StringBuffer(4000);
            sb.append("<TokenSigningKeyInfo xmlns=\"").append(NS_META).append("\">\n");
            sb.append("<SecurityTokenReference xmlns=\"").append("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\">\n").append("<X509Data xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n").append("<X509Certificate>\n").append(certString).append("</X509Certificate>\n").append("</X509Data>\n").append("</SecurityTokenReference>\n");
            sb.append("</TokenSigningKeyInfo>\n");
            return (TokenSigningKeyInfoElement)WSFederationMetaUtils.convertStringToJAXB(sb.toString());
        }
        catch (JAXBException e) {
            throw new WSFederationMetaException(e);
        }
    }
}

