/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.meta;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.FederationConfigElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import java.util.Hashtable;

class WSFederationMetaCache {
    private static Debug debug = WSFederationUtils.debug;
    private static Hashtable federationCache = new Hashtable();
    private static Hashtable configCache = new Hashtable();

    private WSFederationMetaCache() {
    }

    static FederationElement getFederation(String realm, String federationId) {
        String cacheKey = WSFederationMetaCache.buildCacheKey(realm, federationId);
        FederationElement federation = (FederationElement)federationCache.get(cacheKey);
        if (debug.messageEnabled()) {
            debug.message("WSFederationMetaCache.getEntityDescriptor: cacheKey = " + cacheKey + ", found = " + (federation != null));
        }
        return federation;
    }

    static void putFederation(String realm, String federationId, FederationElement federation) {
        String cacheKey = WSFederationMetaCache.buildCacheKey(realm, federationId);
        if (federation != null) {
            if (debug.messageEnabled()) {
                debug.message("WSFederationMetaCache.putFederation: cacheKey = " + cacheKey);
            }
            federationCache.put(cacheKey, federation);
        } else {
            if (debug.messageEnabled()) {
                debug.message("WSFederationMetaCache.putFederation: delete cacheEey = " + cacheKey);
            }
            federationCache.remove(cacheKey);
            configCache.remove(cacheKey);
        }
    }

    static FederationConfigElement getEntityConfig(String realm, String entityId) {
        String cacheKey = WSFederationMetaCache.buildCacheKey(realm, entityId);
        FederationConfigElement config = (FederationConfigElement)configCache.get(cacheKey);
        if (debug.messageEnabled()) {
            debug.message("SAML2MetaCache.getEntityConfig: cacheKey = " + cacheKey + ", found = " + (config != null));
        }
        return config;
    }

    static void putEntityConfig(String realm, String entityId, FederationConfigElement config) {
        String cacheKey = WSFederationMetaCache.buildCacheKey(realm, entityId);
        if (config != null) {
            if (debug.messageEnabled()) {
                debug.message("SAML2MetaCache.putEntityConfig: cacheKey = " + cacheKey);
            }
            configCache.put(cacheKey, config);
        } else {
            if (debug.messageEnabled()) {
                debug.message("SAML2MetaCache.putEntityConfig: delete cacheKey = " + cacheKey);
            }
            configCache.remove(cacheKey);
        }
    }

    static void clear() {
        federationCache.clear();
        configCache.clear();
    }

    private static String buildCacheKey(String realm, String entityId) {
        return realm + "//" + entityId;
    }
}

