/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.meta;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.jaxb.entityconfig.AttributeType;
import com.sun.identity.wsfederation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.wsfederation.jaxb.entityconfig.FederationConfigElement;
import com.sun.identity.wsfederation.jaxb.entityconfig.ObjectFactory;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;

public class WSFederationCOTUtils {
    private static Debug debug = WSFederationMetaUtils.debug;

    private WSFederationCOTUtils() {
    }

    public static void updateEntityConfig(String realm, String name, String entityId) throws WSFederationMetaException, JAXBException {
        String classMethod = "WSFederationCOTUtils.updateEntityConfig: ";
        ObjectFactory objFactory = new ObjectFactory();
        FederationElement edes = WSFederationMetaManager.getEntityDescriptor(realm, entityId);
        if (edes == null) {
            debug.error(classMethod + "No such entity: " + entityId);
            Object[] data = new String[]{realm, entityId};
            throw new WSFederationMetaException("entityid_invalid", data);
        }
        FederationConfigElement eConfig = WSFederationMetaManager.getEntityConfig(realm, entityId);
        if (eConfig == null) {
            BaseConfigType bctype = null;
            AttributeType atype = objFactory.createAttributeType();
            atype.setName("cotlist");
            atype.getValue().add(name);
            FederationConfigElement ele = objFactory.createFederationConfigElement();
            ele.setFederationID(entityId);
            ele.setHosted(false);
            List ll = ele.getIDPSSOConfigOrSPSSOConfig();
            if (WSFederationMetaManager.getTokenSigningCertificate(edes) != null) {
                bctype = objFactory.createIDPSSOConfigElement();
                bctype.getAttribute().add(atype);
                ll.add(bctype);
            } else {
                bctype = objFactory.createSPSSOConfigElement();
                bctype.getAttribute().add(atype);
                ll.add(bctype);
            }
            WSFederationMetaManager.setEntityConfig(realm, ele);
        } else {
            List elist = eConfig.getIDPSSOConfigOrSPSSOConfig();
            for (BaseConfigType bConfig : elist) {
                List list = bConfig.getAttribute();
                boolean foundCOT = false;
                for (AttributeType avp : list) {
                    if (!avp.getName().trim().equalsIgnoreCase("cotlist")) continue;
                    foundCOT = true;
                    List avpl = avp.getValue();
                    if (!avpl.isEmpty() && WSFederationCOTUtils.containsValue(avpl, name)) continue;
                    avpl.add(name);
                    WSFederationMetaManager.setEntityConfig(realm, eConfig);
                    break;
                }
                if (foundCOT) continue;
                AttributeType atype = objFactory.createAttributeType();
                atype.setName("cotlist");
                atype.getValue().add(name);
                list.add(atype);
                WSFederationMetaManager.setEntityConfig(realm, eConfig);
            }
        }
    }

    private static boolean containsValue(List list, String name) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).trim().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static void removeFromEntityConfig(String realm, String name, String entityId) throws WSFederationMetaException, JAXBException {
        String classMethod = "WSFederationCOTUtils.removeFromEntityConfig: ";
        FederationElement edes = WSFederationMetaManager.getEntityDescriptor(realm, entityId);
        if (edes == null) {
            debug.error(classMethod + "No such entity: " + entityId);
            Object[] data = new String[]{realm, entityId};
            throw new WSFederationMetaException("entityid_invalid", data);
        }
        FederationConfigElement eConfig = WSFederationMetaManager.getEntityConfig(realm, entityId);
        if (eConfig != null) {
            List elist = eConfig.getIDPSSOConfigOrSPSSOConfig();
            block0: for (BaseConfigType bConfig : elist) {
                List list = bConfig.getAttribute();
                for (AttributeType avp : list) {
                    List avpl;
                    if (!avp.getName().trim().equalsIgnoreCase("cotlist") || (avpl = avp.getValue()) == null || avpl.isEmpty() || !WSFederationCOTUtils.containsValue(avpl, name)) continue;
                    avpl.remove(name);
                    WSFederationMetaManager.setEntityConfig(realm, eConfig);
                    continue block0;
                }
            }
        }
    }
}

