/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.logging;

import com.sun.identity.plugin.log.LogException;
import com.sun.identity.plugin.log.LogManager;
import com.sun.identity.plugin.log.Logger;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import java.util.logging.Level;

public abstract class LogUtil {
    private static Debug debug = WSFederationUtils.debug;
    public static String INVALID_SIGNATURE_ASSERTION = "INVALID_SIGNATURE_ASSERTION";
    public static final String MISSING_CONDITIONS_NOT_ON_OR_AFTER = "MISSING_CONDITIONS_NOT_ON_OR_AFTER";
    public static final String MISSING_CONDITIONS_NOT_BEFORE = "MISSING_CONDITIONS_NOT_BEFORE";
    public static final String ASSERTION_NOT_YET_VALID = "ASSERTION_NOT_YET_VALID";
    public static final String ASSERTION_EXPIRED = "ASSERTION_EXPIRED";
    public static final String MISSING_WRESULT = "MISSING_WRESULT";
    public static final String MISSING_WCTX = "MISSING_WCTX";
    public static final String INVALID_WRESULT = "INVALID_WRESULT";
    public static final String CANT_FIND_SP_ACCOUNT_MAPPER = "CANT_FIND_SP_ACCOUNT_MAPPER";
    public static final String CANT_CREATE_SP_ACCOUNT_MAPPER = "CANT_CREATE_SP_ACCOUNT_MAPPER";
    public static final String CANT_CREATE_SESSION = "CANT_CREATE_SESSION";
    public static final String SSO_SUCCESSFUL = "SSO_SUCCESSFUL";
    public static final String UNTRUSTED_ISSUER = "UNTRUSTED_ISSUER";
    public static final String MISSING_SUBJECT = "MISSING_SUBJECT";
    public static final String GOT_FEDERATION = "GOT_FEDERATION";
    public static final String GOT_INVALID_ENTITY_DESCRIPTOR = "GOT_INVALID_ENTITY_DESCRIPTOR";
    public static final String CONFIG_ERROR_GET_ENTITY_DESCRIPTOR = "CONFIG_ERROR_GET_ENTITY_DESCRIPTOR";
    public static final String SET_ENTITY_DESCRIPTOR = "SET_ENTITY_DESCRIPTOR";
    public static final String CONFIG_ERROR_SET_ENTITY_DESCRIPTOR = "CONFIG_ERROR_SET_ENTITY_DESCRIPTOR";
    public static final String SET_INVALID_ENTITY_DESCRIPTOR = "SET_INVALID_ENTITY_DESCRIPTOR";
    public static final String ENTITY_DESCRIPTOR_CREATED = "ENTITY_DESCRIPTOR_CREATED";
    public static final String CONFIG_ERROR_CREATE_ENTITY_DESCRIPTOR = "CONFIG_ERROR_CREATE_ENTITY_DESCRIPTOR";
    public static final String CREATE_INVALID_ENTITY_DESCRIPTOR = "CREATE_INVALID_ENTITY_DESCRIPTOR";
    public static final String ENTITY_DESCRIPTOR_DELETED = "ENTITY_DESCRIPTOR_DELETED";
    public static final String CONFIG_ERROR_DELETE_ENTITY_DESCRIPTOR = "CONFIG_ERROR_DELETE_ENTITY_DESCRIPTOR";
    public static final String GOT_ENTITY_CONFIG = "GOT_ENTITY_CONFIG";
    public static final String GOT_INVALID_ENTITY_CONFIG = "GOT_INVALID_ENTITY_CONFIG";
    public static final String CONFIG_ERROR_GET_ENTITY_CONFIG = "CONFIG_ERROR_GET_ENTITY_CONFIG";
    public static final String NO_ENTITY_ID_SET_ENTITY_CONFIG = "NO_ENTITY_ID_SET_ENTITY_CONFIG";
    public static final String SET_ENTITY_CONFIG = "SET_ENTITY_CONFIG";
    public static final String CONFIG_ERROR_SET_ENTITY_CONFIG = "CONFIG_ERROR_SET_ENTITY_CONFIG";
    public static final String SET_INVALID_ENTITY_CONFIG = "SET_INVALID_ENTITY_CONFIG";
    public static final String NO_ENTITY_ID_CREATE_ENTITY_CONFIG = "NO_ENTITY_ID_CREATE_ENTITY_CONFIG";
    public static final String NO_ENTITY_DESCRIPTOR_CREATE_ENTITY_CONFIG = "NO_ENTITY_DESCRIPTOR_CREATE_ENTITY_CONFIG";
    public static final String ENTITY_CONFIG_EXISTS = "ENTITY_CONFIG_EXISTS";
    public static final String ENTITY_CONFIG_CREATED = "ENTITY_CONFIG_CREATED";
    public static final String CONFIG_ERROR_CREATE_ENTITY_CONFIG = "CONFIG_ERROR_CREATE_ENTITY_CONFIG";
    public static final String CREATE_INVALID_ENTITY_CONFIG = "CREATE_INVALID_ENTITY_CONFIG";
    public static final String NO_ENTITY_DESCRIPTOR_DELETE_ENTITY_CONFIG = "NO_ENTITY_DESCRIPTOR_DELETE_ENTITY_CONFIG";
    public static final String NO_ENTITY_CONFIG_DELETE_ENTITY_CONFIG = "NO_ENTITY_CONFIG_DELETE_ENTITY_CONFIG";
    public static final String ENTITY_CONFIG_DELETED = "ENTITY_CONFIG_DELETED";
    public static final String CONFIG_ERROR_DELETE_ENTITY_CONFIG = "CONFIG_ERROR_DELETE_ENTITY_CONFIG";
    public static final String CONFIG_ERROR_GET_ALL_HOSTED_ENTITIES = "CONFIG_ERROR_GET_ALL_HOSTED_ENTITIES";
    public static final String GOT_ALL_HOSTED_ENTITIES = "GOT_ALL_HOSTED_ENTITIES";
    public static final String CONFIG_ERROR_GET_ALL_REMOTE_ENTITIES = "CONFIG_ERROR_GET_ALL_REMOTE_ENTITIES";
    public static final String GOT_ALL_REMOTE_ENTITIES = "GOT_ALL_REMOTE_ENTITIES";
    public static final String CONFIG_ERROR_GET_ALL_ENTITIES = "CONFIG_ERROR_GET_ALL_ENTITIES";
    public static final String GOT_ALL_ENTITIES = "GOT_ALL_ENTITIES";
    public static final String NO_ACS_URL = "NO_ACS_URL";
    public static final String SLO_SUCCESSFUL = "SLO_SUCCESSFUL";
    public static final String ERROR_PROCESSING_MESSAGE = "ERROR_PROCESSING_MESSAGE";
    private static final String WSFEDERATION_LOG = "WSFederation";
    private static Logger logger = null;

    public static void access(Level level, String msgid, String[] data) {
        LogUtil.access(level, msgid, data, null);
    }

    public static void access(Level level, String msgid, String[] data, Object session) {
        if (logger != null) {
            try {
                logger.access(level, msgid, data, session);
            }
            catch (LogException le) {
                debug.error("LogUtil.access: Couldn't write log:", (Throwable)((Object)le));
            }
        }
    }

    public static void error(Level level, String msgid, String[] data) {
        LogUtil.error(level, msgid, data, null);
    }

    public static void error(Level level, String msgid, String[] data, Object session) {
        if (logger != null) {
            try {
                logger.error(level, msgid, data, session);
            }
            catch (LogException le) {
                debug.error("LogUtil.error: Couldn't write log:", (Throwable)((Object)le));
            }
        }
    }

    public boolean isLogEnabled() {
        if (logger == null) {
            return false;
        }
        return logger.isLogEnabled();
    }

    public static boolean isAccessLoggable(Level level) {
        if (logger == null) {
            return false;
        }
        return logger.isAccessLoggable(level);
    }

    public static boolean isErrorLoggable(Level level) {
        if (logger == null) {
            return false;
        }
        return logger.isErrorLoggable(level);
    }

    static {
        try {
            logger = LogManager.getLogger(WSFEDERATION_LOG);
        }
        catch (LogException le) {
            debug.error("LogUtil.static: Error getting logger: ", (Throwable)((Object)le));
        }
    }
}

