/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.key;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import java.io.ByteArrayInputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class KeyUtil {
    private static KeyProvider kp = null;
    protected static Hashtable encHash = new Hashtable();
    protected static Hashtable sigHash = new Hashtable();

    private KeyUtil() {
    }

    public static KeyProvider getKeyProviderInstance() {
        return kp;
    }

    public static String getSigningCertAlias(BaseConfigType baseConfig) {
        String alias;
        Map<String, List<String>> map = WSFederationMetaUtils.getAttributes(baseConfig);
        List<String> list = map.get("signingCertAlias");
        if (list != null && !list.isEmpty() && (alias = list.get(0)) != null && alias.length() != 0 && kp != null) {
            return alias;
        }
        return null;
    }

    public static PrivateKey getDecryptionKey(BaseConfigType baseConfig) {
        String alias;
        Map<String, List<String>> map = WSFederationMetaUtils.getAttributes(baseConfig);
        List<String> list = map.get("encryptionCertAlias");
        PrivateKey decryptionKey = null;
        if (list != null && !list.isEmpty() && (alias = list.get(0)) != null && alias.length() != 0 && kp != null) {
            decryptionKey = kp.getPrivateKey(alias);
        }
        return decryptionKey;
    }

    public static X509Certificate getVerificationCert(FederationElement fed, String entityID, boolean isIDP) {
        String index;
        X509Certificate cert;
        String role;
        String classMethod = "KeyUtil.getVerificationCert: ";
        String string = role = isIDP ? "idp" : "sp";
        if (WSFederationUtils.debug.messageEnabled()) {
            WSFederationUtils.debug.message(classMethod + "Entering... \nEntityID=" + entityID + "\nRole=" + role);
        }
        if ((cert = (X509Certificate)sigHash.get(index = entityID.trim() + "|" + role)) != null) {
            return cert;
        }
        if (fed == null) {
            WSFederationUtils.debug.error(classMethod + "Null SSODescriptorType input for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        cert = KeyUtil.getCert(fed);
        if (cert == null) {
            WSFederationUtils.debug.error(classMethod + "No signing cert for entityID=" + entityID + " in " + role + " role.");
            return null;
        }
        sigHash.put(index, cert);
        return cert;
    }

    public static X509Certificate getCert(FederationElement fed) {
        String classMethod = "KeyUtil.getCert: ";
        byte[] bt = WSFederationMetaManager.getTokenSigningCertificate(fed);
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ce) {
            WSFederationUtils.debug.error(classMethod + "Unable to get CertificateFactory " + "for X.509 type", (Throwable)ce);
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bt);
        X509Certificate retCert = null;
        try {
            while (bais.available() > 0) {
                retCert = (X509Certificate)cf.generateCertificate(bais);
            }
        }
        catch (CertificateException ce) {
            WSFederationUtils.debug.error(classMethod + "Unable to generate certificate from byte " + "array input stream.", (Throwable)ce);
            return null;
        }
        return retCert;
    }

    static {
        try {
            kp = (KeyProvider)Class.forName(SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.keyprovider.class")).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            WSFederationUtils.debug.error("KeyUtil static block: Couldn't find the class.", (Throwable)cnfe);
            kp = null;
        }
        catch (InstantiationException ie) {
            WSFederationUtils.debug.error("KeyUtil static block: Couldn't instantiate the key provider instance.", (Throwable)ie);
            kp = null;
        }
        catch (IllegalAccessException iae) {
            WSFederationUtils.debug.error("KeyUtil static block: Couldn't access the default constructor.", (Throwable)iae);
            kp = null;
        }
    }
}

