/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.common;

import com.sun.identity.multiprotocol.SingleLogoutManager;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.plugin.datastore.DataStoreProviderManager;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.xmlsig.SigManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.wsfederation.common.WSFederationConstants;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.key.KeyUtil;
import com.sun.identity.wsfederation.logging.LogUtil;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WSFederationUtils {
    public static Debug debug = Debug.getInstance((String)WSFederationConstants.AM_WSFEDERATION);
    public static ResourceBundle bundle = Locale.getInstallResourceBundle((String)"libWSFederation");
    private static HashMap wctxMap = new HashMap();
    public static DataStoreProvider dsProvider;
    public static SessionProvider sessionProvider;

    private WSFederationUtils() {
    }

    public static String accountRealmFromUserAgent(String uaHeader, String accountRealmCookieName) {
        String classMethod = "WSFederationUtils.accountRealmFromUserAgent";
        int leftBracket = uaHeader.indexOf(40);
        if (leftBracket == -1) {
            if (debug.warningEnabled()) {
                debug.warning(classMethod + "Can't find left bracket");
            }
            return null;
        }
        int rightBracket = uaHeader.lastIndexOf(41);
        if (rightBracket == -1 || rightBracket < leftBracket) {
            if (debug.warningEnabled()) {
                debug.warning(classMethod + "Can't find right bracket");
            }
            return null;
        }
        String insideBrackets = uaHeader.substring(leftBracket + 1, rightBracket);
        if (insideBrackets.length() == 0) {
            if (debug.warningEnabled()) {
                debug.warning(classMethod + "zero length between brackets");
            }
            return null;
        }
        String[] uaFields = insideBrackets.split("[\\s]*;[\\s]*");
        if (uaFields == null) {
            if (debug.warningEnabled()) {
                debug.warning(classMethod + "zero length between brackets");
            }
            return null;
        }
        for (int i = 0; i < uaFields.length; ++i) {
            if (uaFields[i].indexOf(accountRealmCookieName) == -1) continue;
            String[] keyValue = uaFields[i].split("[\\s]*:[\\s]*");
            if (keyValue.length < 2) {
                if (debug.warningEnabled()) {
                    debug.warning(classMethod + "can't see accountRealm in " + uaFields[i]);
                }
                return null;
            }
            if (!keyValue[0].equals(accountRealmCookieName)) {
                if (debug.warningEnabled()) {
                    debug.warning(classMethod + "can't understand " + uaFields[i]);
                }
                return null;
            }
            return keyValue[1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String putReplyURL(String wreply) {
        String wctx = SAML2Utils.generateID();
        HashMap hashMap = wctxMap;
        synchronized (hashMap) {
            wctxMap.put(wctx, wreply);
        }
        return wctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeReplyURL(String wctx) {
        String wreply = null;
        HashMap hashMap = wctxMap;
        synchronized (hashMap) {
            wreply = (String)wctxMap.remove(wctx);
        }
        return wreply;
    }

    public static boolean isSignatureValid(Assertion assertion, String realm, String issuer) {
        boolean valid = false;
        String signedXMLString = assertion.toString(true, true);
        String id = assertion.getAssertionID();
        try {
            FederationElement idp = WSFederationMetaManager.getEntityDescriptor(realm, issuer);
            X509Certificate cert = KeyUtil.getVerificationCert(idp, issuer, true);
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            valid = SigManager.getSigInstance().verify(signedXMLString, id, cert);
        }
        catch (WSFederationMetaException ex) {
            valid = false;
        }
        catch (SAML2Exception ex) {
            valid = false;
        }
        if (!valid) {
            String[] data = new String[]{LogUtil.isErrorLoggable(Level.FINER) ? signedXMLString : id, realm, issuer};
            LogUtil.error(Level.INFO, LogUtil.INVALID_SIGNATURE_ASSERTION, data, null);
        }
        return valid;
    }

    public static boolean isTimeValid(Assertion assertion, int timeskew) {
        String classMethod = "WSFederationUtils.isTimeValid: ";
        long timeNow = System.currentTimeMillis();
        Date notOnOrAfter = assertion.getConditions().getNotOnorAfter();
        String assertionID = assertion.getAssertionID();
        if (notOnOrAfter == null) {
            String[] data = new String[]{LogUtil.isErrorLoggable(Level.FINER) ? assertion.toString(true, true) : assertionID};
            LogUtil.error(Level.INFO, "MISSING_CONDITIONS_NOT_ON_OR_AFTER", data, null);
            return false;
        }
        if (notOnOrAfter.getTime() + (long)(timeskew * 1000) < timeNow) {
            String[] data = new String[]{LogUtil.isErrorLoggable(Level.FINER) ? assertion.toString(true, true) : assertionID, notOnOrAfter.toString(), Integer.toString(timeskew), new Date(timeNow).toString()};
            LogUtil.error(Level.INFO, "ASSERTION_EXPIRED", data, null);
            return false;
        }
        Date notBefore = assertion.getConditions().getNotBefore();
        if (notBefore == null) {
            String[] data = new String[]{LogUtil.isErrorLoggable(Level.FINER) ? assertion.toString(true, true) : assertionID};
            LogUtil.error(Level.INFO, "MISSING_CONDITIONS_NOT_BEFORE", data, null);
            return false;
        }
        if (notBefore.getTime() - (long)(timeskew * 1000) > timeNow) {
            String[] data = new String[]{LogUtil.isErrorLoggable(Level.FINER) ? assertion.toString(true, true) : assertionID, notBefore.toString(), Integer.toString(timeskew), new Date(timeNow).toString()};
            LogUtil.error(Level.INFO, "ASSERTION_NOT_YET_VALID", data, null);
            return false;
        }
        return true;
    }

    public static void processMultiProtocolLogout(HttpServletRequest request, HttpServletResponse response, Object userSession) {
        debug.message("WSFederationUtils.processMPSingleLogout");
        try {
            String wreply = (String)request.getAttribute("com.sun.identity.wsfederation.logout.wreply");
            String realm = (String)request.getAttribute("famrealm");
            String idpEntityId = (String)request.getAttribute("wsfed-entityid");
            HashSet<Object> sessSet = new HashSet<Object>();
            sessSet.add(userSession);
            String sessUser = SessionManager.getProvider().getPrincipalName(userSession);
            SingleLogoutManager manager = SingleLogoutManager.getInstance();
            int status = manager.doIDPSingleLogout(sessSet, sessUser, request, response, false, true, "wsfed", realm, idpEntityId, null, wreply, null, null, 0);
            if (status != 3) {
                response.sendRedirect(wreply);
            }
        }
        catch (SessionException ex) {
            debug.message("WSFederationUtils.processMultiProtocolLogout", (Throwable)((Object)ex));
        }
        catch (IOException ex) {
            debug.message("WSFederationUtils.processMultiProtocolLogout", (Throwable)ex);
        }
        catch (Exception ex) {
            debug.message("WSFederationUtils.processMultiProtocolLogout", (Throwable)ex);
        }
    }

    static {
        sessionProvider = null;
        String classMethod = "WSFederationUtils static initializer: ";
        try {
            DataStoreProviderManager dsManager = DataStoreProviderManager.getInstance();
            dsProvider = dsManager.getDataStoreProvider("wsfederation");
        }
        catch (DataStoreProviderException dse) {
            debug.error(classMethod + "DataStoreProviderException : ", (Throwable)((Object)dse));
            throw new ExceptionInInitializerError((Throwable)((Object)dse));
        }
        try {
            sessionProvider = SessionManager.getProvider();
        }
        catch (SessionException se) {
            debug.error(classMethod + "Error getting SessionProvider.", (Throwable)((Object)se));
            throw new ExceptionInInitializerError((Throwable)((Object)se));
        }
    }
}

