/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.servlet;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.IDPProxyUtil;
import com.sun.identity.saml2.profile.IDPSession;
import com.sun.identity.saml2.profile.IDPSingleLogout;
import com.sun.identity.saml2.profile.LogoutUtil;
import com.sun.identity.saml2.protocol.LogoutRequest;
import com.sun.identity.saml2.protocol.LogoutResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class IDPSingleLogoutServiceSOAP
extends HttpServlet {
    public void init() throws ServletException {
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            SAMLUtils.checkHTTPContentLength(req);
            String idpMetaAlias = SAML2MetaUtils.getMetaAliasByUri(req.getRequestURI());
            String idpEntityID = SAML2Utils.getSAML2MetaManager().getEntityByMetaAlias(idpMetaAlias);
            String realm = SAML2MetaUtils.getRealmByMetaAlias(idpMetaAlias);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("IDPSLOSOAP.doPost : uri =" + req.getRequestURI() + ", idpMetaAlias=" + idpMetaAlias + ", idpEntityID=" + idpEntityID);
            }
            MimeHeaders headers = SAML2Utils.getHeaders(req);
            ServletInputStream is = req.getInputStream();
            SOAPMessage msg = MessageFactory.newInstance().createMessage(headers, (InputStream)is);
            Map aMap = IDPProxyUtil.getSessionPartners(msg);
            List partners = (List)aMap.get("PARTNERS");
            SOAPMessage reply = null;
            reply = this.onMessage(msg, req, resp, idpEntityID, realm);
            if (reply != null) {
                if (partners != null && !partners.isEmpty()) {
                    Element reqElem = SAML2Utils.getSamlpElement(msg, "LogoutRequest");
                    LogoutRequest logoutReq = ProtocolFactory.getInstance().createLogoutRequest(reqElem);
                    IDPCache.SOAPMessageByLogoutRequestID.put(logoutReq.getID(), reply);
                    IDPProxyUtil.sendProxyLogoutRequestSOAP(req, resp, reply, partners, (IDPSession)aMap.get("IDPSESSION"));
                } else {
                    if (reply.saveRequired()) {
                        reply.saveChanges();
                    }
                    resp.setStatus(200);
                    SAML2Utils.putHeaders(reply.getMimeHeaders(), resp);
                    String sessionIndex = (String)aMap.get("SessionIndex");
                    ServletOutputStream os = resp.getOutputStream();
                    reply.writeTo((OutputStream)os);
                    os.flush();
                }
            } else {
                resp.setStatus(204);
            }
        }
        catch (SAML2Exception ex) {
            SAML2Utils.debug.error("IDPSingleLogoutServiceSOAP", (Throwable)((Object)ex));
            resp.sendError(500, ex.getMessage());
        }
        catch (SOAPException soap) {
            SAML2Utils.debug.error("IDPSingleLogoutServiceSOAP", (Throwable)soap);
            resp.sendError(500, soap.getMessage());
        }
    }

    public SOAPMessage onMessage(SOAPMessage message, HttpServletRequest request, HttpServletResponse response, String idpEntityID, String realm) {
        SAML2Utils.debug.message("IDPSingleLogoutServiceSOAP.onMessage: init");
        LogoutRequest logoutReq = null;
        try {
            Element reqElem = SAML2Utils.getSamlpElement(message, "LogoutRequest");
            logoutReq = ProtocolFactory.getInstance().createLogoutRequest(reqElem);
        }
        catch (SAML2Exception se) {
            SAML2Utils.debug.error("IDPSingleLogoutServiceSOAP.onMessage: unable to get LogoutRequest from message", (Throwable)((Object)se));
            return SAML2Utils.createSOAPFault("Client", "errorLogoutRequest", se.getMessage());
        }
        if (logoutReq == null) {
            SAML2Utils.debug.error("IDPSingleLogoutServiceSOAP.onMessage: LogoutRequest is null");
            return SAML2Utils.createSOAPFault("Client", "nullLogoutRequest", null);
        }
        LogoutResponse loRes = null;
        try {
            loRes = IDPSingleLogout.processLogoutRequest(logoutReq, request, response, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", null, idpEntityID, realm, false);
            LogoutUtil.signSLOResponse(loRes, realm, idpEntityID, "IDPRole", logoutReq.getIssuer().getValue());
        }
        catch (SAML2Exception e) {
            SAML2Utils.debug.error("IDPSingleLogoutServiceSOAP.onMessage;", (Throwable)((Object)e));
            return SAML2Utils.createSOAPFault("Server", "errorLogoutResponse", e.getMessage());
        }
        if (loRes == null) {
            SAML2Utils.debug.error("IDPSingleLogoutServiceSOAP.onMessage: LogoutResponse is null");
            return SAML2Utils.createSOAPFault("Server", "errorLogoutResponse", null);
        }
        SOAPMessage msg = null;
        try {
            msg = SAML2Utils.createSOAPMessage(loRes.toXMLString(true, true));
        }
        catch (SAML2Exception se) {
            SAML2Utils.debug.error("IDPSingleLogoutServiceSOAP.onMessage: Unable to create SOAP message:", (Throwable)((Object)se));
            return SAML2Utils.createSOAPFault("Server", "errorLogoutResponseSOAP", se.getMessage());
        }
        catch (SOAPException ex) {
            SAML2Utils.debug.error("IDPSingleLogoutServiceSOAP.onMessage: Unable to create SOAP message:", (Throwable)ex);
            return SAML2Utils.createSOAPFault("Server", "errorLogoutResponseSOAP", ex.getMessage());
        }
        return msg;
    }
}

