/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.servlet;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.profile.AuthnQueryUtil;
import com.sun.identity.saml2.protocol.AuthnQuery;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class AuthnQueryServiceSOAP
extends HttpServlet {
    public void init() throws ServletException {
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGetPost(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGetPost(req, resp);
    }

    private void doGetPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        SAMLUtils.checkHTTPContentLength(req);
        AuthnQuery authnQuery = null;
        MimeHeaders headers = SAML2Utils.getHeaders(req);
        try {
            ServletInputStream is = req.getInputStream();
            SOAPMessage msg = SAML2Utils.mf.createMessage(headers, (InputStream)is);
            Element elem = SAML2Utils.getSamlpElement(msg, "AuthnQuery");
            authnQuery = ProtocolFactory.getInstance().createAuthnQuery(elem);
        }
        catch (Exception ex) {
            SAML2Utils.debug.error("AuthnQueryServiceSOAP.doGetPost:", (Throwable)ex);
            resp.sendError(500, ex.getMessage());
            return;
        }
        String authnAuthorityMetaAlias = SAML2MetaUtils.getMetaAliasByUri(req.getRequestURI());
        String authnAuthorityEntityID = null;
        String realm = null;
        try {
            authnAuthorityEntityID = SAML2Utils.getSAML2MetaManager().getEntityByMetaAlias(authnAuthorityMetaAlias);
            realm = SAML2MetaUtils.getRealmByMetaAlias(authnAuthorityMetaAlias);
        }
        catch (SAML2Exception sme) {
            SAML2Utils.debug.error("AuthnQueryServiceSOAP.doGetPost", (Throwable)((Object)sme));
            resp.sendError(500, sme.getMessage());
            return;
        }
        SOAPMessage replymsg = null;
        try {
            Response samlResp = AuthnQueryUtil.processAuthnQuery(authnQuery, req, resp, authnAuthorityEntityID, realm);
            replymsg = SAML2Utils.createSOAPMessage(samlResp.toXMLString(true, true));
        }
        catch (Throwable t) {
            SAML2Utils.debug.error("AuthnQueryServiceSOAP.doGetPost: Unable to create SOAP message:", t);
            replymsg = SAML2Utils.createSOAPFault("Server", "unableToCreateSOAPMessage", null);
        }
        try {
            if (replymsg.saveRequired()) {
                replymsg.saveChanges();
            }
            resp.setStatus(200);
            SAML2Utils.putHeaders(replymsg.getMimeHeaders(), resp);
            ServletOutputStream os = resp.getOutputStream();
            replymsg.writeTo((OutputStream)os);
            os.flush();
        }
        catch (SOAPException soap) {
            SAML2Utils.debug.error("AuthnQueryServiceSOAP.doGetPost", (Throwable)soap);
            resp.sendError(500, soap.getMessage());
        }
    }
}

