/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.Extensions;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.RequestAbstract;
import com.sun.identity.saml2.xmlsig.SigManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RequestAbstractImpl
implements RequestAbstract {
    protected Issuer nameID = null;
    protected Extensions extensions = null;
    protected String requestId = null;
    protected String version = null;
    protected Date issueInstant = null;
    protected String destinationURI = null;
    protected String consent = null;
    protected boolean isSigned = false;
    protected Boolean isSignatureValid = null;
    protected PublicKey publicKey = null;
    protected boolean isMutable = false;
    protected String signatureString = null;
    protected String signedXMLString = null;
    protected String elementName = "";

    public void setIssuer(Issuer nameID) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.nameID = nameID;
    }

    public Issuer getIssuer() {
        return this.nameID;
    }

    public String getSignature() {
        return this.signatureString;
    }

    public void sign(PrivateKey privateKey, X509Certificate cert) throws SAML2Exception {
        Element signatureEle = SigManager.getSigInstance().sign(this.toXMLString(true, true), this.getID(), privateKey, cert);
        this.signatureString = XMLUtils.print((Node)signatureEle);
        this.signedXMLString = XMLUtils.print((Node)signatureEle.getOwnerDocument().getDocumentElement());
        this.isSigned = true;
        this.makeImmutable();
    }

    public void setExtensions(Extensions extensions) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.extensions = extensions;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public void setID(String id) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.requestId = id;
    }

    public String getID() {
        return this.requestId;
    }

    public void setVersion(String version) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setIssueInstant(Date dateTime) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.issueInstant = dateTime;
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public void setDestination(String destinationURI) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.destinationURI = destinationURI;
    }

    public String getDestination() {
        return this.destinationURI;
    }

    public void setConsent(String consent) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.consent = consent;
    }

    public String getConsent() {
        return this.consent;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isSignatureValid(X509Certificate senderCert) throws SAML2Exception {
        if (this.isSignatureValid == null) {
            this.isSignatureValid = SigManager.getSigInstance().verify(this.signedXMLString, this.getID(), senderCert);
        }
        return this.isSignatureValid;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        if (this.isSigned && this.signedXMLString != null) {
            return this.signedXMLString;
        }
        HashSet namespaces = new HashSet();
        StringBuffer attrs = new StringBuffer();
        StringBuffer childElements = new StringBuffer();
        this.getXMLString(namespaces, attrs, childElements, includeNSPrefix, declareNS);
        StringBuffer xmlString = new StringBuffer(1000);
        xmlString.append("<");
        if (includeNSPrefix) {
            xmlString.append("samlp:");
        }
        xmlString.append(this.elementName);
        if (!namespaces.isEmpty()) {
            Iterator iter = namespaces.iterator();
            while (iter.hasNext()) {
                xmlString.append(" ").append((String)iter.next());
            }
        }
        xmlString.append(attrs).append(">").append("\n").append(childElements).append("<").append("/");
        if (includeNSPrefix) {
            xmlString.append("samlp:");
        }
        xmlString.append(this.elementName).append(">");
        return xmlString.toString();
    }

    protected String getAttributesString() throws SAML2Exception {
        StringBuffer xml = new StringBuffer();
        xml.append("ID=\"");
        xml.append(this.requestId);
        xml.append("\" ");
        xml.append("Version=\"");
        xml.append(this.version);
        xml.append("\" ");
        xml.append("IssueInstant=\"");
        xml.append(DateUtils.toUTCDateFormat((Date)this.issueInstant));
        xml.append("\" ");
        if (this.destinationURI != null && this.destinationURI.length() > 0) {
            xml.append("Destination=\"");
            xml.append(this.destinationURI);
            xml.append("\" ");
        }
        if (this.consent != null && this.consent.length() > 0) {
            xml.append("Consent=\"");
            xml.append(this.consent);
            xml.append("\" ");
        }
        return xml.toString();
    }

    protected String getElements(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        StringBuffer xml = new StringBuffer();
        if (this.nameID != null) {
            xml.append(this.nameID.toXMLString(includeNSPrefix, declareNS));
        }
        if (this.signatureString != null && !this.signatureString.equals("")) {
            xml.append(this.signatureString);
        }
        if (this.extensions != null) {
            xml.append(this.extensions.toXMLString(includeNSPrefix, declareNS));
        }
        return xml.toString();
    }

    public void makeImmutable() {
        if (this.isMutable) {
            if (this.nameID != null && this.nameID.isMutable()) {
                this.nameID.makeImmutable();
            }
            if (this.extensions != null && this.extensions.isMutable()) {
                this.extensions.makeImmutable();
            }
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    protected void validateID(String requestID) throws SAML2Exception {
        if (this.requestId == null || this.requestId.length() == 0) {
            SAML2SDKUtils.debug.message("ID is missing in the SAMLRequest");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingIDAttr"));
        }
    }

    protected void validateVersion(String version) throws SAML2Exception {
        if (version == null || version.length() == 0) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingVersion"));
        }
        if (!version.equals("2.0")) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("incorrectVersion"));
        }
    }

    protected void validateIssueInstant(String issueInstantStr) throws SAML2Exception {
        if (issueInstantStr == null || issueInstantStr.length() == 0) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingIssueInstant"));
        }
        try {
            this.issueInstant = DateUtils.stringToDate((String)issueInstantStr);
        }
        catch (ParseException e) {
            SAML2SDKUtils.debug.message("Error parsing IssueInstant", (Throwable)e);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("incorrectIssueInstant"));
        }
    }

    protected void validateData() throws SAML2Exception {
        this.validateID(this.requestId);
        this.validateVersion(this.version);
        if (this.issueInstant == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("incorrectIssueInstant"));
        }
        this.validateIssueInstant(DateUtils.dateToString((Date)this.issueInstant));
    }

    protected void getXMLString(Set namespaces, StringBuffer attrs, StringBuffer childElements, boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        this.validateData();
        attrs.append(" ").append("ID").append("=").append("\"").append(this.requestId).append("\"").append(" ").append("Version").append("=").append("\"").append(this.version).append("\"").append(" ").append("IssueInstant").append("=").append("\"").append(DateUtils.toUTCDateFormat((Date)this.issueInstant)).append("\"");
        if (this.destinationURI != null && this.destinationURI.length() > 0) {
            attrs.append(" ").append("Destination").append("=").append("\"").append(this.destinationURI).append("\"");
        }
        if (this.consent != null && this.consent.length() > 0) {
            attrs.append(" ").append("Consent").append("=").append("\"").append(this.consent).append("\"");
        }
        if (this.nameID != null) {
            childElements.append(this.nameID.toXMLString(includeNSPrefix, declareNS)).append("\n");
        }
        if (this.signatureString != null && this.signatureString.length() > 0) {
            childElements.append(this.signatureString).append("\n");
        }
        if (this.extensions != null) {
            childElements.append(this.extensions.toXMLString(includeNSPrefix, declareNS)).append("\n");
        }
    }

    protected void parseDOMElement(Element element) throws SAML2Exception {
        this.parseDOMAttributes(element);
        ArrayList<Node> childElementList = new ArrayList<Node>();
        NodeList nList = element.getChildNodes();
        if (nList != null && nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node childNode = nList.item(i);
                if (childNode.getNodeType() != 1) continue;
                childElementList.add(childNode);
            }
        }
        ListIterator iter = childElementList.listIterator();
        this.parseDOMChileElements(iter);
        if (iter.hasNext()) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("RequestAbstractImpl.parseDOMElement: Unexpected child element found");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
        }
    }

    protected void parseDOMAttributes(Element element) throws SAML2Exception {
        this.requestId = element.getAttribute("ID");
        this.validateID(this.requestId);
        this.version = element.getAttribute("Version");
        this.validateVersion(this.version);
        String issueInstantStr = element.getAttribute("IssueInstant");
        this.validateIssueInstant(issueInstantStr);
        this.destinationURI = element.getAttribute("Destination");
        this.consent = element.getAttribute("Consent");
    }

    protected void parseDOMChileElements(ListIterator iter) throws SAML2Exception {
        AssertionFactory assertionFactory = AssertionFactory.getInstance();
        ProtocolFactory protoFactory = ProtocolFactory.getInstance();
        while (iter.hasNext()) {
            Element childElement = (Element)iter.next();
            String localName = childElement.getLocalName();
            if ("Issuer".equals(localName)) {
                this.validateIssuer();
                this.nameID = assertionFactory.createIssuer(childElement);
                continue;
            }
            if ("Signature".equals(localName)) {
                this.validateSignature();
                this.signatureString = XMLUtils.print((Node)childElement);
                this.isSigned = true;
                continue;
            }
            if ("Extensions".equals(localName)) {
                this.validateExtensions();
                this.extensions = protoFactory.createExtensions(childElement);
                continue;
            }
            iter.previous();
            break;
        }
    }

    private void validateIssuer() throws SAML2Exception {
        if (this.nameID != null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("RequestAbstractImpl.validateIssuer: Too many Issuer Element");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
        }
        if (this.signatureString != null || this.extensions != null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("RequestAbstractImpl.validateIssuer: Issuer Element should be the first element in the Request");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
        }
    }

    private void validateSignature() throws SAML2Exception {
        if (this.signatureString != null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("RequestAbstractImpl.validateSignature: Too many Signature Elements");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
        }
        if (this.extensions != null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("RequestAbstractImpl.validateSignature: Signature should be in front of Extensions");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
        }
    }

    private void validateExtensions() throws SAML2Exception {
        if (this.extensions != null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("RequestAbstractImpl.validateExtensions: Too many Extension Elements");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
        }
    }
}

