/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.BaseID;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.NameIDMappingRequest;
import com.sun.identity.saml2.protocol.NameIDPolicy;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.impl.RequestAbstractImpl;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ListIterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NameIDMappingRequestImpl
extends RequestAbstractImpl
implements NameIDMappingRequest {
    private EncryptedID encryptedID = null;
    private NameID nameID = null;
    private BaseID baseID = null;
    private NameIDPolicy nameIDPolicy = null;

    public NameIDMappingRequestImpl() {
        this.elementName = "NameIDMappingRequest";
        this.isMutable = true;
    }

    public NameIDMappingRequestImpl(Element element) throws SAML2Exception {
        this.parseDOMElement(element);
        if (this.isSigned) {
            this.signedXMLString = XMLUtils.print((Node)element);
        }
        this.elementName = "NameIDMappingRequest";
        this.makeImmutable();
    }

    public NameIDMappingRequestImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception("errorObtainingElement");
        }
        this.parseDOMElement(doc.getDocumentElement());
        if (this.isSigned) {
            this.signedXMLString = xmlString;
        }
        this.elementName = "NameIDMappingRequest";
        this.makeImmutable();
    }

    public EncryptedID getEncryptedID() {
        return this.encryptedID;
    }

    public void setEncryptedID(EncryptedID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.encryptedID = value;
    }

    public NameID getNameID() {
        return this.nameID;
    }

    public void setNameID(NameID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.nameID = value;
    }

    public NameIDPolicy getNameIDPolicy() {
        return this.nameIDPolicy;
    }

    public void setNameIDPolicy(NameIDPolicy nameIDPolicy) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.nameIDPolicy = nameIDPolicy;
    }

    public BaseID getBaseID() {
        return this.baseID;
    }

    public void setBaseID(BaseID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.baseID = value;
    }

    protected void parseDOMAttributes(Element element) throws SAML2Exception {
        super.parseDOMAttributes(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseDOMChileElements(ListIterator iter) throws SAML2Exception {
        super.parseDOMChileElements(iter);
        AssertionFactory assertionFactory = AssertionFactory.getInstance();
        if (!iter.hasNext()) throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nameIDMReqWrongID"));
        Element childElement = (Element)iter.next();
        String localName = childElement.getLocalName();
        if ("BaseID".equals(localName)) {
            this.baseID = assertionFactory.createBaseID(childElement);
        } else if ("NameID".equals(localName)) {
            this.nameID = assertionFactory.createNameID(childElement);
        } else {
            if (!"EncryptedID".equals(localName)) throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nameIDMReqWrongID"));
            this.encryptedID = assertionFactory.createEncryptedID(childElement);
        }
        if (!iter.hasNext()) throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nameIDMReqMissingNameIDPolicy"));
        childElement = (Element)iter.next();
        localName = childElement.getLocalName();
        if (!"NameIDPolicy".equals(localName)) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nameIDMReqMissingNameIDPolicy"));
        }
        this.nameIDPolicy = ProtocolFactory.getInstance().createNameIDPolicy(childElement);
    }

    protected void getXMLString(Set namespaces, StringBuffer attrs, StringBuffer childElements, boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        this.validateData();
        if (declareNS) {
            namespaces.add(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"".trim());
            namespaces.add(" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"".trim());
        }
        super.getXMLString(namespaces, attrs, childElements, includeNSPrefix, declareNS);
        if (this.baseID != null) {
            childElements.append(this.baseID.toXMLString(includeNSPrefix, declareNS)).append("\n");
        }
        if (this.nameID != null) {
            childElements.append(this.nameID.toXMLString(includeNSPrefix, declareNS)).append("\n");
        }
        if (this.encryptedID != null) {
            childElements.append(this.encryptedID.toXMLString(includeNSPrefix, declareNS)).append("\n");
        }
        childElements.append(this.nameIDPolicy.toXMLString(includeNSPrefix, declareNS)).append("\n");
    }

    protected void validateData() throws SAML2Exception {
        boolean count = false;
        if (this.nameID != null ? this.encryptedID != null || this.baseID != null : (this.encryptedID != null ? this.baseID != null : this.baseID == null)) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nameIDMReqWrongID"));
        }
        if (this.nameIDPolicy == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nameIDMReqMissingNameIDPolicy"));
        }
    }

    public void makeImmutable() {
        if (this.isMutable) {
            super.makeImmutable();
            if (this.nameID != null && this.nameID.isMutable()) {
                this.nameID.makeImmutable();
            }
            if (this.baseID != null && this.baseID.isMutable()) {
                this.baseID.makeImmutable();
            }
            if (this.nameIDPolicy != null && this.nameIDPolicy.isMutable()) {
                this.nameIDPolicy.makeImmutable();
            }
            this.isMutable = false;
        }
    }
}

