/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.AttributeQuery;
import com.sun.identity.saml2.protocol.impl.SubjectQueryAbstractImpl;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeQueryImpl
extends SubjectQueryAbstractImpl
implements AttributeQuery {
    protected List attributes;

    public AttributeQueryImpl() {
        this.elementName = "AttributeQuery";
        this.isMutable = true;
    }

    public AttributeQueryImpl(Element element) throws SAML2Exception {
        this.parseDOMElement(element);
        this.elementName = "AttributeQuery";
        if (this.isSigned) {
            this.signedXMLString = XMLUtils.print((Node)element);
        }
    }

    public AttributeQueryImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseDOMElement(xmlDocument.getDocumentElement());
        this.elementName = "AttributeQuery";
        if (this.isSigned) {
            this.signedXMLString = xmlString;
        }
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attributes) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.attributes = attributes;
    }

    protected void getXMLString(Set namespaces, StringBuffer attrs, StringBuffer childElements, boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        if (declareNS) {
            namespaces.add(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"".trim());
            namespaces.add(" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"".trim());
        }
        super.getXMLString(namespaces, attrs, childElements, includeNSPrefix, declareNS);
        if (this.attributes != null && !this.attributes.isEmpty()) {
            Iterator iter = this.attributes.iterator();
            while (iter.hasNext()) {
                Attribute attribute = (Attribute)iter.next();
                childElements.append(attribute.toXMLString(includeNSPrefix, declareNS)).append("\n");
            }
        }
    }

    protected void parseDOMAttributes(Element element) throws SAML2Exception {
        super.parseDOMAttributes(element);
    }

    protected void parseDOMChileElements(ListIterator iter) throws SAML2Exception {
        super.parseDOMChileElements(iter);
        AssertionFactory assertionFactory = AssertionFactory.getInstance();
        while (iter.hasNext()) {
            Element childElement = (Element)iter.next();
            String localName = childElement.getLocalName();
            if ("Attribute".equals(localName)) {
                if (this.attributes == null) {
                    this.attributes = new ArrayList();
                }
                this.attributes.add(assertionFactory.createAttribute(childElement));
                continue;
            }
            iter.previous();
        }
    }
}

