/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.ArtifactResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.impl.StatusResponseImpl;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArtifactResponseImpl
extends StatusResponseImpl
implements ArtifactResponse {
    private String anyString = null;

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ArtifactResponseImpl.parseElement: element input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("ArtifactResponse")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ArtifactResponseImpl.parseElement: not ArtifactResponse.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        NamedNodeMap atts = element.getAttributes();
        if (atts != null) {
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attr = (Attr)atts.item(i);
                String attrName = attr.getName();
                String attrValue = attr.getValue().trim();
                if (attrName.equals("ID")) {
                    this.responseId = attrValue;
                    continue;
                }
                if (attrName.equals("InResponseTo")) {
                    this.inResponseTo = attrValue;
                    continue;
                }
                if (attrName.equals("Version")) {
                    this.version = attrValue;
                    continue;
                }
                if (attrName.equals("IssueInstant")) {
                    try {
                        this.issueInstant = DateUtils.stringToDate((String)attrValue);
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new SAML2Exception(pe.getMessage());
                    }
                }
                if (attrName.equals("Destination")) {
                    this.destination = attrValue;
                    continue;
                }
                if (!attrName.equals("Consent")) continue;
                this.consent = attrValue;
            }
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("Issuer")) {
                if (this.issuer != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("ArtifactResponseImpl.parseElement: included more than one Issuer.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("moreElement"));
                }
                if (this.signatureString != null || this.extensions != null || this.status != null || this.anyString != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("ArtifactResponseImpl.parseElement:wrong sequence.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
                }
                this.issuer = AssertionFactory.getInstance().createIssuer((Element)child);
                continue;
            }
            if (childName.equals("Signature")) {
                if (this.signatureString != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("ArtifactResponseImpl.parseElement:included more than one Signature.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("moreElement"));
                }
                if (this.extensions != null || this.status != null || this.anyString != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("ArtifactResponseImpl.parseElement:wrong sequence.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
                }
                this.signatureString = XMLUtils.print((Node)((Element)child));
                this.isSigned = true;
                continue;
            }
            if (childName.equals("Extensions")) {
                if (this.extensions != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("ArtifactResponseImpl.parseElement:included more than one Extensions.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("moreElement"));
                }
                if (this.status != null || this.anyString != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("ArtifactResponseImpl.parseElement:wrong sequence.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
                }
                this.extensions = ProtocolFactory.getInstance().createExtensions((Element)child);
                continue;
            }
            if (childName.equals("Status")) {
                if (this.status != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("ArtifactResponseImpl.parseElement: included more than one Status.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("moreElement"));
                }
                if (this.anyString != null) {
                    if (SAML2SDKUtils.debug.messageEnabled()) {
                        SAML2SDKUtils.debug.message("ResponseImpl.parseElement:wrong sequence.");
                    }
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
                }
                this.status = ProtocolFactory.getInstance().createStatus((Element)child);
                continue;
            }
            if (this.anyString != null) {
                if (SAML2SDKUtils.debug.messageEnabled()) {
                    SAML2SDKUtils.debug.message("ArtifactResponseImpl.parseElement: included more than one any element.");
                }
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("moreElement"));
            }
            this.anyString = XMLUtils.print((Node)((Element)child));
        }
        super.validateData();
        this.isMutable = false;
    }

    public ArtifactResponseImpl() {
        this.isMutable = true;
    }

    public ArtifactResponseImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
        if (this.isSigned) {
            this.signedXMLString = XMLUtils.print((Node)element);
        }
    }

    public ArtifactResponseImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(doc.getDocumentElement());
        if (this.isSigned) {
            this.signedXMLString = xmlString;
        }
    }

    public String getAny() {
        return this.anyString;
    }

    public void setAny(String value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.anyString = value;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        if (this.isSigned && this.signedXMLString != null) {
            return this.signedXMLString;
        }
        this.validateData();
        StringBuffer result = new StringBuffer(1000);
        String prefix = "";
        String uri = "";
        if (includeNSPrefix) {
            prefix = "samlp:";
        }
        if (declareNS) {
            uri = " xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"";
        }
        result.append("<").append(prefix).append("ArtifactResponse").append(uri).append(" ID=\"").append(this.responseId).append("\"");
        if (this.inResponseTo != null && this.inResponseTo.trim().length() != 0) {
            result.append(" InResponseTo=\"").append(this.inResponseTo).append("\"");
        }
        result.append(" Version=\"").append(this.version).append("\"").append(" IssueInstant=\"").append(DateUtils.toUTCDateFormat((Date)this.issueInstant)).append("\"");
        if (this.destination != null && this.destination.trim().length() != 0) {
            result.append(" Destination=\"").append(this.destination).append("\"");
        }
        if (this.consent != null && this.consent.trim().length() != 0) {
            result.append(" Consent=\"").append(this.consent).append("\"");
        }
        result.append(">");
        if (this.issuer != null) {
            result.append(this.issuer.toXMLString(includeNSPrefix, declareNS));
        }
        if (this.signatureString != null) {
            result.append(this.signatureString);
        }
        if (this.extensions != null) {
            result.append(this.extensions.toXMLString(includeNSPrefix, declareNS));
        }
        result.append(this.status.toXMLString(includeNSPrefix, declareNS));
        if (this.anyString != null && this.anyString.trim().length() != 0) {
            result.append(this.anyString);
        }
        result.append("</").append(prefix).append("ArtifactResponse>");
        return result.toString();
    }
}

