/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.KeyDescriptorType;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.SingleLogoutServiceElement;
import com.sun.identity.saml2.key.EncInfo;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.profile.CacheObject;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.SPCache;
import com.sun.identity.saml2.profile.SPSingleLogout;
import com.sun.identity.saml2.protocol.Extensions;
import com.sun.identity.saml2.protocol.LogoutRequest;
import com.sun.identity.saml2.protocol.LogoutResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.SessionIndex;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.saml2.protocol.StatusDetail;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LogoutUtil {
    static KeyProvider keyProvider = KeyUtil.getKeyProviderInstance();
    static SAML2MetaManager metaManager = null;
    static Debug debug = SAML2Utils.debug;

    public static StringBuffer doLogout(String metaAlias, String recipientEntityID, List recipientSLOList, List extensionsList, String binding, String relayState, String sessionIndex, NameID nameID, HttpServletRequest request, HttpServletResponse response, Map paramsMap, BaseConfigType config) throws SAML2Exception, SessionException {
        String location;
        String requestID;
        StringBuffer logoutRequestID = new StringBuffer();
        String classMethod = "LogoutUtil.doLogout: ";
        String requesterEntityID = metaManager.getEntityByMetaAlias(metaAlias);
        String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
        String hostEntityRole = SAML2Utils.getHostEntityRole(paramsMap);
        if (debug.messageEnabled()) {
            debug.message(classMethod + "Entering ..." + "\nrequesterEntityID=" + requesterEntityID + "\nrecipientEntityID=" + recipientEntityID + "\nbinding=" + binding + "\nrelayState=" + relayState + "\nsessionIndex=" + sessionIndex);
        }
        if ((requestID = SAML2Utils.generateID()) == null || requestID.length() == 0) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("cannotGenerateID"));
        }
        String destinationURI = SAML2Utils.getParameter(paramsMap, "Destination");
        String consent = SAML2Utils.getParameter(paramsMap, "Consent");
        Extensions extensions = LogoutUtil.createExtensions(extensionsList);
        Issuer issuer = SAML2Utils.createIssuer(requesterEntityID);
        LogoutRequest logoutReq = null;
        try {
            logoutReq = ProtocolFactory.getInstance().createLogoutRequest();
        }
        catch (Exception e) {
            debug.error(classMethod + "Unable to create LogoutRequest : ", (Throwable)e);
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorCreatingLogoutRequest"));
        }
        logoutReq.setID(requestID);
        logoutReq.setVersion("2.0");
        logoutReq.setIssueInstant(new Date());
        LogoutUtil.setNameIDForSLORequest(logoutReq, nameID, realm, requesterEntityID, hostEntityRole, recipientEntityID);
        logoutReq.setDestination(destinationURI);
        logoutReq.setConsent(consent);
        logoutReq.setIssuer(issuer);
        if (hostEntityRole.equals("IDPRole")) {
            int effectiveTime = 600;
            String effectiveTimeStr = SAML2Utils.getAttributeValueFromSSOConfig(realm, requesterEntityID, "IDPRole", "assertionEffectiveTime");
            if (effectiveTimeStr != null) {
                try {
                    effectiveTime = Integer.parseInt(effectiveTimeStr);
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message(classMethod + "got effective time from config:" + effectiveTime);
                    }
                }
                catch (NumberFormatException nfe) {
                    SAML2Utils.debug.error(classMethod + "Failed to get assertion effective time from " + "IDP SSO config: ", (Throwable)nfe);
                    effectiveTime = 600;
                }
            }
            Date date = new Date();
            date.setTime(date.getTime() + (long)(effectiveTime * 1000));
            logoutReq.setNotOnOrAfter(date);
        }
        if (extensions != null) {
            logoutReq.setExtensions(extensions);
        }
        if (sessionIndex != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(sessionIndex);
            logoutReq.setSessionIndex(list);
        }
        if ((location = LogoutUtil.getSLOServiceLocation(recipientSLOList, binding)) == null || location.length() == 0) {
            debug.error(classMethod + "Unable to find the recipient's single logout " + "service with the binding " + binding);
            throw new SAML2Exception(SAML2Utils.bundle.getString("sloServiceNotfound"));
        }
        debug.message(classMethod + "Recipient's single logout service location = " + location);
        if (destinationURI == null || destinationURI.length() == 0) {
            logoutReq.setDestination(location);
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "SLO Request before signing : ");
            debug.message(logoutReq.toXMLString(true, true));
        }
        if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
            try {
                LogoutUtil.doSLOByHttpRedirect(logoutReq.toXMLString(true, true), location, relayState, realm, requesterEntityID, hostEntityRole, recipientEntityID, response);
                logoutRequestID.append(requestID);
                String[] data = new String[]{location};
                LogUtil.access(Level.INFO, "REDIRECT_TO_IDP", data, null);
            }
            catch (Exception e) {
                debug.error("Exception :", (Throwable)e);
                throw new SAML2Exception(SAML2Utils.bundle.getString("errorRedirectingLogoutRequest"));
            }
        } else if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            logoutRequestID.append(requestID);
            LogoutUtil.signSLORequest(logoutReq, realm, requesterEntityID, hostEntityRole, recipientEntityID);
            if (debug.messageEnabled()) {
                debug.message(classMethod + "SLO Request after signing : ");
                debug.message(logoutReq.toXMLString(true, true));
            }
            location = SAML2Utils.fillInBasicAuthInfo(config, location);
            LogoutUtil.doSLOBySOAP(requestID, logoutReq, location, realm, requesterEntityID, hostEntityRole, request, response);
        } else if (binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            logoutRequestID.append(requestID);
            LogoutUtil.signSLORequest(logoutReq, realm, requesterEntityID, hostEntityRole, recipientEntityID);
            if (debug.messageEnabled()) {
                debug.message(classMethod + "SLO Request after signing : ");
                debug.message(logoutReq.toXMLString(true, true));
            }
            LogoutUtil.doSLOByPOST(requestID, logoutReq.toXMLString(true, true), location, relayState, realm, requesterEntityID, hostEntityRole, response);
        }
        SPCache.logoutRequestIDHash.put((Object)logoutRequestID.toString(), (Object)logoutReq);
        return logoutRequestID;
    }

    private static void doSLOByHttpRedirect(String sloRequestXMLString, String sloURL, String relayState, String realm, String hostEntity, String hostEntityRole, String remoteEntity, HttpServletResponse response) throws SAML2Exception, IOException {
        String method = "doSLOByHttpRedirect: ";
        String encodedXML = SAML2Utils.encodeForRedirect(sloRequestXMLString);
        StringBuffer queryString = new StringBuffer().append("SAMLRequest").append("=").append(encodedXML);
        if (relayState != null && relayState.length() > 0) {
            String tmp = SAML2Utils.generateID();
            if (hostEntityRole.equals("IDPRole")) {
                IDPCache.relayStateCache.put((Object)tmp, (Object)relayState);
            } else {
                SPCache.relayStateHash.put((Object)tmp, (Object)new CacheObject(relayState));
            }
            queryString.append("&").append("RelayState").append("=").append(tmp);
        }
        boolean needToSign = false;
        needToSign = hostEntityRole.equalsIgnoreCase("IDPRole") ? SAML2Utils.getWantLogoutRequestSigned(realm, remoteEntity, "SPRole") : SAML2Utils.getWantLogoutRequestSigned(realm, remoteEntity, "IDPRole");
        String signedQueryString = queryString.toString();
        if (needToSign) {
            signedQueryString = SAML2Utils.signQueryString(signedQueryString, realm, hostEntity, hostEntityRole);
        }
        String redirectURL = sloURL + (sloURL.contains("?") ? "&" : "?") + signedQueryString;
        if (debug.messageEnabled()) {
            debug.message(method + "LogoutRequestXMLString : " + sloRequestXMLString);
            debug.message(method + "LogoutRedirectURL : " + sloURL);
        }
        response.sendRedirect(redirectURL);
    }

    private static void doSLOBySOAP(String requestID, LogoutRequest sloRequest, String sloURL, String realm, String hostEntity, String hostRole, HttpServletRequest request, HttpServletResponse response) throws SAML2Exception, SessionException {
        String sloRequestXMLString = sloRequest.toXMLString(true, true);
        if (debug.messageEnabled()) {
            debug.message("LogoutUtil.doSLOBySOAP : SLORequestXML: " + sloRequestXMLString + "\nSOAPURL : " + sloURL);
        }
        SOAPMessage resMsg = null;
        try {
            resMsg = SAML2Utils.sendSOAPMessage(sloRequestXMLString, sloURL);
        }
        catch (SOAPException se) {
            debug.error("Unable to send SOAPMessage to IDP ", (Throwable)se);
            throw new SAML2Exception(se.getMessage());
        }
        Element respElem = SAML2Utils.getSamlpElement(resMsg, "LogoutResponse");
        LogoutResponse sloResponse = ProtocolFactory.getInstance().createLogoutResponse(respElem);
        String userId = null;
        if (hostRole != null && hostRole.equals("SPRole")) {
            userId = SPSingleLogout.preSingleLogoutProcess(hostEntity, realm, request, response, null, sloRequest, sloResponse, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        }
        if (sloResponse == null) {
            debug.error("LogoutUtil.doSLOBySoap : null response");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullLogoutResponse"));
        }
        if (debug.messageEnabled()) {
            debug.message("LogoutUtil.doSLOBySOAP : LogoutResponse without SOAP envelope:\n" + sloResponse.toXMLString());
        }
        Issuer resIssuer = sloResponse.getIssuer();
        String requestId = sloResponse.getInResponseTo();
        SAML2Utils.verifyResponseIssuer(realm, hostEntity, resIssuer, requestId);
        String remoteEntityID = sloResponse.getIssuer().getValue();
        LogoutUtil.verifySLOResponse(sloResponse, realm, remoteEntityID, hostEntity, hostRole);
        boolean success = LogoutUtil.checkSLOResponse(sloResponse, requestID);
        if (debug.messageEnabled()) {
            debug.message("Request success : " + success);
        }
        if (!success) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("sloFailed"));
        }
        if (hostRole != null && hostRole.equals("SPRole")) {
            SPSingleLogout.postSingleLogoutSuccess(hostEntity, realm, request, response, userId, sloRequest, sloResponse, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        }
    }

    private static boolean checkSLOResponse(LogoutResponse sloResponse, String requestID) throws SAML2Exception {
        boolean success = false;
        String retCode = sloResponse.getStatus().getStatusCode().getValue();
        if (retCode.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            String inResponseTo = sloResponse.getInResponseTo();
            if (inResponseTo.equals(requestID)) {
                if (debug.messageEnabled()) {
                    debug.message("LogoutUtil.doSLOBySOAP LogoutResponse inResponseTo matches LogoutRequest ID");
                }
            } else {
                debug.error("LogoutUtil.doSLOBySOAP LogoutResponse inResponseTo does not match Request ID.");
                throw new SAML2Exception(SAML2Utils.bundle.getString("inResponseToNoMatch"));
            }
            success = true;
        } else {
            if (debug.messageEnabled()) {
                debug.message("LogoutUtil.doSLOBySOAP : return code : " + retCode);
            }
            success = false;
        }
        return success;
    }

    static LogoutResponse forwardToRemoteServer(LogoutRequest logoutReq, String remoteLogoutURL) {
        if (debug.messageEnabled()) {
            debug.message("LogoutUtil.forwardToRemoteServer: remoteLogoutURL = " + remoteLogoutURL);
        }
        try {
            SOAPMessage resMsg = SAML2Utils.sendSOAPMessage(logoutReq.toXMLString(true, true), remoteLogoutURL);
            Element respElem = SAML2Utils.getSamlpElement(resMsg, "LogoutResponse");
            return ProtocolFactory.getInstance().createLogoutResponse(respElem);
        }
        catch (Exception ex) {
            if (debug.messageEnabled()) {
                debug.message("LogoutUtil.forwardToRemoteServer:", (Throwable)ex);
            }
            return null;
        }
    }

    static List getSessionIndex(LogoutResponse logoutRes) {
        StatusDetail statusDetail = logoutRes.getStatus().getStatusDetail();
        if (statusDetail == null) {
            return null;
        }
        List details = statusDetail.getAny();
        if (details == null || details.isEmpty()) {
            return null;
        }
        ArrayList<String> sessionIndexList = new ArrayList<String>();
        Iterator iter = details.iterator();
        while (iter.hasNext()) {
            String detail = (String)iter.next();
            Document doc = XMLUtils.toDOMDocument((String)detail, (Debug)debug);
            Element elem = doc.getDocumentElement();
            String localName = elem.getLocalName();
            if (!"SessionIndex".equals(localName)) continue;
            sessionIndexList.add(XMLUtils.getElementString((Element)elem));
        }
        return sessionIndexList;
    }

    static void setSessionIndex(Status status, List sessionIndex) {
        try {
            StatusDetail sd = ProtocolFactory.getInstance().createStatusDetail();
            status.setStatusDetail(sd);
            if (sessionIndex != null && !sessionIndex.isEmpty()) {
                ArrayList<String> details = new ArrayList<String>();
                Iterator iter = sessionIndex.iterator();
                while (iter.hasNext()) {
                    String si = (String)iter.next();
                    SessionIndex sIndex = ProtocolFactory.getInstance().createSessionIndex(si);
                    details.add(sIndex.toXMLString(true, true));
                }
                sd.setAny(details);
            }
        }
        catch (SAML2Exception e) {
            debug.error("LogoutUtil.setSessionIndex: ", (Throwable)((Object)e));
        }
    }

    public static String getSLOServiceLocation(List sloList, String desiredBinding) {
        String classMethod = "LogoutUtil.getSLOserviceLocation: ";
        int n = sloList.size();
        if (debug.messageEnabled()) {
            debug.message(classMethod + "Number of single logout services = " + n);
        }
        SingleLogoutServiceElement slos = null;
        String location = null;
        String binding = null;
        for (int i = 0; i < n; ++i) {
            slos = (SingleLogoutServiceElement)sloList.get(i);
            if (slos != null) {
                binding = slos.getBinding();
            }
            if (debug.messageEnabled()) {
                debug.message(classMethod + "Single logout service binding = " + binding);
            }
            if (binding == null || !binding.equals(desiredBinding)) continue;
            location = slos.getLocation();
            if (!debug.messageEnabled()) break;
            debug.message(classMethod + "Found the single logout service " + "with the desired binding");
            break;
        }
        return location;
    }

    public static String getSLOResponseServiceLocation(List sloList, String desiredBinding) {
        String classMethod = "LogoutUtil.getSLOResponseServiceLocation: ";
        int n = sloList.size();
        if (debug.messageEnabled()) {
            debug.message(classMethod + "Number of single logout services = " + n);
        }
        SingleLogoutServiceElement slos = null;
        String resLocation = null;
        String binding = null;
        for (int i = 0; i < n; ++i) {
            slos = (SingleLogoutServiceElement)sloList.get(i);
            if (slos != null) {
                binding = slos.getBinding();
            }
            if (debug.messageEnabled()) {
                debug.message(classMethod + "Single logout service binding = " + binding);
            }
            if (binding == null || !binding.equals(desiredBinding)) continue;
            resLocation = slos.getResponseLocation();
            if (!debug.messageEnabled()) break;
            debug.message(classMethod + "Found the single logout service " + "with the desired binding");
            break;
        }
        return resLocation;
    }

    private static Extensions createExtensions(List extensionsList) throws SAML2Exception {
        Extensions extensions = null;
        if (extensionsList != null && !extensionsList.isEmpty()) {
            extensions = ProtocolFactory.getInstance().createExtensions();
            extensions.setAny(extensionsList);
        }
        return extensions;
    }

    public static LogoutResponse generateResponse(Status status, String inResponseTo, Issuer issuer, String realm, String hostRole, String remoteEntity) {
        if (status == null) {
            status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success", SAML2Utils.bundle.getString("requestSuccess"));
        }
        LogoutResponse logoutResponse = ProtocolFactory.getInstance().createLogoutResponse();
        String responseID = SAMLUtils.generateID();
        try {
            logoutResponse.setStatus(status);
            logoutResponse.setID(responseID);
            logoutResponse.setInResponseTo(inResponseTo);
            logoutResponse.setVersion("2.0");
            logoutResponse.setIssueInstant(new Date());
            logoutResponse.setIssuer(issuer);
        }
        catch (SAML2Exception e) {
            debug.error("Error in generating LogoutResponse.", (Throwable)((Object)e));
        }
        return logoutResponse;
    }

    public static void signSLORequest(LogoutRequest sloRequest, String realm, String hostEntity, String hostEntityRole, String remoteEntity) throws SAML2Exception {
        LogoutUtil.signSLORequest(sloRequest, realm, hostEntity, hostEntityRole, remoteEntity, false);
    }

    static void signSLORequest(LogoutRequest sloRequest, String realm, String hostEntity, String hostEntityRole, String remoteEntity, boolean includeCert) throws SAML2Exception {
        String method = "signSLORequest : ";
        boolean needRequestSign = false;
        needRequestSign = hostEntityRole.equalsIgnoreCase("IDPRole") ? SAML2Utils.getWantLogoutRequestSigned(realm, remoteEntity, "SPRole") : SAML2Utils.getWantLogoutRequestSigned(realm, remoteEntity, "IDPRole");
        if (!needRequestSign) {
            if (debug.messageEnabled()) {
                debug.message(method + "SLORequest doesn't need to be signed.");
            }
            return;
        }
        String alias = SAML2Utils.getSigningCertAlias(realm, hostEntity, hostEntityRole);
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "hostEntity is : " + hostEntity);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
            debug.message(method + "Cert Alias is : " + alias);
            debug.message(method + "SLO Request before sign : " + sloRequest.toXMLString(true, true));
        }
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey == null) {
            debug.error("Incorrect configuration for Signing Certificate.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        sloRequest.sign(signingKey, signingCert);
        if (debug.messageEnabled()) {
            debug.message(method + "SLO Request after sign : " + sloRequest.toXMLString(true, true));
        }
    }

    public static boolean verifySLORequest(LogoutRequest sloRequest, String realm, String remoteEntity, String hostEntity, String hostEntityRole) throws SAML2Exception, SessionException {
        String method = "verifySLORequest : ";
        boolean needVerifySignature = SAML2Utils.getWantLogoutRequestSigned(realm, hostEntity, hostEntityRole);
        if (!needVerifySignature) {
            if (debug.messageEnabled()) {
                debug.message(method + "SLORequest doesn't need to be verified.");
            }
            return true;
        }
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "remoteEntity is : " + remoteEntity);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
        }
        boolean valid = false;
        X509Certificate signingCert = null;
        if (hostEntityRole.equalsIgnoreCase("IDPRole")) {
            SPSSODescriptorElement spSSODesc = metaManager.getSPSSODescriptor(realm, remoteEntity);
            signingCert = KeyUtil.getVerificationCert(spSSODesc, remoteEntity, "SPRole");
        } else {
            IDPSSODescriptorElement idpSSODesc = metaManager.getIDPSSODescriptor(realm, remoteEntity);
            signingCert = KeyUtil.getVerificationCert(idpSSODesc, remoteEntity, "IDPRole");
        }
        if (signingCert != null) {
            valid = sloRequest.isSignatureValid(signingCert);
            if (debug.messageEnabled()) {
                debug.message(method + "Signature is : " + valid);
            }
        } else {
            debug.error("Incorrect configuration for Signing Certificate.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        return valid;
    }

    public static void signSLOResponse(LogoutResponse sloResponse, String realm, String hostEntity, String hostEntityRole, String remoteEntity) throws SAML2Exception {
        LogoutUtil.signSLOResponse(sloResponse, realm, hostEntity, hostEntityRole, remoteEntity, false);
    }

    static void signSLOResponse(LogoutResponse sloResponse, String realm, String hostEntity, String hostEntityRole, String remoteEntity, boolean includeCert) throws SAML2Exception {
        String method = "signSLOResponse : ";
        boolean needSignResponse = false;
        needSignResponse = hostEntityRole.equalsIgnoreCase("IDPRole") ? SAML2Utils.getWantLogoutRequestSigned(realm, remoteEntity, "SPRole") : SAML2Utils.getWantLogoutRequestSigned(realm, remoteEntity, "IDPRole");
        if (!needSignResponse) {
            if (debug.messageEnabled()) {
                debug.message(method + "SLOResponse doesn't need to be signed.");
            }
            return;
        }
        String alias = SAML2Utils.getSigningCertAlias(realm, hostEntity, hostEntityRole);
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "hostEntity is : " + hostEntity);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
            debug.message(method + "Cert Alias is : " + alias);
        }
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey == null) {
            debug.error("Incorrect configuration for Signing Certificate.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        sloResponse.sign(signingKey, signingCert);
    }

    public static boolean verifySLOResponse(LogoutResponse sloResponse, String realm, String remoteEntity, String hostEntity, String hostEntityRole) throws SAML2Exception, SessionException {
        String method = "verifySLOResponse : ";
        boolean needVerifySignature = SAML2Utils.getWantLogoutResponseSigned(realm, hostEntity, hostEntityRole);
        if (!needVerifySignature) {
            if (debug.messageEnabled()) {
                debug.message(method + "SLOResponse doesn't need to be verified.");
            }
            return true;
        }
        boolean valid = false;
        X509Certificate signingCert = null;
        if (hostEntityRole.equalsIgnoreCase("IDPRole")) {
            SPSSODescriptorElement spSSODesc = metaManager.getSPSSODescriptor(realm, remoteEntity);
            signingCert = KeyUtil.getVerificationCert(spSSODesc, remoteEntity, "SPRole");
        } else {
            IDPSSODescriptorElement idpSSODesc = metaManager.getIDPSSODescriptor(realm, remoteEntity);
            signingCert = KeyUtil.getVerificationCert(idpSSODesc, remoteEntity, "IDPRole");
        }
        if (signingCert != null) {
            valid = sloResponse.isSignatureValid(signingCert);
            if (debug.messageEnabled()) {
                debug.message(method + "Signature is : " + valid);
            }
        } else {
            debug.error("Incorrect configuration for Signing Certificate.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        return valid;
    }

    static void setNameIDForSLORequest(LogoutRequest request, NameID nameID, String realm, String hostEntity, String hostEntityRole, String remoteEntity) throws SAML2Exception, SessionException {
        String method = "setNameIDForSLORequest: ";
        boolean needEncryptIt = false;
        needEncryptIt = hostEntityRole.equalsIgnoreCase("IDPRole") ? SAML2Utils.getWantNameIDEncrypted(realm, remoteEntity, "SPRole") : SAML2Utils.getWantNameIDEncrypted(realm, remoteEntity, "IDPRole");
        if (!needEncryptIt) {
            if (debug.messageEnabled()) {
                debug.message(method + "NamID doesn't need to be encrypted.");
            }
            request.setNameID(nameID);
            return;
        }
        EncInfo encryptInfo = null;
        KeyDescriptorType keyDescriptor = null;
        if (hostEntityRole.equalsIgnoreCase("IDPRole")) {
            SPSSODescriptorElement spSSODesc = metaManager.getSPSSODescriptor(realm, remoteEntity);
            keyDescriptor = KeyUtil.getKeyDescriptor(spSSODesc, "encryption");
            encryptInfo = KeyUtil.getEncInfo(spSSODesc, remoteEntity, "SPRole");
        } else {
            IDPSSODescriptorElement idpSSODesc = metaManager.getIDPSSODescriptor(realm, remoteEntity);
            keyDescriptor = KeyUtil.getKeyDescriptor(idpSSODesc, "encryption");
            encryptInfo = KeyUtil.getEncInfo(idpSSODesc, remoteEntity, "IDPRole");
        }
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "hostEntity is : " + hostEntity);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
            debug.message(method + "remoteEntity is : " + remoteEntity);
        }
        if (encryptInfo == null) {
            debug.error("NO meta data for encrypt Info.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        X509Certificate certificate = KeyUtil.getCert(keyDescriptor);
        PublicKey recipientPublicKey = certificate.getPublicKey();
        EncryptedID encryptedID = nameID.encrypt(recipientPublicKey, encryptInfo.getDataEncAlgorithm(), encryptInfo.getDataEncStrength(), remoteEntity);
        request.setEncryptedID(encryptedID);
    }

    static NameID getNameIDFromSLORequest(LogoutRequest request, String realm, String hostEntity, String hostEntityRole) throws SAML2Exception {
        String method = "getNameIDFromSLORequest: ";
        String alias = null;
        boolean needDecryptIt = SAML2Utils.getWantNameIDEncrypted(realm, hostEntity, hostEntityRole);
        if (!needDecryptIt) {
            if (debug.messageEnabled()) {
                debug.message(method + "NamID doesn't need to be decrypted.");
            }
            return request.getNameID();
        }
        alias = SAML2Utils.getEncryptionCertAlias(realm, hostEntity, hostEntityRole);
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "hostEntity is : " + hostEntity);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
            debug.message(method + "Cert Alias is : " + alias);
        }
        PrivateKey privateKey = keyProvider.getPrivateKey(alias);
        EncryptedID encryptedID = request.getEncryptedID();
        return encryptedID.decrypt(privateKey);
    }

    public static void sendSLOResponse(HttpServletResponse response, LogoutResponse sloResponse, String sloURL, String relayState, String realm, String hostEntity, String hostEntityRole, String remoteEntity) throws SAML2Exception {
        LogoutUtil.sendSLOResponseRedirect(response, sloResponse, sloURL, relayState, realm, hostEntity, hostEntityRole, remoteEntity);
    }

    public static void sendSLOResponse(HttpServletResponse response, LogoutResponse sloResponse, String sloURL, String relayState, String realm, String hostEntity, String hostEntityRole, String remoteEntity, String binding) throws SAML2Exception {
        if ("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(binding)) {
            LogoutUtil.sendSLOResponsePost(response, sloResponse, sloURL, relayState, realm, hostEntity, hostEntityRole, remoteEntity);
        } else {
            LogoutUtil.sendSLOResponseRedirect(response, sloResponse, sloURL, relayState, realm, hostEntity, hostEntityRole, remoteEntity);
        }
    }

    public static void sendSLOResponsePost(HttpServletResponse response, LogoutResponse sloResponse, String sloURL, String relayState, String realm, String hostEntity, String hostEntityRole, String remoteEntity) throws SAML2Exception {
        LogoutUtil.signSLOResponse(sloResponse, realm, hostEntity, hostEntityRole, remoteEntity);
        String logoutResponseStr = sloResponse.toXMLString(true, true);
        String encMsg = SAML2Utils.encodeForPOST(logoutResponseStr);
        try {
            SAML2Utils.postToTarget(response, "SAMLResponse", encMsg, "RelayState", relayState, sloURL);
        }
        catch (IOException ioe) {
            SAML2Utils.debug.error("LogoutUtil.sendSLOResponsePost:", (Throwable)ioe);
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorPostingLogoutResponse"));
        }
    }

    public static void sendSLOResponseRedirect(HttpServletResponse response, LogoutResponse sloResponse, String sloURL, String relayState, String realm, String hostEntity, String hostEntityRole, String remoteEntity) throws SAML2Exception {
        try {
            String logoutResXMLString = sloResponse.toXMLString(true, true);
            String encodedXML = SAML2Utils.encodeForRedirect(logoutResXMLString);
            StringBuffer queryString = new StringBuffer().append("SAMLResponse").append("=").append(encodedXML);
            if (relayState != null && relayState.length() > 0 && relayState.getBytes("UTF-8").length <= 80) {
                queryString.append("&").append("RelayState").append("=").append(URLEncDec.encode((String)relayState));
            }
            boolean needToSign = false;
            needToSign = hostEntityRole.equalsIgnoreCase("IDPRole") ? SAML2Utils.getWantLogoutResponseSigned(realm, remoteEntity, "SPRole") : SAML2Utils.getWantLogoutResponseSigned(realm, remoteEntity, "IDPRole");
            String signedQueryString = queryString.toString();
            if (needToSign) {
                signedQueryString = SAML2Utils.signQueryString(signedQueryString, realm, hostEntity, hostEntityRole);
            }
            String redirectURL = sloURL + (sloURL.contains("?") ? "&" : "?") + signedQueryString;
            if (debug.messageEnabled()) {
                debug.message("redirectURL :" + redirectURL);
            }
            String[] data = new String[]{sloURL};
            LogUtil.access(Level.INFO, "REDIRECT_TO_SP", data, null);
            response.sendRedirect(redirectURL);
        }
        catch (Exception e) {
            debug.error("Exception :", (Throwable)e);
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorRedirectingLogoutResponse"));
        }
    }

    public static String getSLOBindingInfo(HttpServletRequest request, String metaAlias, String hostEntityRole, String remoteEntityID) throws SAML2Exception {
        String binding = request.getParameter("binding");
        try {
            String realm;
            SingleLogoutServiceElement sloService;
            if (binding == null && (sloService = LogoutUtil.getSLOServiceElement(realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias), remoteEntityID, hostEntityRole, null)) != null) {
                binding = sloService.getBinding();
            }
        }
        catch (SessionException e) {
            debug.error("Invalid SSOToken", (Throwable)((Object)e));
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        if (binding == null) {
            debug.error("Incorrect configuration for SingleLogout Service.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        return binding;
    }

    private static SingleLogoutServiceElement getSLOServiceElement(String realm, String entityID, String hostEntityRole, String binding) throws SAML2MetaException, SessionException, SAML2Exception {
        SingleLogoutServiceElement sloService = null;
        String method = "getSLOServiceElement: ";
        if (debug.messageEnabled()) {
            debug.message(method + "Realm : " + realm);
            debug.message(method + "Entity ID : " + entityID);
            debug.message(method + "Host Entity Role : " + hostEntityRole);
        }
        if (hostEntityRole.equalsIgnoreCase("SPRole")) {
            sloService = LogoutUtil.getIDPSLOConfig(realm, entityID, binding);
        } else if (hostEntityRole.equalsIgnoreCase("IDPRole")) {
            sloService = LogoutUtil.getSPSLOConfig(realm, entityID, binding);
        } else {
            debug.error("Hosted Entity role is missing .");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullIDPEntityID"));
        }
        return sloService;
    }

    public static SingleLogoutServiceElement getIDPSLOConfig(String realm, String entityId, String binding) throws SAML2MetaException, SessionException {
        SingleLogoutServiceElement slo;
        block3: {
            slo = null;
            IDPSSODescriptorElement idpSSODesc = metaManager.getIDPSSODescriptor(realm, entityId);
            if (idpSSODesc == null) {
                debug.error("Identity Provider SSO config is missing.");
                return null;
            }
            List list = idpSSODesc.getSingleLogoutService();
            if (list == null || list.isEmpty()) break block3;
            if (binding == null) {
                return (SingleLogoutServiceElement)list.get(0);
            }
            Iterator it = list.iterator();
            while (it.hasNext() && !binding.equalsIgnoreCase((slo = (SingleLogoutServiceElement)it.next()).getBinding())) {
            }
        }
        return slo;
    }

    public static SingleLogoutServiceElement getSPSLOConfig(String realm, String entityId, String binding) throws SAML2MetaException, SessionException {
        SingleLogoutServiceElement slo;
        block3: {
            slo = null;
            SPSSODescriptorElement spSSODesc = metaManager.getSPSSODescriptor(realm, entityId);
            if (spSSODesc == null) {
                return null;
            }
            List list = spSSODesc.getSingleLogoutService();
            if (list == null || list.isEmpty()) break block3;
            if (binding == null) {
                return (SingleLogoutServiceElement)list.get(0);
            }
            Iterator it = list.iterator();
            while (it.hasNext() && !binding.equalsIgnoreCase((slo = (SingleLogoutServiceElement)it.next()).getBinding())) {
            }
        }
        return slo;
    }

    public static List getExtensionsList(Map paramsMap) {
        List extensionsList = null;
        return extensionsList;
    }

    private static void doSLOByPOST(String requestID, String sloRequestXMLString, String sloURL, String relayState, String realm, String hostEntity, String hostRole, HttpServletResponse response) throws SAML2Exception, SessionException {
        if (debug.messageEnabled()) {
            debug.message("LogoutUtil.doSLOByPOST : SLORequestXML: " + sloRequestXMLString + "\nPOSTURL : " + sloURL);
            debug.message("LogoutUtil.doSLOByPOST : relayState : " + sloRequestXMLString + "\nPOSTURL : " + relayState);
        }
        String encMsg = SAML2Utils.encodeForPOST(sloRequestXMLString);
        try {
            SAML2Utils.postToTarget(response, "SAMLRequest", encMsg, "RelayState", relayState, sloURL);
        }
        catch (Exception e) {
            debug.error("LogoutUtil.doSLOByPOST:", (Throwable)e);
            throw new SAML2Exception(SAML2Utils.bundle.getString("postToTargetFailed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LogoutResponse getLogoutResponseFromPost(String samlResponse, HttpServletResponse response) throws SAML2Exception {
        if (samlResponse == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingLogoutResponse"));
        }
        LogoutResponse resp = null;
        ByteArrayInputStream bis = null;
        try {
            Document doc;
            byte[] raw = Base64.decode((String)samlResponse);
            if (raw != null && (doc = XMLUtils.toDOMDocument((InputStream)(bis = new ByteArrayInputStream(raw)), (Debug)debug)) != null) {
                resp = ProtocolFactory.getInstance().createLogoutResponse(doc.getDocumentElement());
            }
        }
        catch (Exception e) {
            debug.error("LogoutUtil.getLogoutResponseFromPost:", (Throwable)e);
        }
        finally {
            block16: {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception ie) {
                        if (!debug.messageEnabled()) break block16;
                        debug.message("LogoutUtil.getLogoutResponseFromPost:", (Throwable)ie);
                    }
                }
            }
        }
        if (resp == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorGettingLogoutResponse"));
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LogoutRequest getLogoutRequestFromPost(String samlRequest, HttpServletResponse response) throws SAML2Exception {
        if (samlRequest == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingLogoutRequest"));
        }
        LogoutRequest req = null;
        ByteArrayInputStream bis = null;
        try {
            Document doc;
            byte[] raw = Base64.decode((String)samlRequest);
            if (raw != null && (doc = XMLUtils.toDOMDocument((InputStream)(bis = new ByteArrayInputStream(raw)), (Debug)debug)) != null) {
                req = ProtocolFactory.getInstance().createLogoutRequest(doc.getDocumentElement());
            }
        }
        catch (Exception e) {
            debug.error("LogoutUtil.getLogoutRequestFromPost:", (Throwable)e);
        }
        finally {
            block16: {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception ie) {
                        if (!debug.messageEnabled()) break block16;
                        debug.message("LogoutUtil.getLogoutRequestFromPost:", (Throwable)ie);
                    }
                }
            }
        }
        if (req == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorGettingLogoutRequest"));
        }
        return req;
    }

    static {
        metaManager = SAML2Utils.getSAML2MetaManager();
    }
}

